/*   getopt.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>

#include "std.h"
#include "getopt.h"

/*------------------------------------------------------------------------*/

       INT_2    opterr = 0;
       INT_2    optind = 0;
STATIC BOOLEAN  found  = FALSE;
STATIC INT_2    pchar  = 0;

/*------------------------------------------------------------------------*/


GLOBAL CHAR *argopt( SIZE_T argc, CHAR *argv[] )
{
 CHAR  *arg;

   pchar = 0;
   arg   = NULL;
   if ( optind < (INT_2) argc ) {
      arg = argv[optind++];
   }
   return( arg );

} /* argopt */


GLOBAL INT_2 getopt( SIZE_T argc, CHAR *argv[], CHAR *options )
{
 INT_2  xch;

   if ( optind == 0 ) {
      found  = FALSE;
      pchar  = 0;
      optind = 1;
   }

x_again:

   if ( optind >= (INT_2) argc ) {
      xch = -1;
      goto x_done;
   }

   xch = argv[optind][pchar];

   if ( pchar == 0 ) {
      if ( xch == '-' ) {
         pchar++;
         goto x_again;
      }
      if ( xch == '?' )
         goto x_done;
      if ( xch == 0 ) {
         optind++;
         pchar = 0;
         goto x_again;
      }
      xch = -1;
      goto x_done;
   }

   if ( xch == 0 ) {
      optind++;
      pchar = 0;
      goto x_again;
   }

   if ( strchr(options, xch) != NULL ) {
      found = TRUE;
      pchar++;
      goto x_done;
   } else {
      found = FALSE;
   }

   if ( found )
      xch = -1;
   else
      xch = '?';

x_done:

   return( xch );

} /* getopt */


/*------------------------------------------------------------------------*/


