/*   fnmatch.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include "std.h"
#include "fnmatch.h"

/*------------------------------------------------------------------------*/

#define _DS       '/'

#define TSTCASE   (flags & FNM_CASEFOLD) != 0
#define DOCASE(x) (TSTCASE) ? LOWER(x) : x

#define BEGFNAME  (s==string) || (((flags&FNM_FILENAME)!=0) && (s[-1]==_DS))

/*------------------------------------------------------------------------*/


/*------------------------------------------------------*
 |  Match STRING against the filename pattern PATTERN,  |
 |  returning zero if it matches, nonzero if not.       |
 *------------------------------------------------------*/
INT_2 fnmatch( CHAR *pattern, CHAR *string, INT_2 flags )
{
 CHAR      *p     = pattern;
 CHAR      *s     = string;
 CHAR       ch;
 CHAR       uch;
 CHAR       tmp;
 BOOLEAN    not;
 CHAR       cstart;
 CHAR       cend;
 BOOLEAN    skip;

   // loop thru each char in pattern
   while ( TRUE ) {

      // get next, test for completion
      ch = *p++;
      if ( ch == 0 )
         break;

      // scan for ?
      if ( ch == '?' ) {
         if ( *s == 0 )
            return( FNM_NOMATCH );
         if ( ((flags & FNM_FILENAME) != 0) && (*s == _DS) )
            return( FNM_NOMATCH );
         if ( ((flags & FNM_PERIOD) != 0) && (*s == '.') && (BEGFNAME) )
            return( FNM_NOMATCH );
         s++;
         continue;
      }

      // escape char
      if ( ch == '\\' ) {
         if ( (flags & FNM_NOESCAPE) == 0 )
            ch = *p++;
         uch = *s;
         if ( TSTCASE ) {
            uch = LOWER(*s);
            ch  = LOWER(ch);
         }
         if ( uch != ch )
            return( FNM_NOMATCH );
         s++;
         continue;
      }

      // star char
      if ( ch == '*' ) {
         if ( ((flags & FNM_PERIOD) != 0) && (*s == '.') && (BEGFNAME) )
            return( FNM_NOMATCH );
         for( ch=*p++; ((ch == '?') || (ch == '*'));  ch=*p++, ++s ) {
            if (
                (((flags & FNM_FILENAME) != 0) && (*s == _DS)) ||
                ((ch == '?') && (*s == 0))
               )
               return( FNM_NOMATCH );
         }
         if ( ch == 0 )
            return( FNM_MATCH );
         tmp = ((flags & FNM_NOESCAPE) == 0) ? *p : ch ;
         if ( TSTCASE )
            tmp = LOWER(tmp);
         for( --p; (*s != 0); ++s ) {
            uch = DOCASE(*s);
            if (
                 ((ch == '[') || (uch == tmp))                       &&
                 (fnmatch(p, s, (flags & ~FNM_PERIOD)) == FNM_MATCH)
               )
               return( FNM_MATCH );
         }
         return( FNM_NOMATCH );
      }

      // [ case
      if ( ch == '[' ) {
         if ( *s == 0 )
            return( FNM_NOMATCH );
         if ( ((flags & FNM_PERIOD) != 0) && (*s == '.') && (BEGFNAME) )
            return( FNM_NOMATCH );
         not = (BOOLEAN) ( (*p == '!') || (*p == '^') );
         if ( not )
            ++p;
         ch     = *p++;
         cstart =
         cend   = ch;
         skip   = FALSE;
         while (TRUE) {
            if ( ((flags & FNM_NOESCAPE) == 0) && (ch == '\\') ) {
               cstart =
               cend   = *p++;
            }
            if ( TSTCASE ) {
               cstart =
               cend   = LOWER(cstart);
            }
            /* [ (unterminated) loses */
            if ( ch == 0 )
               return( FNM_NOMATCH );
            ch = *p++;
            ch = DOCASE(ch);
            /* [/] can never match */
            if ( ((flags & FNM_FILENAME) != 0) && (ch == _DS) )
               return( FNM_NOMATCH );
            if ( (ch == '-') && (*p != ']') ) {
               cend = *p++;
               if ( ((flags & FNM_NOESCAPE) == 0) && (cend == '\\') )
                  cend = *p++;
               if ( cend == 0 )
                  return( FNM_NOMATCH );
               cend = DOCASE(cend);
               ch   = *p++;
            }
            uch = DOCASE(*s);
            if ( (uch >= cstart) && (uch <= cend) ) {
               skip = TRUE;
               break;
            }
            if ( ch == ']' )
               break;
         } /* endwhile */
         if ( skip ) {
            while (ch != ']') {
               /* [... (unterminated) losses */
               if ( ch == 0 )
                  return( FNM_NOMATCH );
               ch = *p++;
               /* XXX 1003.2d11 is unclear if this is right */
               if ( ((flags & FNM_NOESCAPE) == 0) && (ch == '\\') )
                  ++p;
            }
            if ( not )
               return( FNM_MATCH );
         } else {
            if ( !not )
               return( FNM_MATCH );
         }
      } /* endif [ */

      // otherwise default case
      uch = *s;
      if ( TSTCASE ) {
         uch = LOWER(*s);
         ch  = LOWER(ch);
      }
      if ( ch != uch )
         return( FNM_NOMATCH );
      s++;

   } /* endwhile */

   // perfect match
   if ( *s == 0 )
      return( FNM_MATCH );

   // leading match
   if ( ((flags & FNM_TRAILING_DIR) != 0) && (*s == '/') )
      return( FNM_MATCH );

   // otherwise nomatch
   return( FNM_NOMATCH );

} /* fnmatch */


/*------------------------------------------------------------------------*/


#if 0
INT_2 fnmatch( CHAR *pattern, CHAR *string, INT_2 flags )
{
 CHAR   *p  = pattern;
 CHAR   *n  = string;
 CHAR    c;

   while ((c = *p++) != '\0') {
      c = FOLD(c);
      switch (c) {
         case '?':
            if (*n == '\0')
               return FNM_NOMATCH;
            else if ((flags & FNM_FILENAME) && *n == '/')
               return FNM_NOMATCH;
            else if ((flags & FNM_PERIOD) && *n == '.' &&
                  (n == string || ((flags & FNM_FILENAME) && n[-1] == '/')))
               return FNM_NOMATCH;
            break;
         case '\\':
            if (!(flags & FNM_NOESCAPE)) {
               c = *p++;
               c = FOLD (c);
            }
            if (FOLD (*n) != c)
               return FNM_NOMATCH;
            break;
         case '*':
            if ((flags & FNM_PERIOD) && *n == '.' &&
                (n == string || ((flags & FNM_FILENAME) && n[-1] == '/')))
               return FNM_NOMATCH;

            for (c = *p++; c == '?' || c == '*'; c = *p++, ++n)
               if (((flags & FNM_FILENAME) && *n == '/') ||
                   (c == '?' && *n == '\0'))
                  return FNM_NOMATCH;

            if (c == '\0')
               return 0;
            {
             char c1 = (!(flags & FNM_NOESCAPE) && c == '\\') ? *p : c;

               c1 = FOLD (c1);
               for (--p; *n != '\0'; ++n)
                  if ((c == '[' || FOLD (*n) == c1) &&
                      fnmatch (p, n, flags & ~FNM_PERIOD) == 0)
                     return 0;
               return FNM_NOMATCH;
            }
         case '[':
            {
            /* Nonzero if the sense of the character class is inverted.  */
            int not;

               if (*n == '\0')
                  return FNM_NOMATCH;

               if ((flags & FNM_PERIOD) && *n == '.' &&
                   (n == string || ((flags & FNM_FILENAME) && n[-1] == '/')))
                  return FNM_NOMATCH;

               not = (*p == '!' || *p == '^');
               if (not)
                  ++p;
               c = *p++;
               for (;;) {
                  char cstart = c, cend = c;

                  if (!(flags & FNM_NOESCAPE) && c == '\\')
                     cstart = cend = *p++;

                  cstart = cend = FOLD (cstart);

                  /* [ (unterminated) loses.  */
                  if (c == '\0')
                     return FNM_NOMATCH;

                  c = *p++;
                  c = FOLD (c);

                  /* [/] can never match.  */
                  if ((flags & FNM_FILENAME) && c == '/')
                     return FNM_NOMATCH;

                  if (c == '-' && *p != ']') {
                     cend = *p++;
                     if (!(flags & FNM_NOESCAPE) && cend == '\\')
                        cend = *p++;
                     if (cend == '\0')
                        return FNM_NOMATCH;
                     cend = FOLD (cend);

                     c = *p++;
                  }

                  if (FOLD (*n) >= cstart && FOLD (*n) <= cend)
                     goto matched;

                  if (c == ']')
                     break;
               }
               if (!not)
                  return FNM_NOMATCH;
               break;

         matched:;
               /* Skip the rest of the [...] that already matched.  */
               while (c != ']') {

                  /* [... (unterminated) loses.  */
                  if (c == '\0')
                     return FNM_NOMATCH;

                  c = *p++;
                  /* XXX 1003.2d11 is unclear if this is right.  */
                  if (!(flags & FNM_NOESCAPE) && c == '\\')
                     ++p;
               }
               if (not)
                  return FNM_NOMATCH;
            }
            break;
         default:
            if (c != FOLD (*n))
               return FNM_NOMATCH;
         }
         ++n;
      }

   if (*n == '\0')
      return 0;

   /* The FNM_LEADING_DIR flag says that "foo*" matches "foobar/frobozz". */
   if ((flags & FNM_LEADING_DIR) && *n == '/')
      return 0;

   return FNM_NOMATCH;

} /* fnmatch */
#endif


/*------------------------------------------------------------------------*/



