/*   errhdl.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "std.h"

/*------------------------------------------------------------------------*/

STATIC TAGDESC_TYP   errlist[] = {
  { ERR_SYS_NOMEM,      "System memory pool exhausted"               },
  { ERR_SYS_DEVICE,     "System Device/Port error"                   },
  { ERR_SYS_PERM,       "System level permission error"              },
  { ERR_ST_UNDERFLOW,   "Symbol table undeflow"                      },
  { ERR_CMD_FILENAME,   "Filename for execution is bad"              },
  { ERR_CMD_RETURN,     "Cannot 'RETURN' from keyboard stack"        },
  { ERR_CMD_UNKNOWN,    "Bad or Unknown command"                     },
  { ERR_P_NOTOKENS,     "End of token-stream on command-line"        },
  { ERR_P_CTL_LOOP,     "Control-Loop command out of context"        },
  { ERR_P_SETTING,      "Invalid settings for specificed command"    },
  { ERR_INP_UNDERFLOW,  "Input stack underflow"                      },
  { ERR_INP_OVERFLOW,   "Input stack overflow"                       },
  { ERR_INP_FNAME,      "Cannot locate file"                         },
  { ERR_INP_MAXTOKBUF,  "Max token buffer length is reached"         },
  { ERR_INP_PARSE1,     "Missing ']' on token"                       },
  { ERR_SEM_BADNUM1,    "Ill-formatted number 1"                     },
  { ERR_SEM_BADNUM2,    "Ill-formatted number 2"                     },
  { ERR_SEM_BADNUM3,    "Ill-formatted number 3"                     },
  { ERR_SEM_TYPE,       "Type-Declaration syntax invalid"            },
  { ERR_SEM_VARDEFINED, "Variable previously defined"                },
  { ERR_SEM_BRACES,     "Usage of braces in error"                   },
  { ERR_SEM_CHAR,       "Character length is invalid"                },
  { ERR_SEM_ARRIDX,     "Array index is out-of-bounds"               },
  { ERR_SEM_BADTOKEN,   "Bad token in expression"                    },
  { ERR_SEM_BADLINE,    "Bad cmd or expression"                      },
  { ERR_SEM_REF,        "Invalid argument reference"                 },
  { ERR_SEM_BADFDECL,   "Bad function declaration"                   },
  { ERR_SEM_BADFUNC,    "Bad function name reference"                },
  { ERR_SEM_NOFUNC,     "Function not found"                         },
  { ERR_SEM_BADARGS,    "Bad arguments to function"                  },
  { ERR_SEM_DEL,        "Invalid deletion requested"                 },
  { ERR_EXP_QPUSH,      "Bad expression push"                        },
  { ERR_EXP_QPOP,       "Bad expression pop"                         },
  { ERR_EXP_ARG1,       "Bad expression arg 1"                       },
  { ERR_EXP_ARG2,       "Bad expression arg 2"                       },
  { ERR_EXP_ARG3,       "Bad expression arg 3"                       },
  { ERR_EXP_TIME,       "Bad arg to time routines"                   },
  { ERR_EXP_OVERFLOW,   "Expression stack overflow"                  },
  { 0,                  NULL                                         }
};
#define errlist_len ( (sizeof(errlist)/sizeof(errlist[0])) - 1 )

STATIC TAGDESC_TYP   usrlist[MAXUSR_ERRORS]  = { { 0, }, };
STATIC INT_U2        usrlist_len             = 0;

GLOBAL INT_2         errs_len                = 0;
GLOBAL INT_2         errs[MAX_ERRORS]        = { 0, };

/*------------------------------------------------------------------------*/


GLOBAL VOID setusr_err( INT_2 errnum, CHAR *ptext )
{
 INT_2  i;

   if ( usrlist_len >= MAXUSR_ERRORS )
      return;
   for( i=0; (i < usrlist_len); i++ ) {
      if ( errnum == usrlist[i].value )
         return;
   }
   usrlist[ usrlist_len ].value = errnum;
   usrlist[ usrlist_len ].desc  = ptext;
   usrlist_len++;
   return;

} /* setusr_err */


GLOBAL INT_2 set_errhdl( INT_2 errnum )
{

   if ( errs_len < MAX_ERRORS-1 )
      errs[errs_len++] = errnum;
   return( errnum );

} /* set_errhdl */


GLOBAL VOID clr_errhdl( VOID )
{
 INT_2   i;

   for( i=0; (i < MAX_ERRORS); i++ ) {
      errs[i] = 0;
   }
   errs_len = 0;
   return;

} /* clr_errhdl */


STATIC VOID l_errhdl( CHAR *ptext, BOOLEAN l_exit, FILE *fp )
{
 INT_2    i;
 INT_2    j;
 CHAR    *pdesc;

   fprintf( fp, "\n" );
   for( i=0; (i < errs_len); i++ ) {
      pdesc = "Unknown error";
      for( j=0; ((INT_U2) j < errlist_len); j++ ) {
         if ( errs[i] == errlist[j].value ) {
            pdesc = errlist[j].desc;
            break;
         }
      }
      if ( j >= (INT_2) errlist_len ) {
         for( j=0; ((INT_U2) j < usrlist_len); j++ ) {
            if ( errs[i] == usrlist[j].value ) {
               pdesc = usrlist[j].desc;
               break;
            }
         }
      }
      fprintf( fp, "%s (%04X): %s\n", ptext, errs[i], pdesc );
      errs[i] = 0;
   }
   errs[0]  = 
   errs_len = 0;
   if ( l_exit )
      exit( 1 );
   else
      return;

} /* xerrhdl */


GLOBAL VOID xerrhdl( CHAR *ptext, FILE *fp )
{

   l_errhdl( ptext, TRUE, fp );

} /* xerrhdl */


GLOBAL VOID errhdl( CHAR *ptext, FILE *fp )
{

   l_errhdl( ptext, FALSE, fp );
   return;

} /* errhdl */


/*------------------------------------------------------------------------*/


