/*   datetime.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include "std.h"
#include "datetime.h"

/*------------------------------------------------------------------------*/

GLOBAL CHAR *montxt[] = {
  "JAN",
  "FEB",
  "MAR",
  "APR",
  "MAY",
  "JUN",
  "JUL",
  "AUG",
  "SEP",
  "OCT",
  "NOV",
  "DEC"
};

GLOBAL INT_U2 days[] = {
   31,         /* jan       */
   29,         /* feb       */
   31,         /* mar       */
   30,         /* apr       */
   31,         /* may       */
   30,         /* jun       */
   31,         /* jul       */
   31,         /* august    */
   30,         /* september */
   31,         /* october   */
   30,         /* november  */
   31          /* december  */
};

GLOBAL CHAR *schedules[] = {
   "Daily Schedule",
   "Weekend Schedule",
   "Holiday 1 Schedule",
   "Holiday 2 Schedule"
};

GLOBAL CHAR *days_of_week[] = {
   "SUN",
   "MON",
   "TUES",
   "WEDS",
   "THURS",
   "FRI",
   "SAT"
};

GLOBAL CODETOTEXT tz_tbl[]= {
   {  1, "-12:00" },
   {  2, "-11:30" },
   {  3, "-11:00" },
   {  4, "-10:30" },
   {  5, "-10:00" },
   {  6, "-09:30" },
   {  7, "-09:00" },
   {  8, "-08:30" },
   {  9, "-08:00" },
   { 10, "-07:30" },
   { 11, "-07:00" },
   { 12, "-06:30" },
   { 13, "-06:00" },
   { 14, "-05:30" },
   { 15, "-05:00" },
   { 16, "-04:30" },
   { 17, "-04:00" },
   { 18, "-03:30" },
   { 19, "-03:00" },
   { 20, "-02:30" },
   { 21, "-02:00" },
   { 22, "-01:30" },
   { 23, "-01:00" },
   { 24, "-00:30" },
   { 25, " 00:00" },
   { 26, " 00:30" },
   { 27, " 01:00" },
   { 28, " 01:30" },
   { 29, " 02:00" },
   { 30, " 02:30" },
   { 31, " 03:00" },
   { 32, " 03:30" },
   { 33, " 04:00" },
   { 34, " 04:30" },
   { 35, " 05:00" },
   { 36, " 05:30" },
   { 37, " 06:00" },
   { 38, " 06:30" },
   { 39, " 07:00" },
   { 40, " 07:30" },
   { 41, " 08:00" },
   { 42, " 08:30" },
   { 43, " 09:00" },
   { 44, " 09:30" },
   { 45, " 10:00" },
   { 46, " 10:30" },
   { 47, " 11:00" },
   { 48, " 11:30" },
   { 49, " 12:00" },
   {  0, NULL     }
};

/*------------------------------------------------------------------------*/


/*+
 *      NAME : time_sec
 *
 *  FUNCTION : return the current clock tick
 *
 *     ENTRY : none
 *
 *   RETURNS : UINT32 binary time buffer
 *
-*/
GLOBAL INT_U4 time_sec( VOID )
{   
 time_t  clock;

   memset( &clock, 0, sizeof(clock) );
   if ( (long) time(&clock) == -1 ) {
      return(0);
   }
   return( (INT_U4) clock );

} /* time_sec */


/*+
 *      NAME : str_timdat
 *
 *  FUNCTION : given a clock buffer, translate it to human readable form
 *
 *     ENTRY : clock  -> binary clock tick
 *             buffer -> user output buffer
 *
 *   RETURNS : none
 *
-*/
GLOBAL VOID str_timdat( INT_U4 clock, CHAR *buffer, INT_2 yfmt=2 )
{   
 struct tm    *tim_ptr; 
 time_t        timsec;
 UCHAR         day;
 UCHAR         year;
 CHAR         *mon_ptr;
 UCHAR         hour;      
 UCHAR         min;      
 UCHAR         sec;

   timsec  = clock;
   tim_ptr = localtime(&timsec);

   day     = tim_ptr->tm_mday;         /* day of month (1-31)        */
   mon_ptr = montxt[tim_ptr->tm_mon];  /* month of year (0-11)       */
   hour    = tim_ptr->tm_hour;         /* tod, hours (24 hour clock) */
   min     = tim_ptr->tm_min;          /* tod, minutes               */
   sec     = tim_ptr->tm_sec;          /* tod, seconds               */
   year    = tim_ptr->tm_year % 100;   /* year - 1900                */

   if ( (yfmt != 2) && (yfmt != 4) )
      yfmt = 2;

   if ( yfmt == 2 ) {
      sprintf( buffer, "%s-%02d-%02d %02d:%02d:%02d",
               mon_ptr, day, year, hour, min, sec );
   } else {
      sprintf( buffer, "%s %02d, %04d %02d:%02d:%02d",
               mon_ptr, day, year+1900, hour, min, sec );
   }
   return;

} /* str_timdat */


/*+
 *      NAME : time_date_stamp
 *
 *  FUNCTION : translate current date/time to a human readable form
 *             use the MM-DD-YY format.
 *
 *     ENTRY : buffer -> user output buffer
 *
 *   RETURNS : none
 *
-*/
GLOBAL VOID time_date_stamp( CHAR *buffer )
{   
 struct tm    *tim_ptr; 
 time_t        timesec;
 UCHAR         day;
 UCHAR         year;
 CHAR         *mon_ptr;
 UCHAR         hour;      
 UCHAR         min;      
 UCHAR         sec;
     
   if ( (long) time(&timesec) == -1 ) {
      *buffer = 0;
      return;
   }

   tim_ptr = localtime(&timesec);      
   day     = tim_ptr->tm_mday;         /* day of month (1-31)        */
   mon_ptr = montxt[tim_ptr->tm_mon];  /* month of year (0-11)       */
   hour    = tim_ptr->tm_hour;         /* tod, hours (24 hour clock) */
   min     = tim_ptr->tm_min;          /* tod, minutes               */
   sec     = tim_ptr->tm_sec;          /* tod, seconds               */
   year    = tim_ptr->tm_year % 100;   /* year - 1900                */

   sprintf( buffer,
            "%02d-%s-%02d %02d:%02d:%02d",
            day, mon_ptr, year, hour, min, sec );
   return;

} /* time_date_stamp */


/*+
 *      NAME : gettime
 *
 *  FUNCTION : translate the current date/time to human readable form.
 *             use the MM-DD-YYYY format.
 *
 *     ENTRY : buffer -> user output buffer
 *
 *   RETURNS : none
 *
-*/
GLOBAL VOID gettime( CHAR *buffer )
{
 struct tm    *tim_ptr; 
 time_t        timesec;
 UCHAR         day;
 INT_U2        year;
 CHAR         *mon_ptr;
 UCHAR         hour;      
 UCHAR         min;      
 UCHAR         sec;
     
   if ( (long) time(&timesec) == -1 ) {
      *buffer = 0;
      return;
   }

   tim_ptr = localtime(&timesec);      
   day     = tim_ptr->tm_mday;         /* day of month (1-31)        */
   mon_ptr = montxt[tim_ptr->tm_mon];  /* month of year (0-11)       */
   hour    = tim_ptr->tm_hour;         /* tod, hours (24 hour clock) */
   min     = tim_ptr->tm_min;          /* tod, minutes               */
   sec     = tim_ptr->tm_sec;          /* tod, seconds               */
   year    = tim_ptr->tm_year + 1900;  /* year                       */

   sprintf( buffer,
            "%02d-%s-%4d %02d:%02d:%02d",
            day, mon_ptr, year, hour, min, sec );
   return;

} /* gettime */


/*------------------------------------------------------------------------*/


