/*   cgets.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#ifdef GO32
//   #ifndef _DOS32
//   #define _DOS32
//   #define DOS386
//   #endif
   #define _MING
#endif
#ifdef _WIN32
   #ifndef _MING
   #define _MING
   #endif
#endif

#if defined(_DOS32)
   #include <dos.h>
#else
  #ifndef _MING
    extern "C" {
       #include <readline/readline.h>
       #include <readline/history.h>
    };
    #include <malloc.h>
  #endif
#endif

#include "std.h"
#include "cgets.h"

/*------------------------------------------------------------------------*/
#if defined(_DOS32)


#if 0
   #ifdef _XDOS
      #define INT86X int86x_real
   #else
      #define INT86X int86x
   #endif
#endif


GLOBAL BOOLEAN xdos_alloc( INT_U2 *nseg, INT_U2 bytes )
{
 union REGS   regs;
 struct SREGS sregs;

   bytes     = (bytes >> 4) + 1;
   regs.h.ah = 0x48;
   regs.x.bx = bytes;
   INT86X( 0x21, &regs, &regs, &sregs );
   *nseg     = ( regs.x.cflag ) ? regs.x.bx : regs.x.ax;
   return( ( regs.x.cflag ) ? FALSE : TRUE );

} /* xdos_alloc */


GLOBAL BOOLEAN xdos_free( INT_U2 nseg )
{
 union  REGS  regs;
 struct SREGS sregs;

   regs.h.ah = 0x49;
   sregs.es  = nseg;
   INT86X( 0x21, &regs, &regs, &sregs );
   return( (regs.x.cflag) ? FALSE : TRUE );

} /* xdos_free */


STATIC VOID xdos_gets( INT_U2 bseg, INT_U2 boff )
{
 union  REGS  regs;
 struct SREGS sregs;

   regs.h.ah = 0x0a;
   regs.x.dx = boff;
   sregs.ds  = bseg;
   INT86X( 0x21, &regs, &regs, &sregs );
   return;

} /* xdos_gets */


GLOBAL CHAR *cgets( CHAR *ubuf )
{
 CHAR FAR  *ptr;
 CHAR      *ans;
 INT_U2     dosseg;
 INT_2      i, len;

   ans  = ubuf;
   *ans = 0;
   if ( !xdos_alloc(&dosseg,256) )
      return( NULL );

   ptr  = MAKE_FP( dosseg, 0 );
   for (i=0; i<256; i++ )
      ptr[i] = 0;
   *ptr = 254;
   xdos_gets( dosseg, 0 );
   len       = ptr[1];
   ptr      += 2;
   ptr[len]  = 0;
   for ( i=0; i<=len; i++ )
      *ans++ = *ptr++;

   if ( !xdos_free(dosseg) )
      ubuf = NULL;

   putchar('\n');
   return( ubuf );

} /* cgets */


/*------------------------------------------------------------------------*/
#else


  #ifndef _MING


GLOBAL CHAR *cgets( CHAR *ubuf, CHAR *prompt )
{
 CHAR     dummy[2];
 CHAR    *pstr;
 CHAR    *ptmp;

   dummy[0] = 0;
   ubuf[0]  = 0;
   if (prompt == NULL)
      prompt = dummy;
   pstr = readline(prompt);
   if ( pstr != NULL ) {
      strcpy( ubuf, pstr );
      ptmp = pstr;
      while ( *ptmp == ' ' )
         ptmp++;
      if ( *ptmp != 0 )
         add_history(pstr);
      free( pstr );
   }
   return( ubuf );

} /* cgets */

   #else

GLOBAL CHAR *cgets( CHAR *ubuf, CHAR *prompt )
{

   printf("%s", prompt);
   gets(ubuf);
   return(ubuf);

} /* cgets */

   #endif


#endif
/*------------------------------------------------------------------------*/

