/*   std.h : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __STD_H
#define __STD_H


/*------------------------------------------------------------------------*/

#define THIS                     this
#define PUBLIC                   public
#define PRIVATE                  private
#define PROTECTED                protected
#define VIRTUAL                  virtual
#define FRIEND                   friend
#define INLINE                   inline
#define OVERLOAD                 overload

#define NEW                      new
#define DELETE                   delete

#define EXTERN                   extern
#define STATIC                   static
#define GLOBAL

#ifndef TRUE
#define TRUE                     1
#endif
#ifndef FALSE
#define FALSE                    0
#endif

#define VOID                  void
typedef char                  CHAR;
typedef unsigned char         UCHAR;
typedef short                 INT_2;
typedef unsigned short        INT_U2;
typedef long                  INT_4;
typedef unsigned long         INT_U4;
typedef double                DOUBLE;
typedef long double           LDOUBLE;
typedef unsigned short        BOOLEAN;
typedef void *                pVOID;
typedef char *                pCHAR;

#define SIZE_T                    size_t
#define FPOS_T                    fpos_t

#define UPPER(ch)       ( (((UCHAR) (ch-'a')) < 26) ? (ch & 0xDF) : ch )
#define LOWER(ch)       ( (((UCHAR) (ch-'A')) < 26) ? (ch | 0x20) : ch )

#define MAX_CHAR              0x7F
#define MIN_CHAR             -0x80
#define MAX_UCHAR             0xFF
#define MIN_UCHAR             0x00
#define MAX_INT_2             0x7FFF
#define MIN_INT_2            -0x8000
#define MAX_INT_U2            0xFFFF
#define MIN_INT_U2            0x0000
#define MAX_INT_4             0x7FFFFFFF
#define MIN_INT_4            -0x80000000
#define MAX_INT_U4            0xFFFFFFFF
#define MIN_INT_U4            0x00000000
#define MAX_FLOAT             3.402823466E+38F
#define MIN_FLOAT             1.175494351E-38F
#define MAX_DOUBLE            1.7976931348623157E+308
#define MIN_DOUBLE            2.2250738585072014E-308
#define MAX_LDOUBLE           MAX_DOUBLE
#define MIN_LDOUBLE           MIN_DOUBLE

#define MAX_PATHNAME          256

#define __INT_2(b)      ( (INT_2) b & 0x00FF )
#define __INT_U2(b)     ( (INT_U2) b & 0x00FF )
#define __INT_U4(h,l)   ( ((INT_U4) h << 16) | ((INT_U4) l & 0xFFFFL) )

/*------------------------------------------------------------------------*/

#ifdef DOS386
   #define _XDOS
   extern unsigned short         _x386_zero_base_selector;
   #define _x386_BASE            _x386_zero_base_selector
   #define MAKE_P(s,o)      ( ((INT_U4) (s) << 4) + ((INT_U4) (o)) )
   #define MAKE_FPSEL(s,p)  MK_FP( (s), (p) )
   #define MAKE_FP(s,o)     MAKE_FPSEL( _x386_BASE, MAKE_P(s,o) )
   EXTERN BOOLEAN xdos_alloc  ( INT_U2 *nseg, INT_U2 bytes );
   EXTERN BOOLEAN xdos_free   ( INT_U2 nseg );
   #define INT86X int86x
   #define FAR    
#else
   #define INT86X int86x
   #define FAR
#endif

/*------------------------------------------------------------------------*/

#ifndef __ERRHDL_H
   #include "errhdl.h"
#endif

/*------------------------------------------------------------------------*/
#endif

