/*   input.h : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __INPUT_H
#define __INPUT_H
  

/*-------------------------------------------------------------------------*/
/* input0.cc */


typedef struct {
   FILE        *fp;                          // file descriptor
   CHAR        *data;                        // 0 seperated & terminated bufs
   CHAR        *cptr;                        // internal buffer marker
   CHAR        *cond;                        // 'while/for' cond-stmt
   CHAR        *inc;                         // 'for' inc-stmts
   INT_2        inc_len;                     // length of above for push
   BOOLEAN      elseskip;                    // current if level nesting
} STREAM_TYP;

class INPUT_TYP {
 PUBLIC:
   BOOLEAN        bypass;
   INT_2          input_len;
   STREAM_TYP  *(*input)[];
 PUBLIC:
   BOOLEAN        allocate    ( VOID );
   BOOLEAN        deallocate  ( VOID );
   STREAM_TYP    *stream_ptr  ( BOOLEAN set_err=TRUE );
 PUBLIC:
   BOOLEAN        push        ( CHAR   *fname=NULL, CHAR *fext=NULL );
   BOOLEAN        push        ( CHAR   *buf,
                                INT_2   buf_len,
                                CHAR   *cond=NULL,
                                INT_2   cond_len=0,
                                CHAR   *inc=NULL,
                                INT_2   inc_len=0 );
   BOOLEAN        pop         ( VOID );
   BOOLEAN        is_file     ( VOID );
   BOOLEAN        is_funct    ( VOID );
   BOOLEAN        is_keyboard ( VOID );
   BOOLEAN        varsubst    ( CHAR *ucmd, BOOLEAN eval );
   BOOLEAN        setup       ( CHAR *prompt=NULL, BOOLEAN eval=TRUE );
 PUBLIC:
   VOID           make        ( VOID );
   VOID           unmake      ( VOID );
 PUBLIC:
   INPUT_TYP()    { make(); }
  ~INPUT_TYP()    { unmake(); }
};


/*-------------------------------------------------------------------------*/

/* general */

#define MAX_HUGE_BUF       (4*1024)
#define MAX_LARGE_BUF      (2*1024)
#define MAX_SMALL_BUF      (1*1024)

#define PARSE_MASK   (PARSE::_ASIS|PARSE::_COUNT|PARSE::_RANDOM|PARSE::_STRIP)

EXTERN CHAR          hugebuf   [MAX_HUGE_BUF];
EXTERN CHAR          bigbuf    [MAX_LARGE_BUF];
EXTERN CHAR          smallbuf  [MAX_SMALL_BUF];

EXTERN PARSE         P;
EXTERN FILE         *outfp;
EXTERN BOOLEAN       udebug;
EXTERN BOOLEAN       uquote;

// input1.cc
EXTERN BOOLEAN      toINT            ( INT_4  *result,
                                       CHAR   *text,
                                       CHAR   *seps=NULL );
EXTERN BOOLEAN      exec_debug       ( VOID );
EXTERN BOOLEAN      exec_quote       ( VOID );
EXTERN BOOLEAN      exec_echo        ( BOOLEAN   *echo_flag );
EXTERN BOOLEAN      exec_file        ( VOID );
EXTERN BOOLEAN      exec_print       ( VOID );
EXTERN BOOLEAN      exec_show        ( VOID );
EXTERN BOOLEAN      exec_defvar      ( VOID );
EXTERN BOOLEAN      exec_get         ( VOID );
EXTERN BOOLEAN      exec_deffunct    ( VOID );
EXTERN BOOLEAN      exec_call        ( VOID );
EXTERN BOOLEAN      exec_while       ( VOID );
EXTERN BOOLEAN      exec_for         ( VOID );
EXTERN BOOLEAN      exec_loopctl     ( VOID );
EXTERN BOOLEAN      exec_if          ( VOID );
EXTERN BOOLEAN      exec_ifctl       ( VOID );
EXTERN BOOLEAN      exec_delete      ( VOID );
EXTERN BOOLEAN      exec_expr        ( VOID );
EXTERN BOOLEAN      exec_shell       ( VOID );

// input2.cc
EXTERN BOOLEAN      eval_expr        ( INT_4 *uvalue, CHAR *useps=NULL );
EXTERN BOOLEAN      eval_strexpr     ( CHAR  *uvalue,
                                       INT_2  uvalue_len,
                                       CHAR  *useps=NULL );

// help.cc
#define MAX_APP_CMDS                 18   // : is at char-code-pos 48
EXTERN BOOLEAN      set_sum_help     ( CHAR *summary_line );
EXTERN BOOLEAN      set_desc_help    ( CHAR *keyword, CHAR *desc );
EXTERN BOOLEAN      exec_help        ( VOID );

/*-------------------------------------------------------------------------*/

EXTERN INPUT_TYP     input;

/*-------------------------------------------------------------------------*/
#endif

