/*   errhdl.h : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __ERRHDL_H
#define __ERRHDL_H


/*------------------------------------------------------------------------*/

typedef struct {
   INT_2       value;
   CHAR       *desc;
} TAGDESC_TYP;

#define ERR_SYS_NOMEM         1001     // system memory pool exhausted
#define ERR_SYS_DEVICE        1002     // system device/port error
#define ERR_SYS_PERM          1003     // system level permission error
#define ERR_ST_UNDERFLOW      3001     // symbol table undeflow
#define ERR_CMD_FILENAME      4001     // execution of filename is bad
#define ERR_CMD_RETURN        4002     // cannot return from keyboard stack
#define ERR_CMD_UNKNOWN       4003     // unknown command
#define ERR_P_NOTOKENS        5001     // no more token on command-line
#define ERR_P_CTL_LOOP        5002     // control loop command out of context
#define ERR_P_SETTING         5003     // invalid settings for command
#define ERR_INP_UNDERFLOW     6001     // input stack underflow
#define ERR_INP_OVERFLOW      6002     // input stack overflow
#define ERR_INP_FNAME         6003     // cannot locate filename
#define ERR_INP_MAXTOKBUF     6004     // max token buffer len reached
#define ERR_INP_PARSE1        6005     // missing ']' on token
#define ERR_SEM_BADNUM1       7001     // ill-formatted number 1
#define ERR_SEM_BADNUM2       7002     // ill-formatted number 2
#define ERR_SEM_BADNUM3       7003     // ill-formatted number 2
#define ERR_SEM_TYPE          7004     // Type syntax invalid
#define ERR_SEM_VARDEFINED    7005     // variable already defined
#define ERR_SEM_BRACES        7006     // brace syntax error
#define ERR_SEM_CHAR          7007     // char-length invalid
#define ERR_SEM_ARRIDX        7008     // array idx out-of-bounds
#define ERR_SEM_BADTOKEN      7009     // bad token in expression
#define ERR_SEM_BADLINE       7010     // bad cmd or expression
#define ERR_SEM_REF           7011     // invalid argument reference
#define ERR_SEM_BADFDECL      7012     // Bad fdecl
#define ERR_SEM_BADFUNC       7013     // bad function name reference
#define ERR_SEM_NOFUNC        7014     // function not found
#define ERR_SEM_BADARGS       7015     // bad arguments to function
#define ERR_SEM_DEL           7016     // invalid deletion requested
#define ERR_EXP_QPUSH         7017     // bad expression push
#define ERR_EXP_QPOP          7018     // bad expression pop
#define ERR_EXP_ARG1          7019     // bad expression arg 1
#define ERR_EXP_ARG2          7020     // bad expression arg 2
#define ERR_EXP_ARG3          7021     // bad expression arg 3
#define ERR_EXP_TIME          7022     // bad arg to time routines
#define ERR_EXP_OVERFLOW      7023     // expression stack overflow

#define MAX_ERRORS            32

EXTERN INT_2   errs_len;
EXTERN INT_2   errs[MAX_ERRORS];

#define MAXUSR_ERRORS         50

/*------------------------------------------------------------------------*/

EXTERN VOID    setusr_err  ( INT_2 errnum, CHAR *ptext );

EXTERN INT_2   set_errhdl  ( INT_2 errnum );
EXTERN VOID    clr_errhdl  ( VOID );

EXTERN VOID    errhdl      ( CHAR *ptext, FILE *fp=stdout );
EXTERN VOID    xerrhdl     ( CHAR *ptext, FILE *fp=stdout );

/*------------------------------------------------------------------------*/
#endif


