/*   ilib2.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

#include "std.h"

#include "diskio.h"
#include "ext2fs.h"

#include "ilib.h"

/*-------------------------------------------------------------------------*/


GLOBAL INT_2 read_file( CHAR *fname )
{
 FILE    *fp;
 INT_2    tsize;
 INT_2    i;
 INT_2    j;

   fp = fopen( fname, "rb" );
   if ( fp == NULL )
      return( set_errhdl(ERR_SYS_FILE) );

   fread( &links_len, sizeof(links_len), 1, fp );
   for( i=0; (i < links_len); i++ ) {
      fread( &links[i], sizeof(LINKS_TYP), 1, fp );
      if ( links[i].pinode != NULL ) {
         links[i].pinode = NULL;
         if ( alloc_inode(&links[i].pinode) != 0 ) {
            fclose( fp );
            return( ERR_SYS_NOMEM );
         }
         fread( links[i].pinode, sizeof(INODE_TYP), 1, fp );
      }
      if ( links[i].child_len != 0 ) {
         if ( links[i].child_len != 0 ) {
            tsize          = sizeof(INT_2) * links[i].child_len ;
            links[i].child = (INT_2 (*)[]) ::malloc( tsize );
            if ( links[i].child == NULL ) {
               fclose( fp );
               return( set_errhdl(ERR_SYS_NOMEM) );
            }
         }
         for( j=0; (j < links[i].child_len); j++ )
            fread( &(*links[i].child)[j], sizeof(INT_2), 1, fp );
      }
   }

   fclose( fp );
   return( 0 );

} /* read_file */


GLOBAL INT_2 write_file( CHAR *fname )
{
 FILE    *fp;
 INT_2    i;
 INT_2    j;

   fp = fopen( fname, "wb" );
   if ( fp == NULL )
      return( set_errhdl(ERR_SYS_FILE) );

   fwrite( &links_len, sizeof(links_len), 1, fp );
   for( i=0; (i < links_len); i++ ) {
      fwrite( &links[i], sizeof(LINKS_TYP), 1, fp );
      if ( links[i].pinode != NULL ) {
         fwrite( links[i].pinode, sizeof(INODE_TYP), 1, fp );
      }
      if ( links[i].child_len != 0 ) {
         for( j=0; (j < links[i].child_len); j++ )
            fwrite( &(*links[i].child)[j], sizeof(INT_2), 1, fp );
      }
   }

   fclose( fp );
   return( 0 );

} /* write_file */


/*-------------------------------------------------------------------------*/

