/*   ilib.h : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __ILIB_H
#define __ILIB_H

/*--------------------------------------------------------------------------*/

#define MAX_LINKS          4000
#define LOGFILE            "inode.log"
#define DATFILE            "inode.dat"

#define _FLG_CLEAR         0
#define _FLG_BADINODE      1
#define _FLG_BADBLKDEF1    2
#define _FLG_BADBLKDEF2    4
#define _FLG_BADBLOCK      8
#define _FLG_DATABLOCK    16
#define _FLG_NODOTBLOCK   32

typedef struct links_typ {
   INT_2          flags;
   INT_4          inode_num;
   INODE_TYP     *pinode;
   INT_2          parent;
   INT_4          parent_inode;
   INT_2          child_len;
   INT_2        (*child)[];
} LINKS_TYP;

EXTERN INT_2         links_len;
EXTERN LINKS_TYP     links[MAX_LINKS];

EXTERN INODE_TYP     t_inode;
EXTERN INT_2         blocksize;
EXTERN CHAR         *pblock;

EXTERN BOOLEAN       skip_bitblock;
EXTERN INT_4         group_idx;
EXTERN CHAR         *pbitblock;

EXTERN BOOLEAN       verbose;
EXTERN FILE         *log;
EXTERN CHAR          fname[80];

/*--------------------------------------------------------------------------*/


/* ilib0.cc */

EXTERN VOID         outvfp       ( CHAR *fmt, ... );
EXTERN VOID         outf         ( CHAR *fmt, ... );

EXTERN BOOLEAN      set_BIT      ( INT_4 nr, VOID *addr );
EXTERN BOOLEAN      clear_BIT    ( INT_4 nr, VOID *addr );
EXTERN BOOLEAN      test_BIT     ( INT_4 nr, VOID *addr );

/* ilib1.cc */

EXTERN INT_2        alloc_inode  ( INODE_TYP **pinode );
EXTERN VOID         free_inode   ( INODE_TYP **pinode );

EXTERN INT_2        alloc_child  ( INT_2 *(**uchild), INT_2 *uchild_len );
EXTERN VOID         free_child   ( INT_2 *(**uchild), INT_2 *uchild_len );

/* ilib2.cc */

EXTERN INT_2        read_file    ( CHAR *fname );
EXTERN INT_2        write_file   ( CHAR *fname );

/* ilib3.cc */
EXTERN INT_2        find_links   ( INT_4 inode_num );
EXTERN VOID         dump_links   ( INT_2 idx );
EXTERN BOOLEAN      setup_links  ( VOID );
EXTERN BOOLEAN      resolve_links( VOID );


/*--------------------------------------------------------------------------*/
#endif
