/*   dump.h : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __DUMP_H
#define __DUMP_H

   #ifndef __EXT2FS_H
      #include "ext2fs.h"
   #endif

/*------------------------------------------------------------------------*/

EXTERN CHAR *partdesc    ( INT_U2 parttype );
EXTERN CHAR *modedesc    ( INT_U2 i_mode   );

EXTERN VOID  dumpdata    ( VOID    *pbuf,
                           INT_4    pbuf_len,
                           INT_U4   sector,
                           FILE    *fp=stdout,
                           INT_2    maxlen=1024L );

EXTERN VOID  dumpdisk    ( FILE *fp=stdout );
EXTERN VOID  dumppart    ( BOOLEAN hex=TRUE, FILE *fp=stdout );
EXTERN VOID  dumpsb      ( SUPERBLOCK_TYP  *s,
                           BOOLEAN          brief=FALSE,
                           FILE            *fp=stdout );
EXTERN VOID  dumpgroups  ( GROUPDESC_TYP   *g,
                           INT_4           g_len,
                           INT_4           g_idx,
                           FILE           *fp=stdout );
EXTERN VOID  dumpinode   ( INT_4 ino, INODE_TYP *i, FILE *fp=stdout );
EXTERN VOID  dumpiblocks ( INT_4 ino, INODE_TYP *i, FILE *fp=stdout );

/*------------------------------------------------------------------------*/
#endif

