/*
 *    ext2hide - a superblock reserved space file stashing utility
 *      by infi/2006
 *
 *	  error.h
 *      contains global errorcode defines
 */

#include <errno.h>

// custom codes
#define E_SBSUCCESS		0			/* Success. */
#define E_SBNOSIG		150			/* No signature found */
#define E_SBCANCEL      151         /* User cancelled */

// remapped syscall error codes
#define E_SBNOENT       ENOENT		/* File not found */
#define	E_SBINVAL		EINVAL		/* Invalid cmd line argument */
#define E_SBACCES		EACCES		/* File access denied */
#define E_SBBUSY		EBUSY		/* Device or resource busy */
#define E_SBNODEV		ENODEV		/* No such device */
#define E_SBISDIR		EISDIR		/* Is a directory */
#define E_SBNOSPC		ENOSPC		/* Not enough space */
#define E_SBIO			EIO			/* I/O error */
#define E_SBSEEK		ESPIPE		/* Illegal seek */

/* END error.h */
