/* efs.h 
*/

#include <linux/stat.h>
#include <linux/sched.h>
#include <linux/iso_fs.h> /* EFS here */
#include <linux/kernel.h>
#include <linux/major.h>
#include <linux/mm.h>
#include <linux/string.h>
#include <linux/locks.h>
#include <linux/malloc.h>
#include <linux/errno.h>
#include <linux/cdrom.h>

#include <asm/system.h>
#include <asm/segment.h>

/* SuperMagic: need a unique Identifier for EFS */
#define EFS_SUPER_MAGIC	    0x280273
#define EFS_ROOT_INODE	    2
#define EFS_BLK_SUPER	    1

#define EFS_BLOCK_SIZE	    512
#define EFS_BLOCK_SIZE_BITS 9

/* EFS Magic IDs */
#define EFS_MAGIC1	    0x72959
#define EFS_MAGIC2	    0x7295a

/* Offsets in VolumeDescriptor */
#define EFS_VD_FS_START     0x190  /* First FS block */
#define EFS_VD_ENTRYFIRST   0x48   /* Begin of Entry list */
#define EFS_VD_ENTRYPOS     8      /* offset for the entry position */
#define EFS_VD_ENTRYLEN     12     /* offset for the entry length */
#define EFS_VD_ENTRYSIZE    16     /* length of an entry */

/* Offsets in Superblock */
#define EFS_SB_TOTAL	    0	   /* Number of Blocks used for filesystem */
#define EFS_SB_FIRST	    4	   /* BB of Begin First Cylinder Group */
#define EFS_SB_GROUP	    8	   /* BBs per Group */
#define EFS_SB_INODE	    12	   /* BBs used for Inodes at  begin of group */
#define EFS_SB_TOGRP	    18	   /* Number of Groups in Filesystem */
#define EFS_SB_MAGIC	    28

/* Offsets in INode */
#define EFS_IN_MODE         0
#define EFS_IN_LINKS        2
#define EFS_IN_UID          4
#define EFS_IN_GID          6
#define EFS_IN_SIZE         8
#define EFS_IN_MTIME        12
#define EFS_IN_ATIME        16
#define EFS_IN_CTIME        20
#define EFS_IN_GEN          24
#define EFS_IN_NUMEXT       28
#define EFS_IN_VERSION      30
#define EFS_IN_EXTENTS      32

/* Offsets in DirBlock */
#define EFS_DB_ENTRIES      3
#define EFS_DB_FIRST        4

/* Offsets in DirItem */
#define EFS_DI_NAMELEN      4
#define EFS_DI_NAME         5

#define EFS_MAX_EXTENTS          12
#define EFS_EXT_PER_BLK_BITS     5
#define EFS_EXT_PER_BLK_MASK     63
#define EFS_EXT_SIZE_BITS        3

/* define a few convenient types */
typedef unsigned char	    BYTE;  /* 8 bit */
typedef unsigned short	    SHORT; /* 16 bit */
typedef unsigned long	    LONG;  /* 32 bit */

/* private Inode part */
struct efs_in_info {
  LONG  extblk;
  
  SHORT tot;
  SHORT cur;

  LONG  extends[EFS_MAX_EXTENTS][2];
};

/* EFS Superblock Information */
struct efs_sb_info {
  LONG    fs_start;      /* first block of filesystem */
  LONG    total_blocks;  /* total number of blocks in filesystem */
  LONG    first_block;   /* first data block in filesystem */
  LONG    group_size;    /* number of blocks a group consists of */ 
  SHORT   inode_blocks;  /* number of blocks used for inodes in every grp */
  SHORT   total_groups;  /* number of groups */
};


/* INode Method structures for Dirs, Files and Symlinks */
extern struct inode_operations efs_dir_in_ops;
extern struct inode_operations efs_file_in_ops;
extern struct inode_operations efs_symlink_in_ops;

/* exported Prototypes */
extern int efs_bmap(struct inode *,int);
extern int efs_lookup(struct inode *,const char *,int,struct inode **);
extern LONG ConvertLong(BYTE *buf,int off);
extern SHORT ConvertShort(BYTE *buf,int off);
