#include "postfile.h"
#include "fidotools.h"
#include "felib.h"
#include "crc32.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

extern filearea *areas;
extern int apos;
extern aka_entry aka_list [20];
extern int addr_index;
extern char inbound_dir[];

#define TICFORM_LINE_COUNT 12
char ticform [TICFORM_LINE_COUNT][160]={
	"Area %s\r\n",			
	"Areadesc %s\r\n",		
	"Origin %d:%d/%d.%d\r\n",		
	"From %d:%d/%d.%d\r\n",		
	"Replaces %s\r\n",		
	"File %s\r\n",			 
	"Desc %s\r\n",
	"Crc %s\r\n",
	"Created by FidoTools v%s (written by Nickolay G. Grygoryev 2:5030/499.29)\r\n",
	"Path %d:%d/%d.%d %ld %s\r\n",
	"Seenby %d:%d/%d.%d\r\n",
	"Pw %s\r\n"
};

int postfile (char *filename, char *areaname, int needmsg)
{
char buf[200],srcname[200],destname[200],ticname[200],name[60],desc[10][120],ch;
int i,dcount=0,j;
aka_entry *rightaka=NULL;
filearea *target=NULL;
FILE *ticfile;
time_t curtime;
unsigned long crc;
int sendallowed=0;

	/* Looking for file for making attach */
	if (filename[0]!='/') {
	/* It's local name */
		getcwd (srcname,199);
		strcat (srcname,"/");
		strcat (srcname,filename);
	} else 
	/* It's absolute path */
		strcpy (srcname,filename);
	strcpy (destname, inbound_dir);
	strcat (destname,"/");
	strcat (destname,strrchr (srcname,'/'));
	for (i=0; i<apos; i++) 
		if (strcasecmp (areas[i].name,areaname)==0)
			target=areas+i;
	strup (areaname);
	if (target==NULL) {
		sprintf (buf,"Error : can not find area %s",areaname);
		debug (1,buf);
		if (needmsg)
			puts (buf);
		return 0;
	}
	for (i=0; i<addr_index; i++) 
		if (eq_addr (&aka_list[i].aka,&target->aka))
			rightaka=aka_list+i;
	if (rightaka==NULL) {
		sprintf (buf,"Error : can not find you AKA for area %s",areaname);
		debug (1,buf);
		if (needmsg)
			puts (buf);
		return 0;
	}	
// Cheking posting permissions for this conference...
	for (i=0; i<target->send_count; i++) 
		if (eq_addr (&rightaka->aka,&target->send_arr[i]))
			sendallowed=1;
	if (!sendallowed) {
		sprintf (buf,"You are not allowed to send files to %s",areaname);
		debug (1,buf);
		if (needmsg)
			puts (buf);
		return 0;		
	}

/* Trying to create tic file */
	strcpy (ticname,inbound_dir);
	time (&curtime);
	sprintf (buf,"%d:%d/%d.%d (%ld)",
		 target->subs_arr[i].zone,
		 target->subs_arr[i].network,
		 target->subs_arr[i].node,
		 target->subs_arr[i].point,
		 curtime);
	strcat (buf,srcname);
	strcat (buf,target->name);
	crc=count_crc32 (buf);
	sprintf (buf,"/%08x.tic",crc);
	strcat (ticname, buf);
/* Getting file description */
	do 
		fgets (desc[dcount++],119,stdin);
	while (!feof (stdin));
	dcount--;
	for (i=0; i<dcount; i++)
		*strrchr (desc[i],'\n')=0;
	if ((ticfile=fopen (ticname,"w"))==NULL) {
		sprintf (buf,"Error : can not create file %s : %s",ticname,
			 sys_errlist[errno]);
		debug (1,buf);
		if (needmsg)
			puts (buf);
		return 0;
	}
	strcpy (name,strrchr (srcname,'/')+1);
	strup (name);
	
	for (i=0; i<TICFORM_LINE_COUNT; i++) 
		switch (i) {
			case 0:
				fprintf (ticfile,ticform[0],target->name);
				break;
			case 1:
				fprintf (ticfile,ticform[1],target->description);
				break;
			case 2:
				fprintf (ticfile,ticform[2],rightaka->aka.zone,
							    rightaka->aka.network,
							    rightaka->aka.node,
							    rightaka->aka.point);
				break;
			case 3:
				fprintf (ticfile,ticform[3],rightaka->aka.zone,
							    rightaka->aka.network,
							    rightaka->aka.node,
							    rightaka->aka.point);
				break;
			case 4:	
				fprintf (ticfile,ticform[4],name);
				break;
			case 5:
				fprintf (ticfile,ticform[5],name);
				break;
			case 6: 
				for (j=0; j<dcount; j++) {
					koi2alt (desc[j]);
					if (dcount==1) 
						fprintf (ticfile,ticform[6],desc[j]);
					else
						fprintf (ticfile,"LDesc %s\r\n",desc[j]);
				}
				break;
			case 7:
				sprintf (buf,"%08x",count_file_crc32 (srcname));
				strup (buf);
				fprintf (ticfile,ticform[7],buf);
				break;
			case 8:
				fprintf (ticfile,ticform[8],VERSION);
				break;
			case 9:
				strcpy (buf,ctime (&curtime));
				*strchr (buf,'\n')=0;
				fprintf (ticfile,ticform[9],rightaka->aka.zone,
							    rightaka->aka.network,
							    rightaka->aka.node,
							    rightaka->aka.point,
							    curtime,buf);
				break;
			case 10:	
				fprintf (ticfile,ticform[10],rightaka->aka.zone,
							    rightaka->aka.network,
							    rightaka->aka.node,
							    rightaka->aka.point);
				break;
			case 11:
				fprintf (ticfile,ticform[11],rightaka->password);
				break;
			default:
				fprintf (ticfile,ticform[i]);
				break;
		}
	fclose (ticfile);
/* TIC file created */
	if (!ncopyfile (srcname,destname)) {
		sprintf (buf,"Error : can not copy file %s to %s (%s)",srcname,destname,
			 sys_errlist[errno]);
		debug (1,buf);
		if (needmsg)
			puts (buf);
		return 0;	
	}
	debug (5,"Running tosser for processing new TICs...");
	return 1;
}
