/* The main header file */

#include <stdio.h>

#ifndef FIDOTOOLS_H
#define FIDOTOOLS_H

#define TIC_OK			0
#define TIC_AUTOCREATE_ERROR 	1
#define TIC_FILE_NOT_FOUND	2
#define TIC_DEST_FILE_ERROR	3
#define TIC_FILE_READ_ERROR	4
#define TIC_FILE_WRITE_ERROR	5
#define TIC_FILE_CLOSE_ERROR	6

#define AC_OK			0
#define AC_UNKNOWN_UPLINK	1
#define AC_CANNOT_CREATE_DIR	2

#define AC_SUBJ	"Autocreated area"
#define DEF_SUBJECT "New files on 2:5030/383.29"
#define FE_SIGN "\n\n\n\t\t\t\t\t\t Your FEtoss.\n"

#define COPY_BUF_SIZE 32768

#define	NUM_KEYWORDS	13
#define NUM_FAREAS_KEYWORDS 6
#define NUM_TIC_FIELDS 8

/* Some limits */
#define MAX_TIC_LINES 200
#define MAX_TIC_LINE_LENGTH 150
#define MAX_SEENBY_RECORDS 100
#define MAX_PATH_LINES	100
#define MAX_LDESC_SIZE 4000

/* FTN address structure */
typedef struct {
	int zone,network,node,point;
} ftn_address;

/* AKA information structure */
typedef struct {
	ftn_address aka,uplink;
	char password[16];
} aka_entry;

typedef struct {
	ftn_address adr;
	char password[16];
} neighbour;

/* File area definition */
typedef struct {
	char name[20];		/* File area name 		*/
	char path[180];		/* File area path 		*/
	ftn_address aka;	/* Your AKA for this area 	*/
	ftn_address uplink;	/* Your uplink for this area 	*/
	char description[120];	/* File area description 	*/
	char flags[10];		/* File area flags		*/
	int subs_count;		/* A number of receivers	*/
	int send_count;		/* A munber of senders		*/
	ftn_address *subs_arr;	/* A pointer to array containing receiver
				   addresses 			*/
	ftn_address *send_arr;	/* A pointer to array containing sender
				   addresses 			*/	
} filearea;

typedef struct {
	char fe_name[20];
	char filename[16];
	long size;
	char desc[MAX_LDESC_SIZE];
} fileinfo;

/* This function parses one line from main configuration file */
int parse_conf_line (char*);
/* This function parses file areas configuration file */
int parse_fareas_file (FILE*);

void log_config_error (char*,char*,int);
void remove_temp_files (void); 
void print_common_help (void);
void free_areasdata (filearea*);
void check_neighbour_list (void);
int parse_neighbours_file (FILE*);
void debug_neighbour (ftn_address);

#endif