#include <string.h>
#include <getopt.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <locale.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <fcntl.h>
#include <stdlib.h>
#include "felib.h"
#include "fidotools.h"
#include "convert.h"
#include "fetoss.h"
#include "attach.h"
#include "postfile.h"

#define DEFAULT_NODE 	383
#define DEFAULT_REGNET  5030
#define DEFAULT_ZONE	2

char conf_keywords [NUM_KEYWORDS][20]={"ADDRESS","UPLINK","PASSWORD","INBOUND","OUTBOUND",
				       "TEMPDIR","REPORT","REPORTTO","DEBUG",
				       "MAXDAYS","BADTICDIR","FILEBASE",
				       "BADFILES"};
char fareas_keywords [NUM_FAREAS_KEYWORDS][20]={"NAME","PATH","AKA","UPLINK",
                                                "DESC","FLAGS"};
char tic_key_names [NUM_TIC_FIELDS][20]={"AREA","ORIGIN","FROM","FILE",
					 "DESC","CRC","PW","REPLACES"};

/* Log file */
FILE *logfile;
/* Global parameters */
char 	configfile[100];
char 	fareasfile[100];
char 	receiversfile[200],sendersfile[200];
char 	neighboursfile[200];
char 	inbound_dir[100]="";
char 	outbound_dir[100]="";
char 	tempdir[100]="/tmp";
char 	filebase[100]="/tmp";
char 	filetohatch[200]="";
char 	hatchinto[20]="";
int	hatchmode=0;
int  	report_type=0;
char 	reportto[100]="postmaster";
int	maxdays=3;
char 	badticdir[100]="/tmp";
char 	badfilesdir[100]="/tmp";
int	need_inbound_dir=1;
int	need_outbound_dir=1;
int	copyflag=0;		/* File must be copied to temp dir. */
int	clearflag=0;		/* File must be truncated after sending */
char	filetoattach[200]="";
char	*filetopost=filetoattach;
char 	areaname[60];
char	ftnaddress[20]="0:0/0.0";	/* ;-))) */

extern int optind;

filearea *areas=NULL;
neighbour *neighbour_list=NULL;
int neighbours_count=0;
int acount=30,apos=0;
aka_entry aka_list [20];
int addr_index=0,uplink_index=0,pwd_index=0;
int debug_level=10;
int ticerror=0;
int autocreateerr=0;
int gotnames=0;

int main (argc,argv)
int argc;
char *argv[];
{
int res,i;
FILE *config;
char confline [200];
char *progname;

/* Opening log file */
	setlocale (LC_ALL,"KOI8-R");
	strcpy (configfile,CONFIG);
	strcpy (fareasfile,FAREAS);
	strcpy (receiversfile,RECEIVERS);
	strcpy (sendersfile,SENDERS);	
	strcpy (neighboursfile,NEIGHBOURS);
	if ((logfile=fopen (LOGFILE,"a+"))==NULL) {
		fprintf (stderr,"Error : can't open log file %s\n",LOGFILE);
		fprintf (stderr,"%s\n",_sys_errlist[errno]); 
		exit (1);
	}
	if ((progname=strrchr (argv[0],'/'))!=NULL) 
		progname++;
	else 
		progname=argv[0];	
	if (strcasecmp (progname,"fidotools")==0) {
		printf ("FidoTools %s\n",VERSION);
		printf ("This program can not be runned directly\n");
		exit (2);
	}
	debug (1,"%s %s started on %s\n",progname,VERSION,date ());
	if (strcasecmp (progname,FETOSS)==0) {
		while ((res=getopt (argc,argv,"i:o:c:f:h")) != -1) {
			switch (res) {
				case 'h':
					printf ("FidoTools %s\n",VERSION);
					printf ("Fileecho tosser. Written by Nickolay G. Grygoryev.\n");
					printf ("Usage : fetoss [options]\n");
					print_common_help ();
					printf ("\t-f <file> - set fileareas configuration file name\n");
					exit (0);
					break;
				case 'i':
					strcpy (inbound_dir,optarg); 	
					need_inbound_dir=0;
					break;
				case 'o':
					strcpy (outbound_dir,optarg);
					need_outbound_dir=0;				
					break;
				case 'c':
					strcpy (configfile,optarg);	break;	
				case 'f':
					strcpy (fareasfile,optarg);	break;
				default:
					printf ("Option %c is unknown\n",res);
					exit (2);	break;
			}
		}
	} 
	else if (strcasecmp (progname,ATTACH)==0) {
		if (argc>2) {
			if ((checkarg (argv[1])) &&
			    (checkarg (argv[2])) )
			{
				strcpy (filetoattach,argv[1]);
				strcpy (ftnaddress,argv[2]);
				strcpy (argv[1],"-s");
				strcpy (argv[2],"-s");
				gotnames=1;
			}
		}
		while ((res=getopt (argc,argv,"i:o:sc:hme")) != -1) {
			switch (res) {
				case 'h':
					printf ("FidoTools %s\n",VERSION);
					printf ("File attach utility. Written by Nickolay G. Grygoryev.\n");
					printf ("Usage : fileattach FILE FTN_ADDRESS [options]\n");
					print_common_help ();
					printf ("\t-m        - Copy file to temp directory and remove it after sending\n");
					printf ("\t-e        - Clear file after sending\n");
					exit (0);
					break;
				case 'i':
					strcpy (inbound_dir,optarg); 	
					need_inbound_dir=0;
					break;
				case 'o':
					strcpy (outbound_dir,optarg);
					need_outbound_dir=0;				
					break;
				case 'c':
					strcpy (configfile,optarg);	break;	
				case 'm':
					copyflag=1;	break;
				case 'e':
					clearflag=1;	break;
				case 's':	
					break;
				default:
					printf ("Option %c is unknown\n",res);
					exit (2);	break;
			}
		}
		if (gotnames==0) {
			printf ("File name and destination address required\n");
			fclose (config);	fclose (logfile);
			exit (2);
		}
	} else 
	if (strcasecmp (progname,POSTFILE)==0) {
		if (argc>2) {
			if ((checkarg (argv[1])) &&
			    (checkarg (argv[2])) )
			{
				strcpy (filetopost,argv[1]);
				strcpy (areaname,argv[2]);
				strcpy (argv[1],"-s");
				strcpy (argv[2],"-s");
				gotnames=1;
			}
		}
		while ((res=getopt (argc,argv,"i:o:sc:h")) != -1) {
			switch (res) {
				case 'h':
					printf ("FidoTools %s\n",VERSION);
					printf ("File posting utility. Written by Nickolay G. Grygoryev.\n");
					printf ("Usage : postfile FILE FILE_CONFERENCE_NAME\n");
					printf ("This program gets file description from standart input\n");
					print_common_help ();
					exit (0);
					break;
				case 'i':
					strcpy (inbound_dir,optarg); 	
					need_inbound_dir=0;
					break;
				case 'o':
					strcpy (outbound_dir,optarg);
					need_outbound_dir=0;				
					break;
				case 'c':
					strcpy (configfile,optarg);	break;	
				case 's':
					break;
				default:
					printf ("Option %c is unknown\n",res);
					exit (2);	break;
			}
		}
		if (gotnames==0) {
			printf ("File name and target conference required\n");
			fclose (config);	fclose (logfile);
			exit (2);
		}
	}
/*	Trying to open configuration file ... 		*/
	if ((config=fopen (configfile,"r"))==NULL) {
		debug (1,"Error : can't open configuration file %s\n",configfile);
		debug (1,"%s\n",_sys_errlist[errno]);
		fclose (logfile);
		exit (1);
	}
/* Configuration file opened - loading it */
	while (!feof (config)) {
		fgets (confline,200,config);
		if (strlen (confline)<3) continue;
		strltrim (confline);
		if (confline[0]=='#') continue;		/* Ignoring comments */
		if ((res=parse_conf_line (confline))>0) {
			debug (1,"%s : Syntax error #%d in line : \n",configfile,res);
			debug (1,"<%s>\n",confline);
			abort_message ();
			fclose (config);	fclose (logfile);
			exit (1);
		}
	}
	fclose (config);
	if ((addr_index!=uplink_index) || (addr_index!=pwd_index) ||
	    (uplink_index!=pwd_index)) {
	    debug (1,"Wrong number of address components in configuration file");
	    abort_message ();
	    fclose (logfile);
	    exit (1);
	}

	debug (8,"Node configuration :");
	for (i=0; i<addr_index; i++) 
		debug (8,"AKA : %d:%d/%d.%d  UPLINK : %d:%d/%d.%d  PWD : %s",
			  aka_list[i].aka.zone,
		   	  aka_list[i].aka.network,
		   	  aka_list[i].aka.node,
		   	  aka_list[i].aka.point,
			  aka_list[i].uplink.zone,
		   	  aka_list[i].uplink.network,
		   	  aka_list[i].uplink.node,
		   	  aka_list[i].uplink.point,		   	  
		   	  aka_list[i].password);	
	
/*	Trying to open FAreas configuration file ... 		*/
	if ((config=fopen (fareasfile,"r"))==NULL) {
		debug (1,"Error : can't open FAreas configuration file %s\n",fareasfile);
		debug (1,"%s\n",_sys_errlist[errno]);
		fclose (logfile);
		exit (1);
	}
/* FAreas configuration file opened - loading it */
	areas=(filearea*)malloc (sizeof (filearea)*acount);
	if (parse_fareas_file (config)==0) {
		abort_message ();
		fclose (config);	fclose (logfile);
		if (areas!=NULL) free ((void*)areas);
		exit (1);
	}
	if ((config=fopen (receiversfile,"r"))==NULL) {
		debug (1,"Error : can't open Receivers configuration file %s\n",receiversfile);
		debug (1,"%s\n",_sys_errlist[errno]);
		fclose (logfile);
		if (areas!=NULL) free_areasdata (areas);		
		exit (1);
	}	
	if (parse_rs_files (config,1)==0) {
		abort_message ();
		fclose (config);	fclose (logfile);
		if (areas!=NULL) free_areasdata (areas);
		exit (1);
	}
	fclose (config);
	if ((config=fopen (sendersfile,"r"))==NULL) {
		debug (1,"Error : can't open Senders configuration file %s\n",receiversfile);
		debug (1,"%s\n",_sys_errlist[errno]);
		fclose (logfile);
		if (areas!=NULL) free_areasdata (areas);
		exit (1);
	}	
	if (parse_rs_files (config,0)==0) {
		abort_message ();
		fclose (config);	fclose (logfile);
		if (areas!=NULL) free_areasdata (areas);
		exit (1);
	}
	fclose (config);
	if ((config=fopen (neighboursfile,"r"))==NULL) {
		debug (1,"Error : can't open Neighbours configuration file %s\n",neighboursfile);
		debug (1,"%s\n",_sys_errlist[errno]);
		fclose (logfile);
		if (areas!=NULL) free_areasdata (areas);
		exit (1);
	}	
	neighbour_list=(neighbour*)malloc (sizeof (neighbour)*neighbours_count);
	if (parse_neighbours_file (config)==0) {
		abort_message ();
		fclose (config);	fclose (logfile);
		if (areas!=NULL) free_areasdata (areas);
		exit (1);
	}
	fclose (config);
	debug (8,"Configuration files loaded OK.");
	if (strcasecmp (progname,FETOSS)==0)
		toss_new_files ();
	else if (strcasecmp (progname,ATTACH)==0) {
		debug (1,"File attach : %s to %s mode %d/%d",filetoattach,ftnaddress,copyflag,clearflag);
		attachfile (filetoattach,ftnaddress,copyflag,clearflag,1);
	}
	else if (strcasecmp (progname,POSTFILE)==0) {
		debug (1,"File post : %s to %s",filetopost,areaname);
		if (postfile (filetopost,areaname,1)) 
			toss_new_files ();
	}
	fclose (logfile);
	if (areas!=NULL) free_areasdata (areas);
	return 0;
}

void print_common_help (void)
{
	printf ("Available options are :\n");
	printf ("\t-h        - display this help and exit\n");
	printf ("\t-i <dir>  - set inbount directory\n");
	printf ("\t-o <dir>  - set outbound directory\n");
	printf ("\t-c <file> - set main configuration file name\n");
	return;
}

/* This function parses one line from config file and save new data to
   global data structures */
   
int parse_conf_line (line)
char *line;
{
char *ptr=line,*start,keyword [40]="", argument [100]="";
int i,keynum=-1;

	while ((!isspace (*ptr)) && (*ptr!=0)) ptr++;
	if (*ptr==0) return 1;		/* end of word not found */
	*ptr=0;
	for (i=0; i<NUM_KEYWORDS; i++)
		if (strcasecmp (line,conf_keywords[i])==0) keynum=i;
	strcpy (keyword,line);	*ptr=' ';
	if (keynum==-1) return 2;	/* Unknown keyword */
	start=ptr+1;
	while (isspace (*start)) start++;	/* looking for arg. */
	if (*start==0) return 3;	/* argument not found */
	ptr=start+1;
	while ((!isspace (*ptr))  && (*ptr!=0)) ptr++;
	*ptr=0;
	strcpy (argument,start);
	ptr=argument;
	debug (8,"Config keyword : %s = %s",keyword,argument);	
	switch (keynum) {
		case 0:		
			parse_ftn_address (&aka_list[addr_index].aka,argument);
			addr_index++;	break;
		case 1:
			parse_ftn_address (&aka_list[uplink_index].uplink,argument);
			uplink_index++;	break;
		case 2:
			if (strlen (argument)>15) return 5;
			strcpy (aka_list[pwd_index++].password,argument); break;
		case 3:	
			if (need_inbound_dir)	
				strcpy (inbound_dir,argument);	
			break;
		case 4:
			if (need_outbound_dir)
				strcpy (outbound_dir,argument);	
			break;
		case 5:
			strcpy (tempdir,argument);	break;
		case 6: 
			if (strcasecmp (argument,"NONE")==0) report_type=0;
				else if (strcasecmp (argument,"MAIL")==0) report_type=1;
					else if (strcasecmp (argument,"NEWS")==0) report_type=2;
			break;
		case 7:	
			strcpy (reportto,argument);	break;
		case 8:	
			debug_level=atoi (argument);	break;
		case 9:
			maxdays=atoi (argument);	break;
		case 10:
			strcpy (badticdir,argument);	break;
		case 11:	
			strcpy (filebase,argument);	break;
		case 12:
			strcpy (badfilesdir,argument);	break;
	}
	return 0;	
}

int parse_fareas_file (config)
FILE *config;
{
char confline[200],keyword[20],argument[180],*ptr;
int cur_key=0;
filearea *tempptr;

	apos=0;
	debug (8,"Reading FAreas configuration...");
	while (!feof (config)) {
		fgets (confline,200,config);
		if (feof (config)) break;
		if (strlen (confline)<3) continue;
		strltrim (confline);
		if (confline[0]=='#') 
			continue;		/* Ignoring comments */
		sscanf (confline,"%s",keyword);
		if (strcasecmp (keyword,fareas_keywords[cur_key])!=0) {
			log_config_error (fareasfile,confline,10);
			return 0;
		}
		if (cur_key!=4)	sscanf (confline,"%s%s",keyword,argument);
			else {
				ptr=confline;
				while (!isspace	(*ptr)) ptr++;
				while (isspace (*ptr)) ptr++;
				strcpy (argument,ptr);
				if ((ptr=strchr (argument,10))!=NULL)
					*ptr=0;
		}
		debug (8,"Keyword : %s = %s",keyword,argument);
		switch (cur_key) {
			case 0:	strcpy (areas[apos].name,argument);	break;
			case 1: strcpy (areas[apos].path,argument);	break;
			case 2: parse_ftn_address (&areas[apos].aka,argument);
				break;
			case 3:	parse_ftn_address (&areas[apos].uplink,argument);
				break;
			case 4: strcpy (areas[apos].description,argument);
				break;
			case 5: strcpy (areas[apos].flags,argument);
				strup (areas[apos].flags);
				areas[apos].subs_count=0;
				areas[apos].subs_arr=(ftn_address*)malloc (20*sizeof (ftn_address));
				areas[apos].send_count=0;
				areas[apos].send_arr=(ftn_address*)malloc (20*sizeof (ftn_address));
				if (strchr (areas[apos].flags,'R')!=NULL) {
					areas[apos].subs_arr[areas[apos].subs_count++]=areas[apos].aka;
					areas[apos].send_arr[areas[apos].send_count++]=areas[apos].uplink;
				}
				if (strchr (areas[apos].flags,'W')!=NULL) {
					areas[apos].send_arr[areas[apos].subs_count++]=areas[apos].aka;
					areas[apos].subs_arr[areas[apos].send_count++]=areas[apos].uplink;
				}
				break;
		}
		cur_key++;
		if (cur_key==6) {	/* Going to next element in array */
			if (apos==acount-1) {	/* We need to expand array */
				tempptr=(filearea*) malloc ((acount+30)*sizeof (filearea));
				memcpy ((void*)tempptr,(void*)areas,acount*sizeof (filearea));
				free ((void*)areas);
				areas=tempptr;	acount+=30;
			}
			cur_key=0;	apos++;
		}
	}
	debug (8,"%d file area(s) found",apos);	
	return 1;
}

int parse_rs_files (FILE *config,int mode)
// mode : 1-receivers, 0-senders
{
filearea *faptr=areas,*current;
ftn_address adr,*aptr;
char buf[3000]="",*ptr,buf2[40]="",*start,temp,sadr[40],cnfile[20];
int defzone=DEFAULT_ZONE,defnet=DEFAULT_REGNET,defnode=DEFAULT_NODE;
int i;
	if (mode)	
		strcpy (cnfile,receiversfile);
	else
		strcpy (cnfile,sendersfile);
	do {
		fgets (buf,2999,config);
		strltrim (buf);
		if (buf[0]=='#')
			continue;		/* Ignoring comments */
		ptr=buf;
		while (!isspace (*ptr)) ptr++;
		temp=*ptr;
		*ptr=0;
		strcpy (buf2,buf);
		*ptr=temp;
		current=NULL;
		for (i=0; i<apos; i++) 
			if (strcasecmp (buf2,areas[i].name)==0)
				current=areas+i;
		
		if (current==NULL) {
			debug (1,"Warning : can't find area %s which is used in %s file",
			       buf2,cnfile);
			continue;
		}
		debug (8,"Found file area %s - reading data",current);
		while (*ptr!=0) {
			while (isspace (*ptr)) ptr++;
			if (*ptr==0) 
				break;
			start=ptr;
			while (isspace (*ptr)==0) ptr++;
			temp=*ptr;
			*ptr=0;
			strcpy (buf2,start);
			*ptr=temp;
			strltrim (buf2);
			strcpy (sadr,"");
			if (buf2[0]=='.') 
				sprintf (sadr,"%d:%d/%d",defzone,defnet,defnode);
			else if (buf2[0]=='/')
				sprintf (sadr,"%d:%d",defzone,defnet);
			else if (buf2[0]==':')
				sprintf (sadr,"%d",defzone);
			strcat (sadr,buf2);
			if (mode)
				debug (8,"Found receiver %s",sadr);
			else
				debug (8,"Found sender %s",sadr);
			parse_ftn_address (&adr,sadr);
			defzone=adr.zone;
			defnet=adr.network;
			defnode=adr.node;
			if (mode) {
				current->subs_arr[current->subs_count]=adr;
				current->subs_count++;
				if (current->subs_count%20==0) {
					aptr=current->subs_arr;
					current->subs_arr=malloc (sizeof (ftn_address)*20*(1+current->subs_count/20));
					memcpy ((void*)current->subs_arr,(void*)aptr,current->subs_count*sizeof (ftn_address));
					free (aptr);
				}
			} else {
				current->send_arr[current->subs_count]=adr;
				current->send_count++;
				if (current->send_count%20==0) {
					aptr=current->send_arr;
					current->send_arr=malloc (sizeof (ftn_address)*20*(1+current->send_count/20));
					memcpy ((void*)current->send_arr,(void*)aptr,current->send_count*sizeof(ftn_address));
					free (aptr);
				}				
			}			
		}
	} while (!feof (config));
	return 1;
}

void log_config_error (file,line,code)
char *file,*line;
int code;
{
	debug (1,"%s : Syntax error #%d in line : \n",file,code);
	debug (1,"<%s>\n",line);
}

void free_areasdata (filearea *ptr)
{
int i;
	for (i=0; i<apos; i++)  {
		if ((ptr+i)->subs_arr!=NULL)
			free ((void*)(ptr+i)->subs_arr);
		if ((ptr+i)->send_arr!=NULL)
			free ((void*)(ptr+i)->send_arr);
	}
	free ((void*)ptr);
	return;
}

int parse_neighbours_file (FILE *config)
// mode : 1-receivers, 0-senders
{
ftn_address adr;
char buf[100],sadr[20],pwd[20];
int i;
	while (!feof (config)) {
		fgets (buf,99,config);
		if (feof (config))
			break;
		strltrim (buf);
		if (*buf=='#')
			continue;
		sscanf (buf,"%s%s",sadr,pwd);
		strup (pwd);
		strrmnr (pwd);
		parse_ftn_address (&neighbour_list[neighbours_count].adr,sadr);
		debug_neighbour (neighbour_list[neighbours_count].adr);
		strcpy (neighbour_list[neighbours_count++].password,pwd);
		check_neighbour_list ();
	}
	for (i=0; i<addr_index; i++) {
		neighbour_list[neighbours_count].adr=aka_list[i].aka;
		debug_neighbour (neighbour_list[neighbours_count].adr);		
		strcpy (neighbour_list[neighbours_count++].password,aka_list[i].password);
		check_neighbour_list ();
		neighbour_list[neighbours_count].adr=aka_list[i].uplink;
		debug_neighbour (neighbour_list[neighbours_count].adr);		
		strcpy (neighbour_list[neighbours_count++].password,aka_list[i].password);
		check_neighbour_list ();
	}
	return 1;
}

void debug_neighbour (ftn_address adr)
{
	debug (8,"Found neighbour : %d:%d/%d.%d",adr.zone,adr.network,
	       adr.node,adr.point);
}

void check_neighbour_list (void)
{
neighbour *temp;

	if (neighbours_count%20==0) {
 		temp=neighbour_list;
 		neighbour_list=malloc (sizeof (neighbour)*20*(1+neighbours_count/20));
		memcpy ((void*)neighbour_list,(void*)temp,neighbours_count*sizeof (neighbour));
		free (temp);
	}
}