/* This file implements all functions of fileecho tosser (I hope ;-) ) */
#include "fetoss.h"
#include "felib.h"
#include "crc32.h"
#include "convert.h"
#include "fidotools.h"
#include <dirent.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <regex.h>

extern char tempdir[];
extern int report_type;
extern int ticerror;
extern int apos;
extern int maxdays;
extern int autocreateerr;
extern char filebase[];
extern int addr_index;
extern aka_entry aka_list[];
extern int acount;
extern char fareasfile[];
extern char receiversfile[];
extern char sendersfile[];
extern char badfilesdir[];
extern char badticdir[];
extern char tic_key_names[][20];
extern filearea *areas;
extern char inbound_dir[];
extern int neighbours_count;
extern neighbour *neighbour_list;


void toss_new_files ()
{
DIR *inbdir;
struct dirent *entry;
FILE *ticfile;
fileinfo *infobuf=NULL,*tmp=NULL;
int fnum=0,fsize,tic_ok=0;
char buf[200];

	if (report_type) {
		/* Chdir to temp. directory */
		if ((infobuf=(fileinfo*)malloc (100*sizeof (fileinfo)))==NULL) {
			debug (1,"Can't allocate memory for report :-(((",
				tempdir,sys_errlist[errno]);
			abort_message ();	return;
		}
		fsize=100; /* Starting size o info buffer */
	}

/* Trying to open inbound directory */	
	if ((inbdir=opendir (inbound_dir))==NULL) {
		debug (1,"Can't open to inbound directory : %s",
			sys_errlist[errno]);
		abort_message ();
		strcpy (buf,tempdir);
		free (infobuf);
		return;
	}
/* Chdir to inbound directory	*/
	if (chdir (inbound_dir)==-1) {
		debug (1,"Can't chdir to inbound directory %s : %s",
			inbound_dir,sys_errlist[errno]);
		abort_message ();
		strcpy (buf,tempdir);
		free (infobuf);
		return;
	}	
/* Reading directory entries */
	while ((entry=readdir (inbdir))!=NULL) {
		if ((strstr (entry->d_name,".tic")!=NULL) ||
		    (strstr (entry->d_name,".TIC")!=NULL)) {
		    	/* Found .tic file - processing it ! */
		    	debug (1,"Processing TIC : %s",entry->d_name);
		    	if ((ticfile=fopen (entry->d_name,"r"))==NULL) 
		    		debug (1,"Can't open file %s",entry->d_name);
		    	else {
		    		if (process_tic (entry->d_name,ticfile,
		    		    (infobuf==NULL ? NULL : infobuf+fnum))) {
		    			fclose (ticfile);
		    			remove (entry->d_name); 
		    			debug (5,"TIC processing complete - erasing it");
		    			tic_ok++;
		    			if (infobuf!=NULL) {
			    			fnum++;
			    			if (fnum==fsize) {
			    				tmp=(fileinfo*)malloc ((fsize+50)*sizeof (fileinfo));
		    					memcpy ((void*)tmp,(void*)infobuf,fsize*sizeof (fileinfo));
		    					free (infobuf);
		    					infobuf=tmp;
		    					fsize+=50;
			    			}
			    		}
		    		} else {
		    			fclose (ticfile);
		    			check_tic (entry->d_name);
		    		}
		    	}
		}
	}
	
	strcpy (buf,tempdir);
	closedir (inbdir);
	make_report (infobuf,fnum);
	free (infobuf);
	debug (1,"%d TIC(s) succesfully processed",tic_ok);
	return;
}	

int process_tic (ticname,ticfile,info_rec)
char *ticname;
FILE *ticfile;
fileinfo *info_rec;
{
struct stat ticstat,srcstat;
time_t	curtime;
char buf[200],key[20],arg[180],repbuf[200]="",*ptr;
char tic_args[NUM_TIC_FIELDS][160]={"","","","","","",""};
char ldesc[MAX_LDESC_SIZE]="";
int i,index=-1;
int hsrc,hdest;
char destname[200],srcname[200],*cpybuf;
int cpycount=0,res,sendallowed=0,passwdok=-1;
ftn_address from;

	ticerror=0;
	stat (ticname,&ticstat);
	while (!feof (ticfile)) {
		fgets (buf,199,ticfile);
		for (i=0; i<NUM_TIC_FIELDS; i++) {
			sscanf (buf,"%s%s",key,arg);
			if (strcasecmp (key,tic_key_names[i])==0) 
				if (i==4) {
					ptr=buf;
					while (!isspace (*ptr)) ptr++;
					while (isspace (*ptr)) ptr++;
					strcpy (tic_args[i],ptr);
					strrmnr (tic_args[i]);
				}
				else {
					strcpy (tic_args[i],arg);
					break;
				}
		}
		if (strcasecmp (key,"LDESC")==0) {
			ptr=buf;
			while (!isspace (*ptr)) ptr++;
			while (isspace (*ptr)) ptr++;
			strrmnr (ptr);
			strcat (ldesc,ptr);
			strcat (ldesc,"\n");
		}
	}
	parse_ftn_address (&from,tic_args[2]);
	debug (5,"TIC file parsed succesfully");
	for (i=0; i<NUM_TIC_FIELDS; i++) 
		debug (10,"%s : %s",tic_key_names[i],tic_args[i]);
		
	for (i=0; i<apos; i++)
		if (strcasecmp (tic_args[0],areas[i].name)==0) index=i;
	if (index==-1) {
		if (!autocreate_area (tic_args[0],tic_args[2])) {
			ticerror=TIC_AUTOCREATE_ERROR;
			return 0;
		}
		index=apos-1;
	}
	strcpy (destname,areas[index].path);
	if ((ptr=strrchr (destname,'\n'))!=NULL)
		*ptr=0;
	if (destname[strlen (destname)-1]!='/') 
		strcat (destname,"/");
	strcpy (srcname,tic_args[3]);
	if (stat (srcname,&srcstat)==-1) {
		strup (srcname);	stat (srcname,&srcstat);
		if (stat (srcname,&srcstat)==-1) {
			strlow (srcname);	stat (srcname,&srcstat);
			if (stat (srcname,&srcstat)==-1) {
				debug (1,"Can not find file - skipping this TIC");
				return 0;
			}
		}
	}
	strcat (destname,srcname);
/* Checking : can this node send us a files via this confrence?
	      Or may be password is incorrect ?
*/
	if (areas[index].send_arr!=NULL) {
		for (i=0; i<areas[index].send_count; i++)
			if (eq_addr (&areas[index].send_arr[i],&from))
				sendallowed=1;
	}
	if (sendallowed) {
/* Checking TIC password for this neighbour */

		for (i=0; i<neighbours_count; i++)
			if (eq_addr (&neighbour_list[i].adr,&from))
				passwdok=(strcasecmp (neighbour_list[i].password,tic_args[6])==0 ? 1 : 0);
		if (passwdok==0) {
			debug (1,"TIC file for file %s containg WRONG password - ",srcname);
			sendallowed=0;
		} else
		if (passwdok==-1) {
			debug (1,"System %d:%d/%d.%d is unknown neighbour",
			       from.zone,from.network,from.node,from.point);
			sendallowed=0;
		}
	}
	if (!sendallowed){
		debug (1,"Error: node %d:%d/%d.%d is not allowed to send files into conference %s",
		       from.zone,from.network,from.node,from.point,
		       tic_args[0]);
		/* Moving file and TIC into "bad" directories */
		strcpy (destname,badfilesdir);
		if (destname[strlen (destname)-1]!='/')
			strcat (destname,"/");
		strcat (destname,srcname);
		res=ncopyfile (srcname,destname);
		if (res==1) {
			remove (destname);
			debug (1,"Can't read file %s : %s",srcname,sys_errlist[errno]);
			ticerror=TIC_FILE_READ_ERROR;
			return 0;
		} else if (res==2) {
			remove (destname);
			debug (1,"Can't write file %s : %s",destname,sys_errlist[errno]);
			ticerror=TIC_FILE_WRITE_ERROR;
			return 0;
		}
		debug (1,"File %s was succesfully copied to %s",srcname,destname);
		remove (srcname);
		strcpy (destname,badticdir);
		if (destname[strlen (destname)-1]!='/')
			strcat (destname,"/");
		strcat (destname,ticname);
		res=ncopyfile (ticname,destname);
		if (res==1) {
			remove (destname);
			debug (1,"Can't read file %s : %s",srcname,sys_errlist[errno]);
			ticerror=TIC_FILE_READ_ERROR;
			return 0;
		} else if (res==2) {
			remove (destname);
			debug (1,"Can't write file %s : %s",destname,sys_errlist[errno]);
			ticerror=TIC_FILE_WRITE_ERROR;
			return 0;
		}
		debug (1,"File %s was succesfully copied to %s",srcname,destname);		
		return 1;
	}				
	debug (5,"Source file : %s",srcname);
	debug (5,"Dest. file  : %s",destname);
	if ((hsrc=open (srcname,O_RDONLY))==-1) {
		debug (1,"Can't open file %s : %s",srcname,sys_errlist[errno]);
		ticerror=TIC_FILE_NOT_FOUND;
		return 0;
	}
	if ((hdest=creat (destname,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))==-1)
		switch (errno) {
			case ENOENT: 
				if (mkdir (areas[index].path,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH|S_IXUSR|S_IXGRP|S_IXOTH)!=-1) 
					if ((hdest=creat (destname,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))!=-1) 
						break;
			default :
				debug (1,"Can't create file %s : %s",destname,sys_errlist[errno]);
				close (hsrc);
				ticerror=TIC_DEST_FILE_ERROR;
				return 0;
		}
	if (strlen (tic_args[7])>0)
		apply_replaces (tic_args[7],areas[index].path);
/* Copying source file to its directory */	
	debug (5,"Copying %s to %s",srcname,destname);
	res=copyfile (hsrc,hdest);
	if (res==1) {
		close (hsrc);	close (hdest);
		remove (destname);
		debug (1,"Can't read file %s : %s",srcname,sys_errlist[errno]);
		ticerror=TIC_FILE_READ_ERROR;
		return 0;
	} else if (res==2) {
 		close (hsrc);	close (hdest);
		remove (destname);
		debug (1,"Can't write file %s : %s",destname,sys_errlist[errno]);
		ticerror=TIC_FILE_WRITE_ERROR;
		return 0;
	}
	close (hsrc);
	if (close (hdest)==-1) {
		remove (destname);
		debug (1,"Can't close file %s : %s",destname,sys_errlist[errno]);
		ticerror=TIC_FILE_CLOSE_ERROR;
		return 0;
	}
	send_to_receivers (destname,ticfile,index);
	if (info_rec!=NULL) {
		strcpy (info_rec->fe_name,strleft (strup (strcpy (buf,tic_args[0])),19));
		strcpy (info_rec->filename,strleft (strup (strcpy (buf,tic_args[3])),15));
		info_rec->size=srcstat.st_size/1024;

/* Important !!! By default I assume that you receive TIC files with
   CP866 charset (ASCII). I'm converting file description (tic_arg[4]) to
   KOI8-R for report. If you're using another charsets please change something
   below 
 */
 		if (ldesc[0]==0) 
			strcpy (info_rec->desc,alt2koi (strcpy (buf,tic_args[4])));
		else
			strcpy (info_rec->desc,alt2koi (strcpy (buf,ldesc)));
	}
	debug (5,"File copied succesfully");
	remove (srcname); 
	return 1;
}

int check_tic (ticname)
char *ticname;
{
struct stat ticstat;
time_t	curtime;

	curtime=time (&curtime);
	stat (ticname,&ticstat);
	if ((curtime-ticstat.st_mtime)/(60L*60L*24L) > maxdays) {
		debug (1,"Old TIC file %s found - removing it",ticname);
		remove (ticname);
	}
	return 0;
}

int autocreate_area (areaname,fromnode)
char *areaname;
char *fromnode;
{
char dir[200],buf[100],*ptr=buf;
FILE *txtfile;
filearea *tempptr;
int i,index=-1;

	autocreateerr=AC_OK;
	debug (1,"Autocreate requested - creating area %s from %s",areaname,fromnode);
	strcpy (buf,areaname);
	strlow (buf);
	while (*ptr!=0) {
		if (*ptr=='.') *ptr='_';
		ptr++;
	}
	strcpy (dir,filebase);
	if  (dir [strlen (dir)-1]!='/') strcat (dir,"/");
	strcat (dir,buf);

/* Writing an information about new fileecho into "areas" array */
	strcpy (areas[apos].name,areaname);
	strcpy (areas[apos].path,dir);
	parse_ftn_address (&areas[apos].uplink,fromnode);
/* Looking for AKA for this uplink */
	for (i=0; i<addr_index; i++) 
		if ((aka_list[i].uplink.zone==areas[apos].uplink.zone) &&
		    (aka_list[i].uplink.network==areas[apos].uplink.network) &&
		    (aka_list[i].uplink.node==areas[apos].uplink.node)) {
			index=i; break;
		}
	if (index==-1) {
		debug (1,"TIC file arrived from unknow uplink %s",fromnode);
		autocreateerr=AC_UNKNOWN_UPLINK;
		return 0;
	} else areas[apos].aka=aka_list[index].aka;
	debug (1,"AKA entry index : %d",index);
	debug (1,"AKA for this area : %d:%d/%d.%d\n",aka_list[index].aka.zone,
		   aka_list[index].aka.network,
		   aka_list[index].aka.node,
		   aka_list[index].aka.point);	
	
	strcpy (buf,"Autocreated file area from ");
	strcat (buf,fromnode);
	strcpy (areas[apos].description,buf);
	strcpy (areas[apos].flags,"R");
	areas[apos].subs_arr=(ftn_address*)malloc (20*sizeof (ftn_address));
	areas[apos].subs_count=1;
	areas[apos].subs_arr[0]=areas[apos].uplink;
	areas[apos].send_arr=(ftn_address*)malloc (20*sizeof (ftn_address));
	areas[apos].send_count=1;
	areas[apos].send_arr[0]=areas[apos].uplink;
	
	debug (1,"Creating directory %s",dir);
	if (mkdir (dir,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH|S_IXUSR|S_IXGRP|S_IXOTH)==-1) {
		if (errno!=EEXIST) {
			debug (1,"Unable to create this directory : %s",sys_errlist [errno]);
			autocreateerr=AC_CANNOT_CREATE_DIR;
			return 0;
		}
	}

	if (apos==acount-1) {	/* We need to expand array */
		tempptr=(filearea*) malloc ((acount+30)*sizeof (filearea));
		memcpy ((void*)tempptr,(void*)areas,acount*sizeof (filearea));
		free ((void*)areas);
		areas=tempptr;	acount+=30;
	}
	apos++;
	
/* Writing an informantion about new fileecho into FAreas configuration file
   Senders & Receivers file */
   
	txtfile=fopen (fareasfile,"a");
	fputs ("\n# Autocreated area\n",txtfile);
	fprintf (txtfile,"Name\t%s\n",areaname);
	fprintf (txtfile,"Path\t%s\n",dir);
	fprintf (txtfile,"AKA\t%d:%d/%d.%d\n",aka_list[index].aka.zone,
					      aka_list[index].aka.network,
					      aka_list[index].aka.node,
					      aka_list[index].aka.point);
	fprintf (txtfile,"Uplink\t%s\n",fromnode);
	fprintf (txtfile,"Desc\t%s\n",buf);
	fprintf (txtfile,"Flags\t%s\n",areas[apos-1].flags);
	fclose (txtfile);
	txtfile=fopen (receiversfile,"a");	
	fprintf (txtfile,"%s\n",areaname);
	fclose (txtfile);
	txtfile=fopen (sendersfile,"a");	
	fprintf (txtfile,"%s\n",areaname);
	fclose (txtfile);
	send_autocreat_message (apos-1);
	
	return 1;
}

void send_autocreat_message (index)
int index;
{
FILE *tmpfile;
char name[200],buf[200];

	if (!report_type) return;
	strcpy (name,tempdir);	strcat (name,"/FEmessage.tmp");
	if ((tmpfile=fopen (name,"w"))==NULL) {
		debug (1,"Can't create temporary file %s : ",name,sys_errlist[errno]);
		return;
	}
	fprintf (tmpfile,"\nAutocreated area : %s\n\n",areas[index].name);
	fprintf (tmpfile,"Created directory  : %s\n",areas[index].path);
	fprintf (tmpfile,"Autocreate requested from   : %d:%d/%d.%d\n",
		 areas[index].uplink.zone,
		 areas[index].uplink.network,
		 areas[index].uplink.node,
		 areas[index].uplink.point);
	fprintf (tmpfile,"Selected AKA  for this area : %d:%d/%d.%d\n",
		 areas[index].aka.zone,
		 areas[index].aka.network,
		 areas[index].aka.node,
		 areas[index].aka.point);
	fprintf (tmpfile,"Area description   : %s\n",areas[index].description);
	fprintf (tmpfile,"Flags              : %s",areas[index].flags);
	fprintf (tmpfile,FE_SIGN);
	fclose (tmpfile);
	strcpy (buf,AC_SUBJ);	strcat (buf," ");	
	strcat (buf,areas[index].name);
	send_message (name,buf);
}

void make_report (fileinfo *ibuf,int fnum)
{
int i,flag,got_something=0,flag2;
FILE *reportf;
char buf[200],cur_fe[20],tempname[200],*ptr,*start,sc;
unsigned long areatotal=0, total=0;

	strcpy (tempname,tempdir);
	strcat (tempname,"/FEreport.tmp");
	if ((reportf=fopen (tempname,"w"))==NULL) {
		debug (1,"Can't create file %s - report will not be sent !",tempname);
		debug (1,"Reason : %s",sys_errlist[errno]);
		return;
	}
	fputs ("\t\t\t Hello, Dear SysOp !\n\n",reportf);
	fprintf (reportf,"Today, %s, FEToss %s have received following file(s) :\n",
	         date (),VERSION);
	do {
		i=0;
		while ((i<fnum) && (strlen (ibuf[i].fe_name)<2)) i++;
		if (i<fnum) {
			strcpy (cur_fe,ibuf[i].fe_name);
			fprintf (reportf,"\nArea : %s\n",cur_fe);
			fprintf (reportf,"%s\n",strreplicate (buf,'-',27));
			total+=areatotal;
			areatotal=0;
			got_something=1;
			while (i<fnum) {
				if (strcasecmp (cur_fe,ibuf[i].fe_name)==0) {
					fprintf (reportf,"%-12s  %9ld Kb  ",
						 ibuf[i].filename,
						 ibuf[i].size);
					format_text (ibuf[i].desc,48);
					areatotal+=ibuf[i].size;
					ptr=ibuf[i].desc;
					start=ptr;
					flag2=1;
					while (1) {
						if ((*ptr=='\n') || (*ptr==0)){
							sc=*ptr;
							*ptr=0;
							if (!flag2) 
								fprintf (reportf,"%28s"," ");
							fprintf (reportf,"%-s\n",start);
							flag2=0;
							if (sc==0)
								break;
							*ptr=sc;
							start=ptr+1;
						}
						ptr++;
					}
					strcpy (ibuf[i].fe_name,"");
				}
				i++;
			}
			fprintf (reportf,"\nTotal in area : %9ld Kb\n",areatotal);
		}
		flag=0;
		for (i=0; i<fnum; i++)
			if (strlen (ibuf[i].fe_name)>1) flag=1;
	} while (flag);
	total+=areatotal;
	fprintf (reportf,"\nTotal : %9ld Kb\n",total);
	fprintf (reportf,FE_SIGN);
	fclose (reportf);
	if (got_something)
		send_message (tempname,DEF_SUBJECT);
	remove (tempname);
}

void send_to_receivers (char *filename,FILE *ticfile,int index)
{
char buf[400],tempname[300],str[MAX_TIC_LINE_LENGTH],ticname[15],key[400];
FILE *dest;
char *ticbuf,*ptr,temp,*start;
int tlcount=0,mtl=MAX_TIC_LINE_LENGTH,i,j,k;
int path_f=0,seenby_f=0;
ftn_address from_orig;
ftn_address seenby[MAX_SEENBY_RECORDS],origin;
int seenby_count=0,where_path_ends,where_seenby_ends;
int needsend=1,l,pwdfound,dummysend;
time_t curtime;
unsigned long crc;

	debug (5,"Forwarding arrived file to receivers...");
	if (areas[index].subs_count==0) return;
	ticbuf=(char*)malloc (MAX_TIC_LINES*mtl);
	rewind (ticfile);
	do {
		fgets (buf,399,ticfile);
		if (feof (ticfile))
			break;
		if (strkey (buf,"PW")!=NULL) 
			continue;
		strcpy (ticbuf+mtl*tlcount++,buf);
		if (tlcount==MAX_TIC_LINES) {
			debug (1,"Error : TIC file contains more lines than MAX_TIC_LINES. TIC rejected");
			return;
		}
	} while (!feof (ticfile));
	tlcount--;
	/* TIC file is loaded. Now we have to add our local information */
	for (i=0; i<tlcount; i++) {
		strcpy (str,ticbuf+i*mtl);
		strup (str);
		if (strkey (str,"ORIGIN")!=NULL) {
			ptr=str;
			strltrim (ptr);
			while (isdigit (*ptr)==0) ptr++;
			start=ptr;
			while ((isspace (*ptr)==0) && (*ptr!=0)) ptr++;
			*ptr=0;
			parse_ftn_address (&origin,start);
		}
		if ((strkey (str,"PATH")==NULL) && path_f) {
			where_path_ends=i;
			path_f=0;
		}
		if ((strkey (str,"SEENBY")==NULL) && seenby_f) {
			where_seenby_ends=i;
			seenby_f=0;
		}
		if (strkey (str,"FROM")!=NULL) {
			sprintf (ticbuf+i*mtl,"From %d:%d/%d.%d\r\n",
				 areas[index].aka.zone,
				 areas[index].aka.network,
				 areas[index].aka.node,
				 areas[index].aka.point);
			while (isdigit(str[0])==0) strcpy (str,str+1);
			parse_ftn_address (&from_orig,str);
			continue;
		}
		if (strkey (str,"PATH")!=NULL) 
			path_f=1;
		if (strkey (str,"SEENBY")!=NULL) {
			seenby_f=1;
			ptr=str;
			strltrim (str);
			while (!isspace (*ptr)) ptr++;
			while (*ptr!=0) {
				while (isspace (*ptr)) ptr++;
				if (*ptr==0)
					break;
				start=ptr;
				while (!isspace (*ptr)) ptr++;
				temp=*ptr;
				*ptr=0;
				if (seenby_count==MAX_SEENBY_RECORDS) {
					debug (1,"The number of SEENBY records is bigger than MAX_SEENBY_RECORDS");
				}
				else
					parse_ftn_address (seenby+seenby_count++,start);
				debug (8,"Found SEENBY : %s",start);
				*ptr=temp;
			}
		}
	}
	if (seenby_f)
		where_seenby_ends=tlcount;
		
	for (i=0; i<areas[index].subs_count; i++) {
		dummysend=0;
		for (k=0; k<addr_index; k++) 
			if (eq_addr(&areas[index].subs_arr[i],&aka_list[k].aka)) {
				dummysend=1;
				break;
			}
		if (dummysend)
			continue;
		needsend=1;
		for (j=0; j<seenby_count; j++)
			if (eq_addr (seenby+j,&areas[index].subs_arr[i]))
				needsend=0;
		if (needsend) {
			/* Sending file to this receiver */
			time (&curtime);
			sprintf (key,"%d:%d/%d.%d (%ld)",
				 areas[index].subs_arr[i].zone,
				 areas[index].subs_arr[i].network,
				 areas[index].subs_arr[i].node,
				 areas[index].subs_arr[i].point,
				 curtime);
			strcat (key,filename);
			strcat (key,areas[index].name);
			crc=count_crc32 (key);
			sprintf (ticname,"/%08x.tic",crc);
			strcpy (buf,tempdir);
			strcat (buf,ticname);	/* TIC file name ready */
			ptr=key;
			while (!isspace (*ptr)) ptr++;
			*ptr=0;
			strcpy (tempname,buf);
			if ((dest=fopen (buf,"w"))==NULL) {
				debug (1,"Can't create file %s - skipping receiver",buf);
			} else {
				for (k=0; k<=tlcount; k++) {
					if (k==where_path_ends) {
						time (&curtime);
						strcpy (buf,ctime(&curtime));
						*strchr (buf,'\n')=0;
						if (!eq_addr (&origin,&areas[index].aka))
							fprintf (dest,"Path %d:%d/%d.%d %ld %s\r\n",
							areas[index].aka.zone,
							areas[index].aka.network,
							areas[index].aka.node,
							areas[index].aka.point,
							curtime,
							buf);
					}
					if (k==where_seenby_ends) 
						if (!eq_addr (&origin,&areas[index].aka))
							fprintf (dest,"Seenby %d:%d/%d.%d\r\n",
								areas[index].aka.zone,
								areas[index].aka.network,
								areas[index].aka.node,
								areas[index].aka.point);
					if (k<tlcount)
						fprintf (dest,"%s",ticbuf+k*mtl);
				}
				pwdfound=0;
				for (l=0; l<neighbours_count; l++)
					if (eq_addr (&areas[index].subs_arr[i],&neighbour_list[l].adr)) {
						pwdfound=1;
						break;
					}
				if (pwdfound) {
					fprintf (dest,"Pw %s\r\n",neighbour_list[l].password);
					fclose (dest);
					attachfile (tempname,key,0,1,0);
					attachfile (filename,key,0,0,0);
				} else {
					fclose (dest);
					remove (tempname);
					debug (1,"Error : System %d:%d/%d.%d is unknown for us - can't send file there",
						areas[index].aka.zone,
						areas[index].aka.network,
						areas[index].aka.node,
						areas[index].aka.point);
				}
			}
		}
	}
	remove (tempname);
	return;
}

void apply_replaces (char *filemask, char *path)
{
struct re_pattern_buffer buf[3];
char str[200],name[20],*ptr,*re_ptr;
struct dirent *de;
DIR *fe_dir;
int i,dnamelen;
	
	if ((strcmp (filemask,"*")==0) || (strcmp (filemask,"*.*")==0) ||
	    (strcmp (filemask,"????????.???")==0) || 
	    (strcmp (filemask,"*.???")==0) || (strcmp (filemask,"*.???")==0))
	    	return;
	debug (5,"Deleting file(s) %s",filemask);
	if ((strchr (filemask,'*')==NULL) && (strchr (filemask,'?')==NULL)) {
	// Removing file "filemask"
		strcpy (name,path);
		strcat (name,"/");
		ptr=str+strlen (name);
		strcat (name,filemask);
		debug (5,"Erasing file %s",name);
		if (remove (name)==-1) {
			strup (ptr);
			if (remove (name)==-1) {
				strlow (ptr);
				if (remove (name)==-1) 
					debug (1,"Can not erase file %s",filemask);
			}
		}
	} else {
	// Removing all files matching "filemask"
	
		// Opening directory "path"
		if ((fe_dir=opendir (path))==NULL) {
			debug (1,"Can't open directory %s : %s",path,
			       sys_errlist[errno]);
			return;
		}
		ptr=filemask;
		re_ptr=str;
		*re_ptr++='^';
		while (*ptr) {
			switch (*ptr) {
				case '*':	*re_ptr++='.';
						*re_ptr++='*';
						break;
				case '?':	*re_ptr++='.';
						break;
				case '.':	*re_ptr++='\\';
						*re_ptr++='.';
						break;
				default:	*re_ptr++=*ptr;
						break;
			}
			ptr++;
		}
		*re_ptr++='$';
		*re_ptr=0;
		for (i=0; i<3; i++) {
			buf[i].translate=0;
			buf[i].fastmap=(char*)0;
			buf[i].allocated=1;
			buf[i].buffer=(void*)malloc (buf[i].allocated);
		}
		// Regular expression is ready for compiling
		if (re_compile_pattern (str,strlen (str),buf)!=NULL) {
			debug (1,"RE patterns <%s> was not compiled succesfully!",str);
			closedir (fe_dir);
			return;
		}
		strlow (str);
		re_compile_pattern (str,strlen (str),buf+1);
		strup (str);
		re_compile_pattern (str,strlen (str),buf+2);
		strcpy (name,path);
		strcat (name,"/");
		ptr=name+strlen(name);
		while ((de=readdir (fe_dir))!=NULL) {
			dnamelen=strlen (de->d_name);	
			for (i=0; i<3; i++) 
				if (re_match (buf+i,de->d_name,strlen (de->d_name),
				              0,(struct re_registers*)0)==dnamelen) {
					strcpy (ptr,de->d_name);
					debug (5,"Erasing file %s",name);
					/* if (remove (name)==-1) 
						debug (1,"Can not erase file %s",name); */
				}
		}
		closedir (fe_dir);
		for (i=0; i<3; i++)
			free (buf[i].buffer);
	}
} 
