#include <time.h>
#include <varargs.h>
#include "fidotools.h"

#ifndef FELIB_H
#define FELIB_H

/* This function returns string containing date and time in ASCII format */
char *date (void);
/* This function removes first spaces from astring */
char *strltrim (char* );
/* This is a main debugging tool */
void debug (unsigned long,char*,...);
/* Convert string to upper case */
char *strup (char*);
/* Convert string to lower case */
char *strlow (char*);
/* This function sends a message to administrator via mail or news */
void send_message (char*,char*);
/* This function gets first n chars from string */
char *strleft (char*,int);
/* This function makes a string containing n chars */
char *strreplicate (char*,char,int);
/* Function for converting FTN address into its components */
int parse_ftn_address (ftn_address*, char*);
/* Function for copying one file into another */
int copyfile (int,int);
int ncopyfile (char*, char*);
/* Function for checking for argument type (0-option,1-argument) */
int checkarg (char*);
/* Function for comparing 2 ftn-addreses */
int eq_addr (ftn_address*, ftn_address*);
/* Function for removing chars \n and \r from the string */
char *strrmnr (char*);
/* Function for making formatted text with fixed width */
char *format_text (char*, int);

char *strkey (char*, char*);

void abort_message (void);

#endif