#include <time.h>
#include <stdio.h>
#include <string.h>
#include <varargs.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "fidotools.h"

extern int debug_level;
extern FILE *logfile;
extern int report_type;
extern char reportto[];

char *date(void)
{
time_t now;
static char buf[40];
struct tm ltm;

	time(&now);
	ltm=*localtime (&now);
	strftime (buf,39,"%b %d %X",&ltm);
	return(buf);
}

char *strltrim (str)
char *str;
{
	while ((str[0]==' ') || (str[0]=='\t')) strcpy (str,str+1);
	return str;
}

void debug(va_alist)
va_dcl
{
va_list		args;
unsigned long	level;
char		*fmt;

	va_start(args);
	level=va_arg(args, unsigned long);
	fmt=va_arg(args, char*);

	if (level<=debug_level)
	{	
		fprintf (logfile,"%s  ",date());
		vfprintf(logfile,*fmt == '$' ? fmt+1 : fmt,args);
		if (*fmt == '$')
			fprintf(logfile,"\n\terrno=%d : %s\n",
				errno,strerror(errno));
		else
			fprintf(logfile,"\n");
		fflush(logfile);
	}
	va_end(args);
	return;
}	

char *strup (str)
char *str;
{
char *ptr=str;
	while (*ptr!=0) *ptr++=(char)toupper ((int)*ptr);
	return str;
}

char *strlow (str)
char *str;
{
char *ptr=str;
	while (*ptr!=0) *ptr++=(char)tolower ((int)*ptr);
	return str;
}

void send_message (filename,subject)
char *filename;
char *subject;
{
char param_str[2][80]={"",""};
char buf[200];
char program[200]="",*ptr;
int pdes[2],rc;
pid_t	pid;
FILE 	*msg,*txtfile;

	if (!report_type) return;
	fflush (stdout);	fflush (stderr);
	if (pipe (pdes)!=0) {
		debug (1,"Can't create pipe");
		return;
	}
	fflush (logfile);
	if (report_type==1) {
	/* Mailing report */
		strcpy (program,SENDMAIL);
		strcpy (param_str[0],reportto);
	} else {
		strcpy (program,INEWS);
		strcpy (param_str[0],"-h");
		strcpy (param_str[1],"-S");
	}
	debug (1,"Executing : %s %s %s",program,param_str[0],param_str[1]);
	switch ((pid=fork ())) {
		case -1: 
			debug (1,"Can't fork : %s",sys_errlist[errno]);
			close (pdes[0]);	close (pdes[1]);
			return; 	
		case 0:		/* We're in child process ! */
			close (pdes[1]);
			close (0);
			if (dup (pdes[0]) != 0) {
				debug (1,"Can't reopen stdin in child process!");
				exit (-1);
			}
			rc=execl (program,program,param_str[0],param_str[1],NULL);
			debug (2,"Exec of %s returned %d : ",program,rc,
			       sys_errlist[errno]);
			exit (-1);
		default: break;
	}
	close (pdes[0]);
	if ((msg=fdopen (pdes[1],"w"))==NULL) {
		debug (1,"fdopen failed for pipe to command %s",program);
		close (pdes[1]);
		return;
	}
	fprintf (msg,"Subject: %s",subject);
	fprintf (msg," (%s)\n",date ());
	fprintf (msg,"From: FEtoss\n");
	if (report_type==2) 
		fprintf (msg,"Newsgroups: %s\n",reportto);
	fprintf (msg,"\n");	/* End of header */
	txtfile=fopen (filename,"r");
	while (!feof (txtfile)) {
		fgets (buf,200,txtfile);
		if (!feof (txtfile)) {
			if ((ptr=strchr (buf,0x0d))!=NULL) 
				*ptr=' ';
			fputs (buf,msg);
		}
	}
	fclose (txtfile);	fclose (msg);
	return;
} 
	
char *strleft (char *str, int num)
{
	*(str+num)=0;
	return str;
}

char *strreplicate (char *str,char c,int n)
{
int i;
	for (i=0; i<n; i++) *(str+i)=c;
	*(str+n)=0;
	return str;
}

int parse_ftn_address (adr,stradr)
char *stradr;
ftn_address *adr;
{
char *ptr=stradr;
	while (!isdigit (*ptr)) ptr++;
	adr->zone=atoi (ptr);
	while (*ptr!=':') ptr++;	ptr++;	adr->network=atoi (ptr);
	while (*ptr!='/') ptr++;	ptr++;	adr->node=atoi (ptr);
	while ((*ptr!='.') && (*ptr!=0))	ptr++;
	if (*ptr!=0) {
		ptr++;	adr->point=atoi (ptr);
	} else adr->point=0;
	return 1;
}

void abort_message ()
{
	debug(0,"%s : FEToss %s aborted\n",date (),VERSION);
	return;
}

int copyfile (int hsrc, int hdest)
{
char *cpybuf;
int cpycount;

	cpybuf=(char *)malloc (COPY_BUF_SIZE);
	do {
		if ((cpycount=read (hsrc,cpybuf,COPY_BUF_SIZE))==-1) {
			return 1;
		}
		if (cpycount==0) break;
		if (write (hdest,cpybuf,cpycount)==-1) {
			return 2;
		}
	} while (cpycount>0);
	free (cpybuf);
	return 0;
}

int ncopyfile (char *src, char *dest)
{
int hsrc,hdest;
	if ((hsrc=open (src,O_RDONLY))==-1) {
		debug (1,"Can not open %s",src);
		return 0;
	}
	if ((hdest=creat (dest,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))==-1) {
		debug (1,"Can not create %s",dest);
		close (hsrc);
		return 0;
	}
	copyfile (hsrc,hdest);
	close (hsrc);	close (hdest);
	return 1;
}	

int checkarg (char *argstr)
{
	if ((argstr[0]=='-') && (strlen (argstr)<4))
		return 0;
	return 1;
}

int eq_addr (ftn_address *adr1, ftn_address *adr2)
{
	if ((adr1->zone==adr2->zone) &&
	    (adr1->network==adr2->network) &&
	    (adr1->node==adr2->node) &&
	    (adr1->point==adr2->point)) 
	    	return 1;
	else
		return 0;
}

char *strkey (char *str, char *key)
{
char *ptr=str;

	while (isspace (*ptr)) ptr++;
	if (strstr (ptr,key)!=ptr)
		return NULL;
	else 
		return ptr;
}

char *strrmnr (char *str)
{
char *ptr;

	if ((ptr=strchr (str,'\n'))!=NULL)
		*ptr=0;
	if ((ptr=strchr (str,'\r'))!=NULL)
		*ptr=0;
	return (str);
}

char *format_text (char *text, int width)
{
int count=1,lspos=1;
char *ptr=text,*ls;

/* XXXXXXXXXX XXXXXX XXXXX XXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX XXXXX */
	while (*ptr!=0) {
		if ((*ptr=='\t') || (*ptr=='\n')) 
			*ptr=' ';
		ptr++;
	}
	ptr=text;
	while (strlen (ptr)>width) {
		ls=ptr;
		ptr+=width;
		while ((!isspace (*ptr)) && (ptr!=ls)) ptr--;
		if (ptr==ls) {
		// There is no spaces in this line - truncating it!
			ptr+=width;
			memmove ((void*)ptr+1,(void*)ptr,strlen (ptr));
			*ptr='\n'; ptr++;
		} else {
			*ptr='\n';
			ptr++;
		}
	}
	return text;
}							