/* Source file for file attach utility */
#include "attach.h"
#include "fidotools.h"
#include "felib.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

extern char outbound_dir[];
extern char tempdir[];

void attachfile (char *filename, char *address, int copyflag, int clearflag,
                 int needoutput)
{
ftn_address to;
char floname[200],buf[200],dir[200];
char srcname[200]="",destname[200],*ptr;
FILE *flo;
int hsrc,hdest,res;

	parse_ftn_address (&to,address);
	/* Looking for file for making attach */
	strcpy (buf,filename);
	strltrim (buf);
	if (buf[0]!='/') {
	/* It's local name */
		getcwd (dir,199);
		strcpy (srcname,dir);
		strcat (srcname,"/");
		strcat (srcname,buf);
	} else 
	/* It's absolute path */
		strcpy (srcname,buf);
	if ((hsrc=open (srcname,O_RDONLY))==-1) {
		sprintf (buf,"Error : can not access file %s : %s",srcname,
			 sys_errlist[errno]);
		debug (1,buf);
		if (needoutput)
			puts (buf);
		return;
	}
	if (copyflag) {
		strcpy (buf,filename);
		strltrim (buf);
		strcpy (destname,tempdir);
		strcat (destname,"/");
		if ((ptr=strrchr (buf,'/'))==NULL)
			ptr=buf;
		else ptr++;
		strcat (destname,ptr);
		if ((hdest=creat (destname,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))==-1) {
			sprintf (buf,"Error : can not create file %s : %s",destname,
			sys_errlist[errno]);
			debug (1,buf);
			if (needoutput)
				puts (buf);
			close (hsrc);
			return;
		}
		res=copyfile (hsrc,hdest);
		if (res==1) {
			sprintf (buf,"%s : read error (%s)",srcname,
			sys_errlist[errno]);
			debug (1,buf);
			if (needoutput)
				puts (buf);
			close (hsrc); close  (hdest);
			return;
		} else if (res==2) {
			sprintf (buf,"%s : write error (%s)",destname,
			sys_errlist[errno]);
			debug (1,buf);
			if (needoutput)
				puts (buf);
			close (hsrc); close  (hdest);
			return;
		}
		close (hdest);	close (hsrc);
		strcpy (srcname,destname);
	}
	/* File name is ready in <srcname> */
	strcpy (floname,outbound_dir);
	strcat (floname,"/");
	sprintf (buf,"%04x",to.network);
	strcat (floname,buf);
	sprintf (buf,"%04x",to.node);
	strcat (floname,buf);
	if (to.point) {
		strcat (floname,".pnt");
		if (mkdir (floname,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH|S_IXUSR|S_IXGRP|S_IXOTH)==-1)
			if (errno!=EEXIST) {
				sprintf (buf,"Can not create directory %s : %s ",floname,
				sys_errlist[errno]);
				debug (1,buf);
				if (needoutput)
					puts (buf);
				return;
			}
		strcat (floname,"/");
		sprintf (buf,"%08x",to.point);
		strcat (floname,buf);
	}
	strcat (floname,".flo");	/* FLO file name ready */
	if ((flo=fopen (floname,"a+"))==NULL) {
		sprintf (buf,"Can not open FLO file %s : %s",floname,
		sys_errlist[errno]);
		debug (1,buf);
		if (needoutput)
			puts (buf);
		return;
	}
	rewind (flo);
	while ((!feof (flo)) && (!ferror (flo))) {
		fgets (buf,199,flo);
		if (strstr (buf,srcname)!=NULL) {
			sprintf (buf,"Warinig : file %s is already attached to ",srcname,
			address);
			debug (1,buf);
			if (needoutput)
				puts (buf);
		}
	}
	fprintf (flo,"\n");
	if (clearflag) 
		fprintf (flo,"#");
	fprintf (flo,"%s",srcname);
	fclose (flo);
	sprintf (buf,"Attach : %s -> %s",srcname,
		 address);
	debug (1,buf);
	if (needoutput)
		puts (buf);	
	return;
}



