/*
    xtgui.h  userinterface for XToolkit


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef __xtgui_h__
#define __xtgui_h__

#include <misc1.h>

#ifdef XTK

#ifdef XPM
#include <X11/xpm.h>
#endif

#include "xabsgui.h"

// include Athena Widget headers AFTER xabsgui.h

#include <X11/Xaw/Simple.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Toggle.h>
#include <X11/RectObj.h>
#include <X11/Xmu/Converters.h>
#include <X11/Shell.h>


#define NR_OF_HELPBUTTONS	(9)

extern String fallback_resources[];


class XtGui : public XAbstractGui {

protected:
	unsigned int	which_bp;

// Xtoolkit stuff
	Widget 		 e2toplevel, form, menubar, e2screen;
	Widget		 button1, button2, button3;
	Widget		 menu1, menu2, menu3, menu4;
	Widget		 entry11, entry12,
			 entry21, entry22, entry23, entry24;
	Widget		 entry31, entry32, line1, line2;
	Widget		 messageframe, messageform, messagetext, messagebutton;
	Widget		 helpframe, helpform, helptext, helpokbutton;
	Widget		 helpbutton[NR_OF_HELPBUTTONS];
	Widget		 aboutframe, aboutform, abouttext, aboutbutton;
	Widget		 cpuframe, cpuform, cputext;
	Widget		 nextbutton, stepbutton, runbutton, stopbutton;
	Widget		 bp1button, bp2button, cpubutton, resetbutton;
	Widget		 bpframe, bpform, bptext, bpbutton, clearbutton;
	Pixmap		 okpixmap, mainpixmap, cpupixmap;
	XtAppContext	 context;
	XrmOptionDescList opts;
#ifdef XPM
	Widget		 morebutton;
	Widget		 authorframe, authorform, authorwidget, authorbutton;
	Pixmap		 authorpixmap;
#endif

	virtual Display	 *getDisplay(void);
	virtual Window	 getWindow(void);

protected:
	virtual Widget		create_main_view(int argc, char *argv[],
					int sync);
	virtual void		create_message_dialog(Widget parent);
	virtual void		create_about_dialog(Widget parent);
	virtual void		create_help_view(Widget parent);
	virtual void		create_cpuview(Widget parent);
	virtual void		create_bp_dialog(Widget parent);
	virtual void		manage_widget(Widget w);
	virtual String		get_man_page(char *pman_page_name);
	virtual void		initialize_after_create(Widget w, int inverse,
				   const char *color);
	virtual void		initialize_after_open(Widget w, char *title);
	virtual void		initialize(struct sGuiOptions *pOptions);
	virtual void		event_queue(void);
#ifdef XPM
	virtual void		create_author_dialog(Widget parent);
#endif

// Internal registers

protected:

	int		cpu_popped_up;
	int		poll_count;

// Initialisation functions

protected:

	virtual void	initialize_e2window(struct sGuiOptions *pOptions);

// public interface
public:

	virtual void 	popup_about(void);
	virtual int 	popup_help(void);
	virtual void 	popup_cpu(void);
	virtual void 	popup_bp(unsigned int which);
	virtual void 	popdown_message(void);
	virtual void 	popdown_about(void);
	virtual void 	popdown_help(void);
	virtual void 	popdown_cpu(void);
	virtual void 	popdown_bp(void);
	virtual void 	toggle_cpu(void);
	virtual void	clear_bp(void);
	virtual void	display_man_page(Widget w);
#ifdef XPM
	virtual void	a_expose(Widget w, XEvent *pevent);
	virtual void 	popup_author(void);
	virtual void 	popdown_author(void);
#endif

// callbacks:
private:
	static void 	updateNafsCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuExitCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuRunCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuStopCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuStepCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuNextCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuResetCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	setCpuResetRunCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	toggleCpuCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popdownCpuCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popupHelpCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	displayManPageCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popdownHelpCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popupAboutCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popdownAboutCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popupBp0Callback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popupBp1Callback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	clearBpCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popdownBpCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popupAuthorCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popdownAuthorCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	static void 	popdownMessageCallback(Widget w,
		XtPointer client_data, XtPointer call_data);
	void 	updateNafs(void);


// accelerators:
public:
	virtual void	c_expose(XEvent *pevent);
	virtual void	c_keyPress(XEvent *pevent);
	virtual void	c_focusIn(XEvent *pevent);
	virtual void	c_process_resize(XEvent *pevent);

public:
	virtual void	redraw_cpuview_impl(struct s_cpu_status *pstat,
						int status);
	virtual void 	popup_message(char *pmessage);
	virtual int 	gui_type(void);

// Public constructor and destructor
public:
		 XtGui(
		 	Mc6809* x_cpu,
		 	Inout* x_io,
		 	E2video* x_video,
		 	struct sGuiOptions *options);
		virtual ~XtGui();
};


#endif // ifdef XTK
#endif // __xtgui_h__

