/*
    xtgui.cpp  user interface for XToolkit


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <misc1.h>

#ifdef XTK

#include "xtgui.h"
#include <ctype.h>

#include "ok.xbm"
#include "flexmain.xbm"

#ifdef XPM
#include "author.xpm"
#endif

// global variables
XtGui *ggui;

/*ARGSUSED*/
void expose(Widget w, XEvent *pevent, String *pparams, Cardinal *pnparams)
{
	ggui->c_expose(pevent);
}

#ifdef XPM
/*ARGSUSED*/
void author_expose(Widget w, XEvent *pevent, String *pparams, Cardinal *pnparams)
{
	ggui->a_expose(w, pevent);
}
#endif

/*ARGSUSED*/
void keyPress(Widget w, XEvent *pevent, String *pparams, Cardinal *pnparams)
{
	ggui->c_keyPress(pevent);
}

/*ARGSUSED*/
void focusInMain(Widget w, XEvent *pevent, String *pparams, Cardinal *pnparams)
{
	ggui->c_focusIn(pevent);
}


/*ARGSUSED*/
void popup_no_resources(Widget w, XEvent *pevent, String *pparams,
	Cardinal *pnparams)
{
	ggui->popup_message("");
	ggui->set_exit();
}

/*ARGSUSED*/
void processResize(Widget w, XEvent *pevent, String *pparams,
	Cardinal *pnparams)
{
	ggui->c_process_resize(pevent);
}


void XtGui::initialize(struct sGuiOptions *pOptions)
{
	XAbstractGui::initialize(pOptions);
	initialize_e2window(pOptions);
	ggui = this;		// global instance pointer needed for callbacks
} // initialize



#ifdef NAFS
/*ARGSUSED*/
void XtGui::updateNafsCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->updateNafs();
}

void XtGui::updateNafs(void)
{
	if (io->fdc != NULL)
		if (!io->fdc->update_all_drives())
			popup_message("can't update file system\n\
There are open files\n");
}
#endif // ifdef NAFS

/*ARGSUSED*/
void XtGui::setCpuExitCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(EXIT);
}

/*ARGSUSED*/
void XtGui::setCpuRunCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(RUN);
}

/*ARGSUSED*/
void XtGui::setCpuStopCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(STOP);
}

/*ARGSUSED*/
void XtGui::setCpuStepCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(STEP);
}

/*ARGSUSED*/
void XtGui::setCpuNextCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(NEXT);
}

/*ARGSUSED*/
void XtGui::setCpuResetCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(RESET);
}

/*ARGSUSED*/
void XtGui::setCpuResetRunCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->set_new_state(RESET_RUN);
}

/*ARGSUSED*/
void XtGui::toggleCpuCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->toggle_cpu();
}

/*ARGSUSED*/
void XtGui::popdownCpuCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popdown_cpu();
}

/*ARGSUSED*/
void XtGui::popupHelpCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popup_help();
}

/*ARGSUSED*/
void XtGui::popdownHelpCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popdown_help();
}

/*ARGSUSED*/
void XtGui::displayManPageCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->display_man_page(w);
}

/*ARGSUSED*/
void XtGui::popupAboutCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popup_about();
}

/*ARGSUSED*/
void XtGui::popdownAboutCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popdown_about();
}

#ifdef XPM
/*ARGSUSED*/
void XtGui::popupAuthorCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL) {
		((XtGui *)client_data)->popdown_about();
		((XtGui *)client_data)->popup_author();
	}
}

/*ARGSUSED*/
void XtGui::popdownAuthorCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popdown_author();
}
#endif // iddef XPM

/*ARGSUSED*/
void XtGui::popupBp0Callback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popup_bp(0);
}

/*ARGSUSED*/
void XtGui::popupBp1Callback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popup_bp(1);
}

/*ARGSUSED*/
void XtGui::clearBpCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->clear_bp();
}

/*ARGSUSED*/
void XtGui::popdownBpCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popdown_bp();
}

/*ARGSUSED*/
void XtGui::popdownMessageCallback(Widget w,
	XtPointer client_data, XtPointer call_data)
{
	if (client_data != NULL)
		((XtGui *)client_data)->popdown_message();
}

void XtGui::c_process_resize(XEvent *pevent)
{
	guiXSize = (pevent->xconfigure.width + 10) / WINDOWWIDTH;
	guiXSize = guiXSize < 1 ? 1 : guiXSize;
	guiYSize = (pevent->xconfigure.height + 10) / WINDOWHEIGHT;
	guiYSize = guiYSize < 1 ? 1 : guiYSize;
	e2video->init_blocks_to_update();
}

#ifdef XPM
void XtGui::popup_author(void)
{
	XtPopup(authorframe, XtGrabExclusive);
}

void XtGui::a_expose(Widget w, XEvent *pevent)
{
	static int errorStatus = XpmSuccess;
	XpmAttributes xpmattr;

	if (authorpixmap == None && errorStatus == XpmSuccess) {
		xpmattr.colormap  = DefaultColormapOfScreen(XtScreen(w));
		xpmattr.valuemask = XpmColormap; 
		errorStatus = XpmCreatePixmapFromData(XtDisplay(w),
			XtWindow(w), author, &authorpixmap, NULL, &xpmattr);
		XpmFreeAttributes(&xpmattr);
		if (errorStatus != XpmSuccess)
			popup_message("\
sorry, unable to create image\n\
of author. (image need 62\n\
color entries)");
	}
	if (errorStatus == XpmSuccess)
		XCopyArea(XtDisplay(w), authorpixmap, XtWindow(w), e2gc,
			pevent->xexpose.x,     pevent->xexpose.y,
			pevent->xexpose.width, pevent->xexpose.height,
			pevent->xexpose.x,     pevent->xexpose.y);
}

void XtGui::popdown_author(void)
{
	XtPopdown(authorframe);
	if (authorpixmap != None) {
		XFreePixmap(XtDisplay(authorframe), authorpixmap);
		authorpixmap = None;
	}
}
#endif // #ifdef XPM

void XtGui::popup_about(void)
{
	XtPopup(aboutframe, XtGrabExclusive);
}

void XtGui::popdown_about(void)
{
	XtPopdown(aboutframe);
}

// return 0 on success
int XtGui::popup_help(void)
{
	if (XAbstractGui::popup_help() == -1)
		XtPopup(helpframe, XtGrabNone);
	return 0;
}

void XtGui::popdown_help(void)
{
	XtPopdown(helpframe);
}

void XtGui::popup_message(char *pmessage)
{
	if (*pmessage)
		XtVaSetValues(messagetext, XtNstring, pmessage, NULL);
	XtPopup(messageframe, XtGrabExclusive);
}

void XtGui::popdown_message(void)
{
	XtPopdown(messageframe);
	if (exit_flag)
		set_new_state(EXIT);
}


void XtGui::event_queue(void)
{
	Window	root, child;
	int	newX, newY;
	int	winX, winY;
	unsigned int newButtonMask;
	int	revert;

	// process all queued events
	while (XtAppPending(context)) {
//		XtAppNextEvent(context, &event);
//		XtDispatchEvent(&event);
		XtAppProcessEvent(context, XtIMXEvent);
	} // while

	XGetInputFocus(XtDisplay(e2toplevel), &child, &revert);
	if (child == XtWindow(e2toplevel) &&
		XQueryPointer(XtDisplay(e2screen),
		XtWindow(e2toplevel),
		&root, &child, &newX, &newY,
		&winX, &winY, &newButtonMask) == True) {
		io->deltaX = newX - oldX;
		io->deltaY = newY - oldY;
		io->buttonMask = convert_buttonmask(newButtonMask);
		oldX = newX;
		oldY = newY;
	} // if
	XAbstractGui::event_queue();
}


/* ARGSUSED */
void XtGui::c_expose(XEvent *pevent)
{

	if (pevent->xexpose.count == 0 && XtIsRealized(e2screen))
		e2video->init_blocks_to_update();
} // c_expose

void XtGui::c_keyPress(XEvent *pevent)
{
	SWord key;

	if ((key = translate_to_ascii(&pevent->xkey)) >= 0)
		io->put_ch(key);
} // keyPress

void XtGui::c_focusIn(XEvent *pevent)
{
	// set SERPAR-Flag of Monitor to parallel
	// sorry, it's very dirty but it's implemented for
	// the most convenience of the user and it's ONLY
	// enabled if the default monitor file "neumon54.hex"
	// is used
	// output_to_graphic();
} // c_focusIn


void XtGui::initialize_e2window(struct sGuiOptions *pOptions)
{
	Widget w;

	w = create_main_view(pOptions->argc, pOptions->argv,
		pOptions->synchronized);
	create_message_dialog(w);
	create_about_dialog(w);
	//create_help_view(w); // man viewer not supported any more
#ifdef XPM
	create_author_dialog(w);
#endif
	create_cpuview(w);
	create_bp_dialog(w);
	initialize_after_create(w, pOptions->inverse, pOptions->color);
	manage_widget(w);
	initialize_after_open(w, PROGRAMNAME);
	e2toplevel = w;
} // initialize_e2window

Widget XtGui::create_main_view(int argc, char *argv[], int synchronized)
{
	Widget mainview;

	// create widget tree:
#ifdef sun
	mainview = XtVaAppInitialize(&context, "Flexemu",
		opts, 0, (unsigned int *)&argc, argv,
		(const char **)fallback_resources, NULL);
#else
	mainview = XtVaAppInitialize(&context, "Flexemu",
		opts, 0, &argc, argv, fallback_resources, NULL);
#endif
	if (synchronized)
		XSynchronize(XtDisplay(mainview), True);
	XtAppAddConverter(context, XtRString, XtROrientation,
		XmuCvtStringToOrientation, NULL, 0);
	// use a Paned widget because it doesn't resize the menuBar
	form = XtVaCreateManagedWidget("form", panedWidgetClass, mainview,
		NULL);
	menubar = XtVaCreateManagedWidget("menuBar", boxWidgetClass, form,
		NULL);
	button1 = XtVaCreateManagedWidget("menuButton1", menuButtonWidgetClass,
		menubar, NULL);
	button2 = XtVaCreateManagedWidget("menuButton2", menuButtonWidgetClass,
		menubar, NULL);
	button3 = XtVaCreateManagedWidget("menuButton3", menuButtonWidgetClass,
		menubar, NULL);
	e2screen = XtVaCreateManagedWidget("screen", coreWidgetClass, form,
		XtNwidth, (XtArgVal)WINDOWWIDTH*guiXSize,
		XtNheight, (XtArgVal)WINDOWHEIGHT*guiYSize, NULL);
	menu1 = XtVaCreatePopupShell("menu1", simpleMenuWidgetClass, button1,
		NULL);
	menu2 = XtVaCreatePopupShell("menu2", simpleMenuWidgetClass, button2,
		NULL);
	menu3 = XtVaCreatePopupShell("menu3", simpleMenuWidgetClass, button3,
		NULL);
#ifdef NAFS
	entry11 = XtVaCreateManagedWidget("menuEntry11", smeBSBObjectClass,
		menu1, NULL);
	line1 = XtVaCreateManagedWidget("line1", smeLineObjectClass, menu1, NULL);
#endif
	entry12 = XtVaCreateManagedWidget("menuEntry12", smeBSBObjectClass,
		menu1, NULL);
	entry21 = XtVaCreateManagedWidget("menuEntry21", smeBSBObjectClass,
		menu2, NULL);
	entry22 = XtVaCreateManagedWidget("menuEntry22", smeBSBObjectClass,
		menu2, NULL);
	entry23 = XtVaCreateManagedWidget("menuEntry23", smeBSBObjectClass,
		menu2, NULL);
	line2 = XtVaCreateManagedWidget("line2", smeLineObjectClass,
		menu2, NULL);
	entry24 = XtVaCreateManagedWidget("menuEntry24", smeBSBObjectClass,
		menu2, NULL);
	entry31 = XtVaCreateManagedWidget("menuEntry31", smeBSBObjectClass,
		menu3, NULL);
	entry32 = XtVaCreateManagedWidget("menuEntry32", smeBSBObjectClass,
		menu3, NULL);

	// add some menu callbacks:
#ifdef NAFS
	XtAddCallback(entry11, XtNcallback, updateNafsCallback, (XtPointer)this);
#endif
	XtAddCallback(entry12, XtNcallback, setCpuExitCallback,
		(XtPointer)this);
	XtAddCallback(entry21, XtNcallback, setCpuRunCallback,
		(XtPointer)this);
	XtAddCallback(entry22, XtNcallback, setCpuStopCallback,
		(XtPointer)this);
	XtAddCallback(entry23, XtNcallback, setCpuResetRunCallback,
		(XtPointer)this);
	XtAddCallback(entry24, XtNcallback, toggleCpuCallback,
		(XtPointer)this);
	XtAddCallback(entry31, XtNcallback, popupHelpCallback,
		(XtPointer)this);
	XtAddCallback(entry32, XtNcallback, popupAboutCallback,
		(XtPointer)this);
	return mainview;
}  // create_main_view


void XtGui::create_about_dialog(Widget parent)
{
	char			*aboutstring;

	aboutstring = XtMalloc(sizeof(PROGRAM_VERSION) + 2 + sizeof(HEADER1) +
		sizeof(HEADER2));

	if (aboutstring != NULL) {
		strcpy(aboutstring, HEADER1);
       		strcat(aboutstring, "V " PROGRAM_VERSION);
       		strcat(aboutstring, HEADER2);
       	} else {
       		aboutstring = "not enough memory";
       	}

	aboutframe = XtVaCreatePopupShell("about",
		transientShellWidgetClass, parent, NULL);
	aboutform = XtVaCreateManagedWidget("aboutForm",
		formWidgetClass, aboutframe, NULL);
	abouttext = XtVaCreateManagedWidget("aboutText", asciiTextWidgetClass,
		aboutform,
		XtNstring, (XtArgVal)aboutstring,
		XtNlength, (XtArgVal)(strlen(aboutstring)+1),
		NULL);
	aboutbutton = XtVaCreateManagedWidget("aboutButton",
		commandWidgetClass, aboutform,
#ifdef XPM
		XtNhorizDistance, (XtArgVal)80, NULL);
#else
		XtNhorizDistance, (XtArgVal)100, NULL);
#endif

#ifdef XPM
	morebutton = XtVaCreateManagedWidget("moreButton",
		commandWidgetClass, aboutform, NULL);
#endif

	// define some button callbacks:
	XtAddCallback(aboutbutton, XtNcallback, popdownAboutCallback,
		(XtPointer)this);
#ifdef XPM
	XtAddCallback(morebutton, XtNcallback, popupAuthorCallback,
		(XtPointer)this);
#endif
	XtFree(aboutstring);

} // create_about_dialog

// the returned string must be released with XtFree()!!

String XtGui::get_man_page(char *pman_page_name)
{
	String	 phelpstring, ptmp;
	char	*p, ch1, ch2;
	char	*perr = "can't find man page ";
	FILE	*fp;
	char	 buffer[32];
	int	 count, error;

	error = 0;
	count = 0;
	ch1 = '\0';
	phelpstring = XtMalloc(8192);
	sprintf((char *)buffer, "man %s 2>&1", pman_page_name);
	if ((fp = popen(buffer , "r")) != NULL) {
		p = phelpstring;
		if (!feof(fp))
			ch1 = fgetc(fp);
		while (!feof(fp)) {
			ch2 = fgetc(fp);
			if (ch2 != 8 && ch1 != 8) { // 8 means ^H
				*(p++) = ch1;
				count++;
			}
			ch1 = ch2;
			if ((count & 0x1fff) == 0x1ffe) {
				if ((ptmp = XtMalloc(count + 8192)) != NULL) {
					memcpy(ptmp, phelpstring, count);
					p = ptmp + count;
					XtFree(phelpstring);
					phelpstring = ptmp;
				} else
					error = 1;
			} // if
		} // while
		// there are at least two bytes free in the stringbuffer
		if (ch1 >= ' ') 
			*(p++) = ch1;
		*p = '\0';
		if (pclose(fp) < 0)
			error = 2;
	} else
		error = 3;
	if (error || strlen(phelpstring) == 0) {
		strcpy(phelpstring, perr);
		strcat(phelpstring, pman_page_name);
	}  // if
	return phelpstring;
} // get_man_page

void XtGui::create_help_view(Widget parent)
{
	String phelpstring;
	char   buttonName[20];
	int    i;

	phelpstring = get_man_page("flexemu");
	helpframe = XtVaCreatePopupShell("help",
		transientShellWidgetClass, parent, NULL);
	helpform = XtVaCreateManagedWidget("helpForm",
		formWidgetClass, helpframe, NULL);
	helptext = XtVaCreateManagedWidget("helpText", asciiTextWidgetClass,
		helpform,
		XtNstring,	     (XtArgVal)phelpstring,
		XtNscrollVertical,   (XtArgVal)XawtextScrollWhenNeeded,
		XtNscrollHorizontal, (XtArgVal)XawtextScrollWhenNeeded,
		NULL);
	helpokbutton = XtVaCreateManagedWidget("helpButton",
		commandWidgetClass, helpform, NULL);

	for (i = 0; i < NR_OF_HELPBUTTONS; i++) {
		sprintf((char *)buttonName, "helpButton%d", i+1);
		helpbutton[i] = XtVaCreateManagedWidget(buttonName,
			commandWidgetClass, helpform, NULL);
	}
	XtFree(phelpstring);

	// define some button callbacks:
	XtAddCallback(helpokbutton,  XtNcallback, popdownHelpCallback,
		(XtPointer)this);
	for (i = 0; i < NR_OF_HELPBUTTONS; i++)
		XtAddCallback(helpbutton[i], XtNcallback,
			displayManPageCallback, (XtPointer)this);
} // create_help_view

void XtGui::display_man_page(Widget w)
{
	String plabel, phelpstring;
	char label[16];

	// the label of the button is the name of the man-page
	// so it can simply be changed by editing the resource file

	XtVaGetValues(w, XtNlabel, &plabel, NULL);
	strcpy((char *)&label, plabel);
	label[0] = tolower(label[0]); // lower first character
	phelpstring = get_man_page(label);
	XtVaSetValues(helptext, XtNstring, (XtArgVal)phelpstring, NULL);
	XtFree(phelpstring);
} // display_man_page


#ifdef XPM
void XtGui::create_author_dialog(Widget parent)
{
	authorpixmap = None;
	authorframe = XtVaCreatePopupShell("author",
		transientShellWidgetClass, parent, NULL);
	authorform = XtVaCreateManagedWidget("authorForm",
		formWidgetClass, authorframe, NULL);
	authorwidget = XtVaCreateManagedWidget("authorWidget",
		coreWidgetClass, authorform, NULL);
	authorbutton = XtVaCreateManagedWidget("authorButton",
		commandWidgetClass, authorform, NULL);

	// define some button callbacks:
	XtAddCallback(authorbutton, XtNcallback, popdownAuthorCallback,
		(XtPointer)this);
} // create_author_dialog
#endif

void XtGui::create_message_dialog(Widget parent)
{
	messageframe = XtVaCreatePopupShell("message",
		transientShellWidgetClass, parent, NULL);
	messageform = XtVaCreateManagedWidget("messageForm",
		formWidgetClass, messageframe, NULL);
	messagetext = XtVaCreateManagedWidget("messageText",
		asciiTextWidgetClass, messageform, NULL);
	messagebutton = XtVaCreateManagedWidget("messageButton",
		commandWidgetClass, messageform, NULL);

	// define some button callbacks:
	XtAddCallback(messagebutton, XtNcallback, popdownMessageCallback,
		(XtPointer)this);
} // create_message_dialog

void XtGui::initialize_after_create(Widget w, int inverse, const char *color)
{
	unsigned int		i, j;
	Display		       *display;
	Screen		       *screen;
	Visual		       *visual;
	XGCValues		gcv;
	XColor			xcolor, exact_color;
	static XtActionsRec	actions[] = {
#ifdef XPM
					{"author_expose", (XtActionProc)author_expose},
#endif
					{"focusInMain", (XtActionProc)focusInMain},
					{"expose",   (XtActionProc)expose},
					{"keyPress", (XtActionProc)keyPress},
					{"convert", (XtActionProc)keyPress},
					{"popup_no_resources",
					   (XtActionProc)popup_no_resources},
					{"resize", (XtActionProc)processResize},
				};


	oldX       = 0;
	oldY       = 0;

	display = XtDisplay(w);
	screen  = XtScreen(w);
	visual  = DefaultVisualOfScreen(screen);

	mainpixmap = XCreateBitmapFromData(XtDisplay(w),
		RootWindowOfScreen(screen),
		flexmain_bits, flexmain_width, flexmain_height);
	if (mainpixmap != None)
		XtVaSetValues(w, XtNiconPixmap, mainpixmap, NULL);
	XtAppAddActions(context, actions, XtNumber(actions));

	cpu->initialize_byte_conv_table(XImageByteOrder(display) == LSBFirst);
	initialize_word_conv_table(XImageByteOrder(display) == LSBFirst);

	if (!*color)
		color = "green";
	if (!XAllocNamedColor(display, DefaultColormapOfScreen(screen),
		color, &xcolor, &exact_color))
		xcolor.pixel = WhitePixelOfScreen(screen);
	if (!inverse) {
		gcv.foreground = xcolor.pixel;
		gcv.background = BlackPixelOfScreen(screen);
	} else {
		gcv.foreground = BlackPixelOfScreen(screen);
		gcv.background = xcolor.pixel;
	}
	e2gc = XtGetGC(e2screen, GCForeground | GCBackground, &gcv);
	XtVaSetValues(e2screen, XtNbackground, gcv.background, NULL);

	// initialize images
	for (j = 0; j < YBLOCKS; j++)
		for (i = 0; i < 2; i++) {
			image[i][j] = XCreateImage(display,
			visual, 1, XYBitmap, 0,
			(char *)(cpu->video_ram + j * YBLOCK_SIZE +
				i * VIDEORAM_SIZE * 6),
				BLOCKWIDTH, BLOCKHEIGHT, 32, 0);
		} // for
	// image used for double size:
	for (i = 0; i < MAX_GUIXSIZE; i++) {
		for (j = 0; j < MAX_GUIYSIZE; j++) {
			alt_image[i][j] = XCreateImage(display, visual, 1,
				XYBitmap, 0, (char *)copy_block,
				BLOCKWIDTH*(i+1), BLOCKHEIGHT*(j+1), 32, 0);
		} // for
	} // for

	// needed for propper expose:
	XtInstallAllAccelerators(e2screen, form);
#ifdef XPM
	XtInstallAllAccelerators(authorwidget, authorframe);
#endif
}

void XtGui::manage_widget(Widget w)
{
	XtRealizeWidget(w);
	XtMapWidget(w);
	e2video->init_blocks_to_update();	// update main view
	update_cpuview(NO_CHANGE);		// update cpu view
}  // manage widget


void XtGui::initialize_after_open(Widget w, char *title)
{
	Dimension	width, height;
	XSizeHints	*pxsh;

	okpixmap = XCreateBitmapFromData(XtDisplay(w),
		RootWindowOfScreen(XtScreen(w)), ok_bits, ok_width, ok_height);
	XtVaGetValues(w, XtNwidth, &width, XtNheight, &height, NULL);
	pxsh = XAllocSizeHints();
	if (pxsh != NULL) {
		pxsh->min_width  = WINDOWWIDTH + (width % WINDOWWIDTH);
		pxsh->max_width  = WINDOWWIDTH * MAX_GUIXSIZE +
			(width % WINDOWWIDTH);
		pxsh->min_height = WINDOWHEIGHT + (height % WINDOWHEIGHT);;
		pxsh->max_height = WINDOWHEIGHT * MAX_GUIYSIZE +
			(height % WINDOWHEIGHT);
		pxsh->width_inc  = WINDOWWIDTH;
		pxsh->height_inc = WINDOWHEIGHT;
		pxsh->flags      = PMaxSize | PMinSize | PResizeInc;
		XSetStandardProperties(XtDisplay(w), XtWindow(w),
			title, title, None, NULL, 0, pxsh);
		XFree(pxsh);
	}
}

Display *XtGui::getDisplay(void) {
	return XtDisplay(e2screen);
}

Window XtGui::getWindow(void) {
	return XtWindow(e2screen);
}

int XtGui::gui_type(void)
{
	return GUI_XTOOLKIT;
}

XtGui::XtGui(
	Mc6809* x_cpu = NULL,
	Inout*  x_io = NULL,
	E2video* x_video = NULL,
	struct sGuiOptions *pOptions = NULL) :
		XAbstractGui(x_cpu, x_io, x_video, pOptions)
{
	initialize(pOptions);
}

XtGui::~XtGui()
{
	int i, j;

	if (okpixmap != None)
		XFreePixmap(XtDisplay(e2toplevel), okpixmap);
	if (mainpixmap != None)
		XFreePixmap(XtDisplay(e2toplevel), mainpixmap);
	if (cpupixmap != None)
		XFreePixmap(XtDisplay(e2toplevel), cpupixmap);
	for (j = 0; j < YBLOCKS; j++) {
		for (i = 0; i < 2; i++) {
			image[i][j]->data = NULL;
			XDestroyImage(image[i][j]);
		} // for
	} // for
	// remove data pointer otherwise it would be freed
	for (i = 0; i < MAX_GUIXSIZE; i++) {
		for (j = 0; j < MAX_GUIYSIZE; j++) {
			alt_image[i][j]->data = NULL;
			XDestroyImage(alt_image[i][j]);
		} // for
	} // for
#ifdef XPM
	if (authorpixmap != None)
		XFreePixmap(XtDisplay(e2toplevel), authorpixmap);
#endif
	XtReleaseGC(e2screen, e2gc);
	XtDestroyApplicationContext(context);
}

#endif // #ifdef XTK

