/*
    xgui.h: user interface for Xlib


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __xgui_h__
#define __xgui_h__

#include <misc1.h>

#ifdef X11

#include "xabsgui.h"


#define BUTTON_X	30
#define BUTTON_RUN_Y	1
#define BUTTON_STOP_Y	2
#define BUTTON_STEP_Y	3
#define BUTTON_NEXT_Y	4
#define BUTTON_RESET_Y	5
#define BUTTON_EXIT_Y	6


class XGui  : public XAbstractGui {

protected:

// X11 stuff
	Screen		*screen;
	Display		*display;
	Window		 cpu_window;
	Pixmap		 pix;
	GC		 cpu_gc, inv_gc;
	XFontStruct	*fs;
	int		 ww, wh;
	int		 cw, ch;	// X11 text stuff
	char		*message;

protected:
	virtual void	create_message_dialog(Widget parent);
	virtual void	event_queue(void);
	virtual void	create_cpuview(void);
	virtual void	clear_cpuview(void);
	virtual void	text(int, int, const char *, int = 0);
	virtual Display *getDisplay(void);
	virtual Window	getWindow(void);
	virtual void	initialize_e2window(struct sGuiOptions *pOptions);
	virtual void	initialize(struct sGuiOptions *pOptions);
	virtual void	process_button_input(XEvent *pevent);
	virtual void	process_resize(XEvent *pevent);
	virtual void	process_bp_input(KeySym keysym, int which);
	virtual void	cpu_message(char **ppmessage);
	virtual void	redraw_cpuview_impl(struct s_cpu_status *pstat,
				int state);
	virtual void	popup_message(char *pmessage);
	virtual int	gui_type(void);

public:
	XGui::XGui(Mc6809*, Inout*, E2video*, struct sGuiOptions *);
	virtual XGui::~XGui();
};

#endif // X11
#endif // __xgui_h__

