/*
    xabsgui.h: abstract user interface for X11


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef __xabsgui_h__
#define __xabsgui_h__

#include <misc1.h>

#ifdef X11

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include "absgui.h"

class XAbstractGui : public AbstractGui {

protected:

	Window		 e2window;
	GC		 e2gc;
	XImage 		*image[2][YBLOCKS];
	XImage		*alt_image[MAX_GUIXSIZE][MAX_GUIYSIZE];
	int		oldX, oldY;	// old pointer position
	Byte		copy_block[BLOCKWIDTH * BLOCKHEIGHT *
				MAX_GUIXSIZE * MAX_GUIYSIZE];

protected:

	virtual void	create_message_dialog(Widget parent);
	virtual void 	update_block(int block_number);
	virtual int 	convert_buttonmask(int);
	virtual SWord	translate_to_ascii(XKeyEvent *pevent);
	virtual Display *getDisplay(void);
	virtual Window	getWindow(void);
	virtual void	initialize(struct sGuiOptions *pOptions);
	virtual int	popup_help(void);

public:

	virtual void	set_bell(int percent);

public:

	XAbstractGui(Mc6809*, Inout*, E2video*,
		struct sGuiOptions *);
	virtual ~XAbstractGui();
};

#endif // X11
#endif // __xabsgui_h__

