/*
    xabsgui.cpp: abstract user interface for X11


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <misc1.h>
#ifdef ultrix
#include <errno.h>
#endif
#include <stdlib.h>
#include <limits.h>

#ifndef WIN32
// autoconf adaption for sys/wait.h
#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif
#endif // ifndef WIN32

#include "xabsgui.h"

#ifdef X11

/* ARGSUSED */
void XAbstractGui::initialize(struct sGuiOptions *pOptions)
{
	AbstractGui::initialize(pOptions);
	bp_input[0] = 0;
	bp_input[1] = 0;
}

Display *XAbstractGui::getDisplay(void)
{
	return (Display *)NULL;
}

Window XAbstractGui::getWindow(void)
{
	return (Window)0;
}

void XAbstractGui::update_block(int block_number)
{
Display 	*dpy;
Window	 	 win;
int		 i;
XImage		*img;

if (e2video->are_blocks_to_update() || cpu->changed[block_number]) {
	dpy = getDisplay();
	win = getWindow();

	switch ((guiXSize << 4) | guiYSize) {
		int	j;
		Byte	*src, *btrg;
		Word	*trg;
	  case 0x11: // single width, single height
	  	// if standard gui Size only select the corresponding image:
		img = image[e2video->vico1][block_number];
		break;
	  	// if not standard gui Size first calculate contents of
	  	// block to display:
	  case 0x21: // double width, single heigth
		trg = (Word *)copy_block;
		src = (cpu->video_ram + block_number *
		  YBLOCK_SIZE + e2video->vico1 * VIDEORAM_SIZE * 6);
		for (i = 0; i < BLOCKHEIGHT; i++) {
			for (j = 0; j < RASTERLINE_SIZE; j++) {
				*(trg++) = word_conv_tab[*(src++)];
			}
		}
		img = alt_image[guiXSize-1][guiYSize-1];
	  	break;
	  case 0x22: // double width, double height
		trg = (Word *)copy_block;
		src = (cpu->video_ram + block_number *
		  YBLOCK_SIZE + e2video->vico1 * VIDEORAM_SIZE * 6);
		for (i = 0; i < BLOCKHEIGHT; i++) {
			for (j = 0; j < RASTERLINE_SIZE; j++) {
				*trg = *(trg+RASTERLINE_SIZE) =
					word_conv_tab[*(src++)];
				trg++;
			}
			trg += RASTERLINE_SIZE;
		}
		img = alt_image[guiXSize-1][guiYSize-1];
		break;
	  case 0x23: // double width, tripple height
		trg = (Word *)copy_block;
		src = (cpu->video_ram + block_number *
		  YBLOCK_SIZE + e2video->vico1 * VIDEORAM_SIZE * 6);
		for (i = 0; i < BLOCKHEIGHT; i++) {
			for (j = 0; j < RASTERLINE_SIZE; j++) {
				*trg = *(trg+RASTERLINE_SIZE) =
				  *(trg+2*RASTERLINE_SIZE) =
				  	word_conv_tab[*(src++)];
				trg++;
			}
			trg += 2 * RASTERLINE_SIZE;
		}
		img = alt_image[guiXSize-1][guiYSize-1];
		break;
	  case 0x12: // single width, double height
	  case 0x13: // single width, tripple height
		btrg = copy_block;
		src = (cpu->video_ram + block_number *
		  YBLOCK_SIZE + e2video->vico1 * VIDEORAM_SIZE * 6);
		for (i = 0; i < BLOCKHEIGHT; i++) {
			for (j = 0; j < guiYSize; j++) {
				memcpy(btrg, src, RASTERLINE_SIZE);
				btrg += RASTERLINE_SIZE;
			}
			src += RASTERLINE_SIZE;
		}
		img = alt_image[guiXSize-1][guiYSize-1];
	  	break;
	  default:
		img = alt_image[0][0];
	} // switch

	if (!(e2video->vico1 & 0x02)) {
		if (block_number == e2video->divided_block) {
			// first half display on the bottom of the window
			XPutImage(dpy, win, e2gc,
				img, 0, 0, 0, (WINDOWHEIGHT -
				(e2video->vico2 % BLOCKHEIGHT)) * guiYSize,
				BLOCKWIDTH * guiXSize,
				(e2video->vico2 % BLOCKHEIGHT) * guiYSize);
			// second half display on the top of window
			XPutImage(dpy, win, e2gc,
				img, 0, (e2video->vico2 % YBLOCKS) * guiYSize,
				0, 0, BLOCKWIDTH * guiXSize, (BLOCKHEIGHT -
				   (e2video->vico2 % BLOCKHEIGHT)) * guiYSize);
		} else {
			XPutImage(dpy, win, e2gc,
				img, 0, 0, 0,
				((block_number * BLOCKHEIGHT + WINDOWHEIGHT -
				   e2video->vico2) % WINDOWHEIGHT) * guiYSize,
				BLOCKWIDTH * guiXSize, BLOCKHEIGHT * guiYSize);
		} // else
		cpu->changed[block_number] = 0;
	} else {
		for (i = 0; i < YBLOCK_SIZE * guiXSize * guiYSize; i++)
			copy_block[i] = 0xff;
		// allways display an empty screen
			XPutImage(dpy, win, e2gc,
				alt_image[guiXSize-1][guiYSize-1], 0, 0, 0,
				block_number * BLOCKHEIGHT * guiXSize,
				BLOCKWIDTH * guiXSize, BLOCKHEIGHT * guiYSize);
	} // else
} // if
} // update_block


SWord XAbstractGui::translate_to_ascii(XKeyEvent *pevent)
{
	KeySym		keysym;
	char		charString[2];
	int		count;

	// first check for control character
	count = XLookupString(pevent, charString, 2, &keysym, NULL);
//	fprintf(stderr, "%X\n", keysym); only needed for debugging
	if (pevent->state & ControlMask) {
		switch(keysym) {
			case XK_a: return 0x01;
			case XK_b: return 0x02;
			case XK_c: return 0x03;
			case XK_d: return 0x04;
			case XK_e: return 0x05;
			case XK_f: return 0x06;
			case XK_g: return 0x07;
			case XK_h: return 0x08;
			case XK_i: return 0x09;
			case XK_j: return 0x0a;
			case XK_k: return 0x0b;
			case XK_l: return 0x0c;
			case XK_m: return 0x0d;
			case XK_n: return 0x0e;
			case XK_o: return 0x0f;
			case XK_p: return 0x10;
			case XK_q: return 0x11;
			case XK_r: return 0x12;
			case XK_s: return 0x13;
			case XK_t: return 0x14;
			case XK_u: return 0x15;
			case XK_v: return 0x16;
			case XK_w: return 0x17;
			case XK_x: return 0x18;
			case XK_y: return 0x19;
			case XK_z: return 0x1a;
			case XK_8:         return 0x1b;
			case XK_ssharp:    return 0x1c;
			case XK_9:         return 0x1d;
			case XK_asciicircum:return 0x1e;
			case XK_minus:     return 0x1f;
			case XK_Return:    return 0x0d;
			case XK_Escape:    return 0x1b;
			case XK_Tab:       return 0x09;
			case XK_Delete:
			case XK_BackSpace: return 0x08;
			case XK_Break:
			case XK_Pause:     if (cpu) cpu->set_nmi(); return -1;

			case XK_Home:
			case XK_KP_7:	   return 0xb7;
			case XK_Up:
			case XK_KP_8:	   return 0xb8;
			case XK_Prior:
			case XK_KP_9:	   return 0xb9;
			case XK_Left:
			case XK_KP_4:	   return 0xb4;
			case XK_Begin:
			case XK_KP_5:	   return 0xb5;
			case XK_Right: 
			case XK_KP_6:	   return 0xb6;
			case XK_KP_1:	   return 0xb1;
			case XK_Down:
			case XK_KP_2:	   return 0xb2;
			case XK_Next:
			case XK_KP_3:	   return 0xb3;
			default:           return -1;
		} // switch
	} // if
	if (pevent->state & ShiftMask) {
		switch(keysym) {
			case XK_F1:    return 0xca;
			case XK_F2:    return 0xcb;
			case XK_F3:    return 0xcc;
			case XK_F4:    return 0xcd;
			case XK_F5:    return 0xce;
			case XK_F6:    return 0xcf;
			case XK_F7:    return 0xd0;
			case XK_F8:    return 0xd1;
			case XK_F9:    return 0xd2;

			case XK_Break:
			case XK_Pause:     if (cpu) cpu->set_nmi(); return -1;
			case XK_Delete:
			case XK_BackSpace: return 0x7f;

			case XK_Home:
			case XK_KP_7:	   return 0xe7;
			case XK_Up:
			case XK_KP_8:	   return 0xe8;
			case XK_Prior:
			case XK_KP_9:	   return 0xe9;
			case XK_Left:
			case XK_KP_4:	   return 0xe4;
			case XK_Begin:
			case XK_KP_5:	   return 0xe5;
			case XK_Right: 
			case XK_KP_6:	   return 0xe6;
			case XK_KP_1:	   return 0xe1;
			case XK_Down:
			case XK_KP_2:	   return 0xe2;
			case XK_Next:
			case XK_KP_3:	   return 0xe3;
		} // switch
	} // if
	switch (keysym) {
		// main keyboard
		case XK_Return:    return 0x0d;
		case XK_Escape:    return 0x1b;
		case XK_Tab:       return 0x09;
		case XK_space:     return ' ';
		case XK_Delete:
		case XK_BackSpace: return 0x08;
		case XK_Break:
		case XK_Pause:     return 0x03;

		case XK_F1:        return 0xc0;
		case XK_F2:        return 0xc1;
		case XK_F3:        return 0xc2;
		case XK_F4:        return 0xc3;
		case XK_F5:        return 0xc4;
		case XK_F6:        return 0xc5;
		case XK_F7:        return 0xc6;
		case XK_F8:        return 0xc7;
		case XK_F9:        return 0xc8;
		case XK_F10:       return 0xc9;
		case XK_F11:       return 0xca;
		case XK_F12:       return 0xcb;
		
		case XK_Home:
		case XK_KP_7:	   return 0xf7;
		case XK_Up:
		case XK_KP_8:	   return 0xf8;
		case XK_Prior:
		case XK_KP_9:	   return 0xf9;
		case XK_Left:
		case XK_KP_4:	   return 0xf4;
		case XK_Begin:
		case XK_KP_5:	   return 0xf5;
		case XK_Right: 
		case XK_KP_6:	   return 0xf6;
		case XK_KP_1:	   return 0xf1;
		case XK_Down:
		case XK_KP_2:	   return 0xf2;
		case XK_Next:
		case XK_KP_3:	   return 0xf3;
		case XK_KP_Decimal:return ',';
		case XK_KP_Add:    return '+';
		case XK_KP_Subtract:return '-';
		case XK_KP_Enter:  return 0x0d;
	} // switch
	if (count == 1) {
		switch(charString[0]) {
			case '': return '^';
			case '': return '~';
			case '': return '[';
			case '': return '\\';
			case '': return ']';
			case '': return '{';
			case '': return '|';
			case '': return '}';
			default: return charString[0];
		} // switch
	}
	return -1;
} // translate_to_ascii

int XAbstractGui::convert_buttonmask(int newButtonMask)
{
	int mask;

	mask = 0;
       // convert to platform independant flags
	if (newButtonMask & Button1Mask)
		mask |= L_MB;
	if (newButtonMask & Button2Mask)
		mask |= M_MB;
	if (newButtonMask & Button3Mask)
		mask |= R_MB;
	if (newButtonMask & ShiftMask)
		mask |= SHIFT_KEY;
	if (newButtonMask & ControlMask)
		mask |= CONTROL_KEY;
	return mask;
}

void XAbstractGui::set_bell(int percent)
{
	XBell(getDisplay(), percent);
} // set_bell

// return: -1 = failure
int XAbstractGui::popup_help(void)
{
	pid_t child_pid;
	int status;
	int success;
	char helpfile[PATH_MAX];
	const char *args[3];

	// if no environment variable for browser return with error
	if (strlen(pOptions->www_browser) == 0)
		return -1;
	if (strlen(pOptions->doc_dir) != 0)
		strcpy(helpfile, pOptions->doc_dir);
	else
		strcpy(helpfile, "/usr/local/doc/flexemu");
	if (helpfile[strlen(helpfile)-1] != '/')
		strcat(helpfile, "/");
	strcat(helpfile, "flexemu.htm");
	args[0] = pOptions->www_browser;
	args[1] = helpfile;
	args[2] = NULL;
	if ((child_pid = fork()) == 0) {
		// try to start WWW Browser
		success = execvp(args[0], const_cast<char **>(args));
		// if it fails exit with errorcode
		exit(255);
	} else {
		sleep(1);
		success = waitpid(child_pid, &status, WNOHANG);
		if (success == -1 ||
		   (success > 0 &&
		   WIFEXITED(status) != 0 &&
		   WEXITSTATUS(status) == 255)) // check for errorcode
			return -1;
	} // else
	return 0;
} // popup_help

void XAbstractGui::create_message_dialog(Widget parent)
{
} // create_message_dialog

XAbstractGui::XAbstractGui(
	Mc6809* x_cpu = NULL,
	Inout* x_io = NULL,
	E2video* x_video = NULL,
	struct sGuiOptions *pOptions = NULL) :
		AbstractGui(x_cpu, x_io, x_video, pOptions)
{
}

XAbstractGui::~XAbstractGui()
{
}

#endif // #ifdef X11

