/*
    win32gui.h  userinterface for Windows


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifdef WIN32
#include <misc1.h>
//#include <windowsx.h>
#ifdef _MSC_VER
#include <commctrl.h>
#endif

// maybe someone has forgotten to define this:

#ifndef SelectBitmap
#define SelectBitmap(hdc, hbm)\
	   ((HBITMAP)SelectObject((hdc), (HGDIOBJ)(HBITMAP)(hbm)))
#endif
#ifndef SelectFont
#define SelectFont(hdc, hfont)\
	   ((HFONT)SelectObject((hdc),(HGDIOBJ)(HFONT)(hfont)))
#endif

#ifndef FORWARD_WM_SETFONT
#define FORWARD_WM_SETFONT(hwnd, hfont, fRedraw, fn) \
    (void)(fn)((hwnd), WM_SETFONT, (WPARAM)(HFONT)(hfont), (LPARAM)(BOOL)(fRedraw))
#endif

#ifndef SetWindowFont
#define     SetWindowFont(hwnd, hfont, fRedraw) FORWARD_WM_SETFONT((hwnd), (hfont), (fRedraw), SendMessage)
#endif

#ifndef IsLButtonDown
#define     IsLButtonDown()  (GetKeyState(VK_LBUTTON) < 0)
#endif
#ifndef IsRButtonDown
#define     IsRButtonDown()  (GetKeyState(VK_RBUTTON) < 0)
#endif
#ifndef IsMButtonDown
#define     IsMButtonDown()  (GetKeyState(VK_MBUTTON) < 0)
#endif

// casting only needed for MSVC = V5.0
#if defined (_MSC_VER)
#if (_MSC_VER == 1100) /* MSVC V5.0 */
#define CALLBACKCAST (int (CALLBACK *)(void))
#endif
#if (_MSC_VER == 1200) /* MSVC V6.0 */
#define CALLBACKCAST
#endif
#else
#define CALLBACKCAST
#endif

#include "absgui.h"

#define NR_OF_HELPBUTTONS       (9)

// IDs for menu items

#define IDM_UPDATE_FS           (101)
#define IDM_EXIT                (102)
#define IDM_RUN                 (201)
#define IDM_STOP                (202)
#define IDM_RESET               (203)
#define IDM_VIEW                (204)
#define IDM_ABOUT               (301)
#define IDM_INTRODUCTION        (302)
#define IDM_COPYRIGHT           (303)


#define CPUW                    (320)
#define CPUH                    (210)
#define CPUFRAME                (5)


// geometry for CPU-buttons:
#define BW      (40)
#define BH      (20)
#define BL      (CPUW - BW - CPUFRAME)
#define BT      CPUFRAME

#define CPU_ACCELS (8)

struct sRGBDef {
	char *colorName;
	Byte red;
	Byte green;
	Byte blue;
};

extern struct sRGBDef colors[];

class Win32Gui : public AbstractGui {
protected:
	unsigned int    which_bp;
	HINSTANCE       hInstance;
	HWND            e2screen; // handle to E2 graphic display
	HMENU           menubar;  // menu bar of Main Window
				  // bitmap info for following bitmaps
	BITMAPINFO      *bmi[MAX_GUIXSIZE][MAX_GUIYSIZE];
				  // default bitmap for graphic display
	HBITMAP         image[MAX_GUIXSIZE][MAX_GUIYSIZE];
	HDC             hMemoryDC;// device context of Main Window
	HMENU           menu1, menu2, menu3; // menu handles

	HWND            cpuform;  // CPU Window
	HWND            nextbutton, stepbutton, runbutton, stopbutton;
	HWND            bp1button, bp2button, cpubutton, resetbutton;
	HACCEL          hAccel;     // handle of Accelerator table
	HWND            hAccelHwnd; // handle of Window with accelerators 
			// memory block for calculating bitmaps for display
	Byte            copy_block[RASTERLINE_SIZE * MAX_GUIXSIZE *
				BLOCKHEIGHT * MAX_GUIYSIZE];
	int             state_to_show;

public:
	virtual void    onCommand(HWND hwnd, int cmd);
	virtual void    onPaint(HWND hwnd);
	virtual void    onChar(HWND hwnd, SWord ch, int repeat);
	virtual void    onKeyDown(HWND hwnd, SWord ch, int repeat);
	virtual void    onTimer(HWND hwnd, UINT id);
	virtual int     onSize(HWND hwnd, int sizeType,
				int width, int height);
	virtual void    onDestroy(void);
	virtual void    onClose(void);
	virtual int     onMinMaxInfo(MINMAXINFO *lpmmi);
	virtual BOOL    onCpuCommand(HWND hwnd, int cmd);
	virtual BOOL    onCpuPaint(HWND hwnd);
	virtual BOOL    onBpCommand(HWND hwnd, int cmd);
	virtual BOOL    onCpuClose(HWND hwnd);
	virtual BOOL    onBpPaint(HWND hwnd);
	virtual BOOL    onBpInit(HWND hwnd);
	virtual BOOL    onBpClose(HWND hwnd);
	virtual BOOL    onAboutInit(HWND hwnd);
	virtual BOOL    onAboutCommand(HWND hwnd, int cmd);
	virtual BOOL    onAboutClose(HWND hwnd);

protected:
	virtual BOOL    registerWindowClasses (HINSTANCE hinst, UINT ResPoolID);
	virtual HWND    create_main_view(struct sGuiOptions *pOptions);
	virtual void    set_bell(int percent);
	virtual void    update_block(int block_number);
	virtual SWord   translate_to_ascii(SWord key);
	virtual SWord   translate_to_ascii1(SWord key);
#ifdef NAFS
	virtual void    updateNafs(void);
#endif

// CPU View
	virtual void    create_cpuview(HWND parent,
				struct sGuiOptions *pOptions);
	virtual void    popup_cpu(void);
	virtual void    popdown_cpu(void);
	virtual void    toggle_cpu(void);
	virtual void    redraw_cpuview_impl(struct s_cpu_status *pstat,
					int state);
	virtual LOGFONT *getLogFontStruct(HDC hdc, int pointSize);

	virtual void            popup_copyright(HWND hwnd);
	virtual void    manage_widget(HWND w, struct sGuiOptions *pOptions);
	virtual void    initialize_after_create(HWND w,
				struct sGuiOptions *pOptions);
	virtual void    initialize_after_open(HWND w,   
				struct sGuiOptions *pOptions);
	virtual void    initialize(struct sGuiOptions *pOptions);
	virtual void    initialize_e2window(struct sGuiOptions *pOptions);
	virtual void    event_queue(void);
	virtual void    stripBlanks(char *str);

// Internal registers

protected:

	int             cpu_popped_up;
	int             poll_count;
	int             oldX, oldY;

public:
	virtual void    update_cpuview(Byte state);
	virtual void    popup_message(char *pmessage);
	virtual int     popup_help(HWND hwnd);
	virtual void    popup_about(HWND hwnd);
	virtual void    popdown_about(HWND hwnd);
	virtual void    popup_bp(unsigned int which, HWND hwnd);
	virtual void    popdown_bp(HWND hwnd);
	virtual void    clear_bp(HWND hwnd);
	virtual int     gui_type(void);

// Public constructor and destructor
public:
	Win32Gui(
		Mc6809*, Inout*, E2video*,
		struct sGuiOptions *);
	virtual ~Win32Gui();

};

#endif // WIN32
