/*
    pia2.cpp


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <misc1.h>

#ifdef X11
#include <X11/X.h>
#endif
#include "inout.h"
#include "pia2.h"
#include "mc6809.h"
#include "bjoystck.h"

Pia2::Pia2(Inout* x_io, Mc6809* x_cpu)
{
	cpu	 = x_cpu;
	io       = x_io;
#ifdef LINUX_JOYSTICK_IS_PRESENT
	joystick = new BJoystick(0);
#endif
}

Pia2::~Pia2()
{
#ifdef LINUX_JOYSTICK_IS_PRESENT
	delete joystick;
#endif
}

void Pia2::resetIo(void)
{
	Mc6821::resetIo();
	io->reset();
}

void Pia2::writeOutputB(Byte val)
{
	if (val & 0x40)
		io->set_bell(0);
}


Byte Pia2::readInputB(void)
{
	static Word modulX = 5;
	static Word modulY = 5;
	static Word countX = 0;
	static Word countY = 0;
	int temp;

	orb &= 0xc1;
	if (io->buttonMask & L_MB)
		if (io->buttonMask & SHIFT_KEY) // shift L_MB to emulate M_MB
			orb |= 0x20;
		else
			orb |= 0x02;
	if (io->buttonMask & M_MB)
		if (io->buttonMask & SHIFT_KEY)
			orb |= 0x08;
		else
			if (io->buttonMask & CONTROL_KEY)
				orb |= 0x10;
			else
				orb |= 0x20;
	if (io->buttonMask & R_MB)
		if (io->buttonMask & SHIFT_KEY) // shift R_MB to emulate M_MB
			orb |= 0x20;
		else
			orb |= 0x04;
	// joystick input will either be emulated with mouse buttons
	// or with a real joystick (only linux support at the moment):
#ifdef LINUX_JOYSTICK_IS_PRESENT
	if (joystick->IsOpened()) {
		joystick->Actualize();
		if (joystick->XAxis() < -8)
			orb |= 0x02;	// joystick to left side
		if (joystick->XAxis() > 8)
			orb |= 0x04;	// joystick to left side
		if (joystick->YAxis() < -8)
			orb |= 0x10;	// joystick up
		if (joystick->YAxis() > 8)
			orb |= 0x08;	// joystick down
		if (joystick->IsButtonSet(0))
			orb |= 0x20;	// joystick "shoot"
	}
#endif
	countX = ++countX % modulX;
	countY = ++countY % modulY;
	if (!countX) {
		temp   = io->deltaX;
		if (temp >= 5)
			temp = 4;
		else
			if (temp <= -5)
				temp = -4;
		modulX = 5 - temp;
		orb ^= 0x01;
	}
	if (!countY) {
		temp   = io->deltaY;
		if (temp > 14)
			temp = 14;
		else
			if (temp < -14)
				temp = -14;
		modulY = 15 - temp;
		orb ^= 0x80;
	}
	return orb;
} // readInputB

