/*
    optdlg.cpp


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <misc1.h>
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#ifdef __WXMSW__
#include <direct.h>
#endif

#include "optdlg.h"

BEGIN_EVENT_TABLE(GlobalOptionsDialog, wxDialog)
	EVT_BUTTON(IDC_ViewerButton,  GlobalOptionsDialog::OnSelectViewer)
	EVT_BUTTON(wxID_OK,  GlobalOptionsDialog::OnOk)
	EVT_BUTTON(wxID_CANCEL, GlobalOptionsDialog::OnCancel)
	EVT_INIT_DIALOG(GlobalOptionsDialog::OnInitDialog)
END_EVENT_TABLE()

GlobalOptionsDialog::GlobalOptionsDialog(const bool autoTextFlag /* = false */, wxString viewer /* = "" */) :
	 m_autoTextFlag(false), c_viewer(NULL)
{
	m_viewer		= viewer;
	m_autoTextFlag	= autoTextFlag;
}

GlobalOptionsDialog::~GlobalOptionsDialog()
{
}

void GlobalOptionsDialog::OnInitDialog(wxInitDialogEvent &event) {

	c_autoTextFlag  = (wxCheckBox *)wxFindWindowByName("IDC_AutoTextFlag",  this);
	c_viewer = (wxTextCtrl *)wxFindWindowByName("IDC_Viewer", this);
	if (c_viewer)  c_viewer->SetValue(m_viewer);
	if (c_autoTextFlag)  c_autoTextFlag->SetValue(m_autoTextFlag);
	wxDialog::OnInitDialog(event);
}

void GlobalOptionsDialog::OnCancel(wxCommandEvent& WXUNUSED(event) )
{
	EndModal(wxID_CANCEL);
}

void GlobalOptionsDialog::OnOk(wxCommandEvent& WXUNUSED(event) )
{
	if (c_viewer) { m_viewer = c_viewer->GetValue(); };
	if (c_autoTextFlag) { m_autoTextFlag = (bool)c_autoTextFlag->GetValue(); };
	if (m_viewer.IsEmpty()) {
		wxMessageBox("Wrong parameter", "FLEXplorer Error", wxOK | wxCENTRE | wxICON_EXCLAMATION);
	} else
		EndModal(wxID_OK);
}

void GlobalOptionsDialog::OnSelectViewer(wxCommandEvent& WXUNUSED(event) )
{
	wxString viewerPath;
#ifdef __WXMSW__
	char                    wd[PATH_MAX];

	getcwd((char *)wd, PATH_MAX);
#endif
	viewerPath = wxFileSelector(
		"Select a File Viewer to be used",
		"",
		NULL,
		"*.EXE",
		"*.*",
		wxSAVE,
		this);
#ifdef __WXMSW__
	chdir((char *)wd);
#endif
	if (!viewerPath.IsEmpty()) {
		m_viewer = viewerPath;
		if (c_viewer)
			c_viewer->SetValue(m_viewer);
	}
}

