/*
    ndircont.h


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ndircont_h__
#define __ndircont_h__

#ifdef NAFS

#include <misc1.h>

#include "flexerr.h"
#include "filecont.h"

#define ERR_SIZE	(200)


const int NATIVE_MAX_OPEN_FILES = 10;
const int MAX_TRACK				= 79;		// max. nr. of tracks - 1
const int MAX_SECTOR			= 36;		// nr of sect. per track (side 0 and 1)
const int INIT_DIR_SECTORS		= (20-4);	// initial nr. of directory sectors
const int LINK_TABLE_SIZE		= ((MAX_TRACK+1) * MAX_SECTOR);
const int INIT_NEW_FILES		= 4;		// initial nr of new files to be
											// managed at a time
const enum {
	FREE_CHAIN	= -1,
	DIRECTORY	= -2,
	SYSTEM		= -3,
	NEW_FILE1	= -4
};

struct s_new_file {
	char	filename[13];
	t_st	first;
	t_st	next;
	Word	f_record;
	FILE	*fp;
};

class FlexDirEntry;
class FlexContainerInfo;
class BString;
class FlexOpenFileInfo;

class NafsDirectoryContainer : public FileContainerIf {

public:
	NafsDirectoryContainer();
	virtual ~NafsDirectoryContainer();

private:

	BString			*dir;
	FlexException		ex;

	FlexOpenFileInfo	*pof[NATIVE_MAX_OPEN_FILES];
	s_floppy			param;

	s_link_table		*pflex_links;		// pointer to link table
	s_sys_info_sector	*pflex_sys_info;	// pointer to flex info sectors
	s_unused_sector		*pflex_unused;		// pointer to flex unused sector (2)
	s_dir_sector		*pflex_directory;	// pointer to flex directory
	s_new_file			*pnew_file;			// pointer to new file table
	Word				dir_sectors;		// nr. of dir sectors in flex_directory
	Word				new_files;			// nr. of new file entries 
	t_st				dir_extend;			// track/sector of dir. extension sect.
	int					attributes;			// container attributes

// basic interface (to be used within flexemu)
public:
	virtual int Open(const char *path);
	virtual int Create(const char *dir, const char *name, int t, int s, int fmt = TYPE_DSK_CONTAINER);
	virtual int Close(void);
	virtual int IsContainerOpened(void);
	virtual int	ReadSector(Byte *buffer, int trk, int sec);
	virtual int	WriteSector(const Byte *buffer, int trk, int sec);
	virtual int IsWriteProtected(void);
	virtual int IsTrackValid(int track);
	virtual int IsSectorValid(int track, int sector);
	virtual int GetBytesPerSector(void);
	virtual int	GetInfo(FlexContainerInfo& info);

// enhanced interface (to be used within flexdisk)
public:
	int	OpenDirectory(const char *pattern);
	int	NextDirEntry(FlexDirEntry& entry);	
	int	CloseDirectory(void);
	int	FindFile(const char *fileName, FlexDirEntry& entry);	
	int	DeleteFile(const char *fileName);
	int	RenameFile(const char *oldName, const char *newName);
	int	SetAttributes(const char *fileName, int setMask, int clearMask);
	int	GetContainerType(void);
	virtual void ReadToBuffer(const char *fileName, FlexFileBuffer &buffer);
	virtual int WriteFromBuffer(const char *fileName, const FlexFileBuffer &buffer);
	virtual int	FileCopy(const char *sourceName, const char *destName,
			FileContainerIf& destination);

private:
	void			fill_flex_directory(Byte dwp);
	void			initialize_header(Byte wp);
	void			initialize_flex_sys_info_sectors(Word number);
	void			initialize_flex_unused_sector();
	void			initialize_flex_directory();
	void			initialize_flex_link_table();
	void			initialize_new_file_table();
	void			close_new_files();
	void			mount(Word number);
	void			free_memory();
	Byte			open_files();
	SWord			next_free_dir_entry();
	char			*unix_filename(SWord dir_index);
	char			*to_unix_filename(s_dir_entry *pde);
	void			scan_unix_filename(char *pfn, char *pfilename);
	Byte			add_to_link_table(
						SWord		dir_index,
						off_t		size,
						Byte		random,
						t_st		*begin,
						t_st		*end);
	void			add_to_directory(
						char *name,
						char *ext,
						SWord dir_index,
						Byte random,
						struct stat *pstat,
						t_st *begin,
						t_st *end,
						Byte wp);
	void			modify_random_file(char *path, struct stat *pstat, t_st *pbegin);
	bool			IsFlexFilename(
						const char *filename,
						char	*name = NULL,
						char	*ext = NULL);
	Word			is_in_file_random(const char *ppath, const char *pfilename);
	void			check_for_delete(SWord dir_index, s_dir_sector *buffer);
	void			check_for_extend(SWord dir_index, s_dir_sector *buffer);
	void			check_for_rename(SWord dir_index, s_dir_sector *pb);
	Byte			check_for_new_file(SWord dir_index, s_dir_sector *pd);
	Byte			extend_directory(SWord index, s_dir_sector *pdb);
	SWord			set_file_time(
						char	*ppath,
						Byte	month,
						Byte	day,
						Byte	year);
	t_st			*link_address(void);
	Byte			last_of_free_chain(Byte tr, Byte sr);
	SWord			index_of_new_file(Byte track, Byte sector);
	Word			record_nr_of_new_file(SWord new_file_index, Word index);
	void			change_file_id(
						SWord index,
						SWord old_id,
						SWord new_id);

};  // class NafsDirectoryContainer

#endif // NAFS
#endif // __ndircont_h__

