/*
    mmu.h


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef __mmu_h__
#define __mmu_h__

#include <misc1.h>

#include "classes.h"
#include "iodevice.h"


class Mmu : public IoDevice {

// Internal registers

protected:

	Mc6809		*cpu;
	Inout		*io;


// public interface
public:

	void		resetIo(void);
	virtual Byte	readIo(Word addr);
	virtual void	writeIo(Word addr, Byte val);

// Public constructor and destructor
public:
		 Mmu(Inout *x_io, Mc6809 *x_cpu);
	virtual	~Mmu();
};

#endif // __mmu_h__

