/*
    misc1.h


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef __misc1_h__
#define __misc1_h__

#ifdef _MSC_VER
#include "confignt.h"
#else
#include "config.h"
#endif
#include "typedefs.h"
#ifdef WIN32
#include <windows.h>
#endif
#include "bstring.h"

#define PROGRAM_VERSION VERSION

extern char *gMemoryAllocationErrorString;

/* make almost compatible to type bool if not already available */
#if !defined(HAVE_BOOL) && !defined(bool)
    // NB: of course, this doesn't replace the standard type, because, for
    //     example, overloading based on bool/int parameter doesn't work and
    //     so should be avoided in portable programs
typedef unsigned int bool;
#endif // bool
		 
/* adaptions for autoconf to use with/without ANSI C headers */

#if STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

/* adaptions for autoconf for POSIX.1 compatibility */
#if HAVE_UNISTD_H
# include <sys/types.h>
#ifndef _MSC_VER
# include <unistd.h>
#endif
#endif

#ifdef _POSIX_VERSION
/* Code for POSIX.1 systems.  */
#endif

/* dirent structure: */
#ifndef WIN32
#ifdef HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif
#endif

/* utime */
#ifdef WIN32
#include <sys/utime.h>
#else
#include <utime.h>
#endif

/* adapt platform specifics: */

#ifdef WIN32
#define vsnprintf       _vsnprintf
#endif

#if !defined(WIN32) || (defined(WIN32) && !defined(_MSC_VER))
extern int stricmp(const char *string1, const char *string2);
#endif

#ifdef _MSC_VER
#define W_OK            (2) /* write permission */
#define S_ISDIR(x)      (x & S_IFDIR)
#define S_ISREG(x)      (x & S_IFREG)
#define set_new_handler _set_new_handler
#define STD_NAME_SPACE  std
#define UNUSED(param)
#else
#define STD_NAME_SPACE
#define UNUSED(param) param
#endif

#ifndef WIN32
#define CALLBACK
#endif

#ifndef PATH_MAX
#ifdef WIN32
#include <stdlib.h>
#ifdef _MSC_VER
#define PATH_MAX _MAX_PATH
#else
#define PATH_MAX MAX_PATH
#endif
#else
#include <sys/param.h>
#endif
#endif

/* PATHSEPARATORSTRING shoud be a define to do */
/* implicit concatenation by the compiler!     */
#ifdef WIN32
const char PATHSEPARATOR = '\\';
#define PATHSEPARATORSTRING  "\\"
#else
const char PATHSEPARATOR = '/';
#define PATHSEPARATORSTRING "/"
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#define BITFIELDS_LSB_FIRST

struct sOptions {
	BString   drive[4];
	BString   hex_file;
	BString   disk_dir;
	Byte      term_mode;
	short int reset_key; // must be short int because of sscanf !!!
};
					 
/* Names of Environment or Registry variables */

#ifdef WIN32
#define FLEXEMUREG       "Software\\Gnu\\Flexemu"
#define FLEXPLOREREG     "Software\\Gnu\\FLEXplorer"
#endif

#define FLEXEMURC	".flexemurc"
#define FLEXPLORERRC	".flexplorerrc"

#define FLEXDISKDIR     "DiskDirectory"
#define FLEXDISK0       "Disk0Path"
#define FLEXDISK1       "Disk1Path"
#define FLEXDISK2       "Disk2Path"
#define FLEXDISK3       "Disk3Path"
#define FLEXCOLOR       "DisplayColor"
#define FLEXINVERSE     "DisplayInverse"
#define FLEXWWWBROWSER  "WwwBrowser"
#define FLEXDOCDIR      "DocDirectory"
#define FLEXMONITOR     "MonitorPath"
#define FLEXSCREENWIDTH "ScreenWidthFactor"
#define FLEXSCREENHEIGHT "ScreenHeightFactor"

#define FLEXPLORERFILEVIEWER	"FileViewer"
#define FLEXPLORERTEXTFLAG 	"AutoTextConversion"

#define BTST0(x) (x & 0x01 ? 1 : 0)
#define BTST1(x) (x & 0x02 ? 1 : 0)
#define BTST2(x) (x & 0x04 ? 1 : 0)
#define BTST3(x) (x & 0x08 ? 1 : 0)
#define BTST4(x) (x & 0x10 ? 1 : 0)
#define BTST5(x) (x & 0x20 ? 1 : 0)
#define BTST6(x) (x & 0x40 ? 1 : 0)
#define BTST7(x) (x & 0x80 ? 1 : 0)
#define BTST8(x) (x & 0x100 ? 1 : 0)
#define BTST15(x) (x & 0x8000 ? 1 : 0)
#define BTST16(x) (x & 0x10000L ? 1 : 0)

#define BSET7(x) (x |= 0x80)
#define BSET6(x) (x |= 0x40)
#define BSET5(x) (x |= 0x20)
#define BSET4(x) (x |= 0x10)
#define BSET3(x) (x |= 0x08)
#define BSET2(x) (x |= 0x04)
#define BSET1(x) (x |= 0x02)
#define BSET0(x) (x |= 0x01)

#define BCLR7(x) (x &= 0x7f)

#define DECLARE_MENUCOMMAND(function)   void function(wxCommandEvent& event);
#define FORWARD_MENUCOMMAND_TO(cls, destination, function)      \
void cls::function(wxCommandEvent& event)                                       \
{       if (destination)        destination->function(event); }


#ifdef __cplusplus
extern int              createProcess(const char *executable,
				const char *param,
				const char *directory);
extern int              copyFile(const char *srcPath, const char *destPath);
extern void     strupper(char *pstr);
extern void     strlower(char *pstr);
extern Word     extend8(Byte x);
extern char     *binstr(Byte x);
extern char     *hexstr(Byte x);
extern char     *hexstr(Word x);
extern char     *ascchr(Byte x);
#ifdef WIN32
extern int getopt(int argc, char *argv[], char *optstr);
extern int  optind;
extern int  opterr;
extern char *optarg;
#endif
#endif /* ifdef __cplusplus */

#endif /* __misc1.h__ */
