/*
    misc1.cpp


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <misc1.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

char *gMemoryAllocationErrorString =
			"Bad memory allocation.\n"
			"Close other applications\n"
			"and try again.";

#ifdef WIN32
int createProcess(const char *executable, const char *param, const char *dir)
{
	STARTUPINFO             si;
	PROCESS_INFORMATION     pi;
	char                    *commandline;
	DWORD                   result;

	commandline = new char[strlen(executable) + strlen(param) + 2];
	strcpy(commandline, executable);
	strcat(commandline, " ");
	strcat(commandline, param);
	memset((void *)&si, 0, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	result = CreateProcess(NULL, const_cast<char *>(commandline),
			NULL, NULL, 0, 0, NULL, dir, &si, &pi);
	delete commandline;
	return result;
}
#else
int createProcess(const char *executable, const char *param, const char *dir)
{
	const char *args[3];
	pid_t child_pid;

	args[0] = executable;
	args[1] = param;
	args[2] = NULL;
	if ((child_pid = fork()) == 0) {
		chdir(dir);
		execvp(args[0], (char * const *)args);
	}
	return child_pid;
}
#endif

int copyFile(const char *srcPath, const char *destPath)
{
	FILE *sFp, *dFp;
	int c;

	sFp = fopen(srcPath, "rb");
	dFp = fopen(destPath, "wb");
	if (sFp == NULL || dFp == NULL)
		return 0;
	while ((c = fgetc(sFp)) != EOF)
		fputc(c, dFp);
	fclose(sFp);
	fclose(dFp);
	return 1;       
}

void strupper(char *pstr)
{
	while (*pstr)
		*(pstr++) = toupper(*pstr);
} // strupper


void strlower(char *pstr)
{
	while (*pstr)
		*(pstr++) = tolower(*pstr);
} // strlower

// Bit extend operations
Word extend8(Byte x)
{
	if (x & 0x80) {
		return (Word)x | 0xff00;
	} else {
		return (Word)x;
	}
}

// Base 2 and Base 16 conversion functions
char *binstr(Byte x)
{
	static char             tmp[9] = "        ";

	for (SWord i = 7; i >= 0; --i) {
		tmp[i] = (x & 1) + '0';
		x >>= 1;
	}

	return tmp;
}

static char hex_digit(Byte x)
{
	x &= 0x0f;
	if (x <= 9) {
		return '0' + x;
	} else {
		return 'a' + x - 10;
	}
}

char *hexstr(Byte x)
{
	static char             tmp[3] = "  ";

	tmp[1] = hex_digit(x);  x >>= 4;
	tmp[0] = hex_digit(x);

	return tmp;
}

char *hexstr(Word x)
{
	static char             tmp[5] = "    ";

	tmp[3] = hex_digit((Byte)x);    x >>= 4;
	tmp[2] = hex_digit((Byte)x);    x >>= 4;
	tmp[1] = hex_digit((Byte)x);    x >>= 4;
	tmp[0] = hex_digit((Byte)x);

	return tmp;
}

char *ascchr(Byte x)
{
	static char             tmp[2] = " ";

	x &= 0x7f;
	tmp[0] = ((x >= 0x20) && (x < 0x7f)) ? x : '.';

	return tmp;
}

#ifndef WIN32
int stricmp(const char *string1, const char *string2)
{
	unsigned int i;

	for (i = 0; i < strlen(string1); i++) {
		if (tolower(*(string1 + i)) < tolower(*(string2 + i)))
			return -1;
		if (tolower(*(string1 + i)) > tolower(*(string2 + i)))
			return 1;
		if (!*string1)
			return 0;
	}
	return 0;
} // stricmp
#endif

