/*
    mc6809ex.cpp

    execution of one processor instruction

    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This file is based on usim-0.91 which is
    Copyright (C) 1994 by R. B. Bellis
*/

// this file should not be compiled separately
// it will be included


/* Select instruction */
switch ((Byte)(READ_PI(pc))) {
	case 0x00: mode = direct;    neg();  cycles +=  6; break;
	case 0x03: mode = direct;    com();  cycles +=  6; break;
	case 0x04: mode = direct;    lsr();  cycles +=  6; break;
	case 0x06: mode = direct;    ror();  cycles +=  6; break;
	case 0x07: mode = direct;    asr();  cycles +=  6; break;
	case 0x08: mode = direct;    lsl();  cycles +=  6; break;
	case 0x09: mode = direct;    rol();  cycles +=  6; break;
	case 0x0a: mode = direct;    dec();  cycles +=  6; break;
	case 0x0c: mode = direct;    inc();  cycles +=  6; break;
	case 0x0d: mode = direct;    tst();  cycles +=  6; break;
	case 0x0e: mode = direct;    jmp();  cycles +=  3; break;
	case 0x0f: mode = direct;    clr();  cycles +=  6; break;

	case 0x10: switch ((Byte)(READ_PI(pc))) {
			case 0x21: lbrn(); cycles += 5; break;
			case 0x22: cycles += 5 + lbhi(); break;
			case 0x23: cycles += 5 + lbls(); break;
			case 0x24: cycles += 5 + lbcc(); break;
			case 0x25: cycles += 5 + lbcs(); break;
			case 0x26: cycles += 5 + lbne(); break;
			case 0x27: cycles += 5 + lbeq(); break;
			case 0x28: cycles += 5 + lbvc(); break;
			case 0x29: cycles += 5 + lbvs(); break;
			case 0x2a: cycles += 5 + lbpl(); break;
			case 0x2b: cycles += 5 + lbmi(); break;
			case 0x2c: cycles += 5 + lbge(); break;
			case 0x2d: cycles += 5 + lblt(); break;
			case 0x2e: cycles += 5 + lbgt(); break;
			case 0x2f: cycles += 5 + lble(); break;

			case 0x3f: mode = inherent; swi2(); cycles += 20; break;
	
		        case 0x83: mode = immediate; cmpd(); cycles += 5; break;
			case 0x8c: mode = immediate; cmpy(); cycles += 5; break;
			case 0x8e: mode = immediate; ldy();  cycles += 4; break;

			case 0x93: mode = direct;    cmpd(); cycles += 7; break;
			case 0x9c: mode = direct;    cmpy(); cycles += 7; break;
			case 0x9e: mode = direct;    ldy();  cycles += 6; break;
			case 0x9f: mode = direct;    sty();  cycles += 6; break;

			case 0xa3: cycles += 7 + cmpd_i(); break;
		        case 0xac: cycles += 7 + cmpy_i(); break;
			case 0xae: cycles += 6 + ldy_i(); break;
			case 0xaf: cycles += 6 + sty_i(); break;

			case 0xb3: mode = extended;  cmpd(); cycles += 8; break;
			case 0xbc: mode = extended;  cmpy(); cycles += 8; break;
			case 0xbe: mode = extended;  ldy();  cycles += 7; break;
			case 0xbf: mode = extended;  sty();  cycles += 7; break;

			case 0xce: mode = immediate; lds();  cycles += 4; break;
	
	        	case 0xde: mode = direct;    lds();  cycles += 6; break;
			case 0xdf: mode = direct;    sts();  cycles += 6; break;

			case 0xee: cycles += 6 + lds_i(); break;
			case 0xef: cycles += 6 + sts_i(); break;

			case 0xfe: mode = extended;  lds();  cycles += 7; break;
			case 0xff: mode = extended;  sts();  cycles += 7; break;

			default:   --pc; invalid("instruction"); break;
		}
		break;
	case 0x11: switch ((Byte)(READ_PI(pc))) {
			case 0x3f: mode = inherent; swi3(); cycles += 20; break;
			case 0x83: mode = immediate; cmpu(); cycles += 5; break;
			case 0x8c: mode = immediate; cmps(); cycles += 5; break;
			case 0x93: mode = direct;    cmpu(); cycles += 7; break;
			case 0x9c: mode = direct;    cmps(); cycles += 7; break;
			case 0xa3: cycles += 7 + cmpu_i(); break;
			case 0xac: cycles += 7 + cmps_i(); break;
			case 0xb3: mode = extended;  cmpu(); cycles += 8; break;
			case 0xbc: mode = extended;  cmps(); cycles += 8; break;
			default:   --pc; invalid("instruction"); break;
		}
		break;
	case 0x12: mode = inherent;  nop();  cycles +=  2; break;
	case 0x13: mode = inherent;  sync();  cycles +=  2; break;
	case 0x16: lbra(); cycles +=  5; break;
	case 0x17: lbsr(); cycles +=  9; break;
	case 0x19: mode = inherent;  daa();  cycles +=  2; break;
	case 0x1a: mode = immediate; orcc(); cycles +=  3; break;
	case 0x1c: mode = immediate; andcc();cycles +=  3; break;
	case 0x1d: mode = inherent;  sex();  cycles +=  2; break;
	case 0x1e: mode = inherent;  exg();  cycles +=  8; break;
	case 0x1f: mode = inherent;  tfr();  cycles +=  6; break;

	case 0x20: bra();  cycles +=  3; break;
	case 0x21: brn();  cycles +=  3; break;
	case 0x22: bhi();  cycles +=  3; break;
	case 0x23: bls();  cycles +=  3; break;
	case 0x24: bcc();  cycles +=  3; break;
	case 0x25: bcs();  cycles +=  3; break;
	case 0x26: bne();  cycles +=  3; break;
	case 0x27: beq();  cycles +=  3; break;
	case 0x28: bvc();  cycles +=  3; break;
	case 0x29: bvs();  cycles +=  3; break;
	case 0x2a: bpl();  cycles +=  3; break;
	case 0x2b: bmi();  cycles +=  3; break;
	case 0x2c: bge();  cycles +=  3; break;
	case 0x2d: blt();  cycles +=  3; break;
	case 0x2e: bgt();  cycles +=  3; break;
	case 0x2f: ble();  cycles +=  3; break;

	case 0x30: cycles +=  4 + leax(); break;
	case 0x31: cycles +=  4 + leay(); break;
	case 0x32: cycles +=  4 + leas(); break;
	case 0x33: cycles +=  4 + leau(); break;
	case 0x34: cycles +=  5 + pshs(); break;
	case 0x35: cycles +=  5 + puls(); break;
	case 0x36: mode = inherent;  cycles +=  5 + pshu(); break;
	case 0x37: mode = inherent;  cycles +=  5 + pulu(); break;
	case 0x39: mode = inherent;  rts();  cycles +=  5; break;
	case 0x3a: mode = inherent;  abx();  cycles +=  3; break;
	case 0x3b: mode = inherent;  cycles +=  rti(); break;
	case 0x3c: mode = immediate; cwai(); cycles +=  20; break;
	case 0x3d: mode = inherent;  mul();  cycles +=  11; break;
	case 0x3f: mode = inherent;  swi();  cycles +=  19; break;

	case 0x40: mode = inherent;  nega(); cycles +=  2; break;
	case 0x43: mode = inherent;  coma(); cycles +=  2; break;
	case 0x44: mode = inherent;  lsra(); cycles +=  2; break;
	case 0x46: mode = inherent;  rora(); cycles +=  2;	 break;
	case 0x47: mode = inherent;  asra(); cycles +=  2; break;
	case 0x48: mode = inherent;  lsla(); cycles +=  2; break;
	case 0x49: mode = inherent;  rola(); cycles +=  2;	 break;
	case 0x4a: mode = inherent;  deca(); cycles +=  2; break;
	case 0x4c: mode = inherent;  inca(); cycles +=  2; break;
	case 0x4d: mode = inherent;  tsta(); cycles +=  2; break;
	case 0x4f: mode = inherent;  clra(); cycles +=  2; break;

	case 0x50: mode = inherent;  negb(); cycles +=  2; break;
	case 0x53: mode = inherent;  comb(); cycles +=  2; break;
	case 0x54: mode = inherent;  lsrb(); cycles +=  2; break;
	case 0x56: mode = inherent;  rorb(); cycles +=  2; break;
	case 0x57: mode = inherent;  asrb(); cycles +=  2; break;
	case 0x58: mode = inherent;  lslb(); cycles +=  2; break;
	case 0x59: mode = inherent;  rolb(); cycles +=  2; break;
	case 0x5a: mode = inherent;  decb(); cycles +=  2; break;
	case 0x5c: mode = inherent;  incb(); cycles +=  2; break;
	case 0x5d: mode = inherent;  tstb(); cycles +=  2; break;
	case 0x5f: mode = inherent;  clrb(); cycles +=  2; break;

	case 0x60: cycles +=  6 + neg_i(); break;
	case 0x63: cycles +=  6 + com_i(); break;
	case 0x64: cycles +=  6 + lsr_i(); break;
	case 0x66: cycles +=  6 + ror_i(); break;
	case 0x67: cycles +=  6 + asr_i(); break;
	case 0x68: cycles +=  6 + lsl_i(); break;
	case 0x69: cycles +=  6 + rol_i(); break;
	case 0x6a: cycles +=  6 + dec_i(); break;
	case 0x6c: cycles +=  6 + inc_i(); break;
	case 0x6d: cycles +=  6 + tst_i(); break;
	case 0x6e: cycles +=  3 + jmp_i(); break;
	case 0x6f: cycles +=  6 + clr_i(); break;

  	case 0x70: mode = extended;  neg();  cycles +=  7; break;
 	case 0x73: mode = extended;  com();  cycles +=  7; break;
 	case 0x74: mode = extended;  lsr();  cycles +=  7; break;
 	case 0x76: mode = extended;  ror();  cycles +=  7; break;
 	case 0x77: mode = extended;  asr();  cycles +=  7; break;
 	case 0x78: mode = extended;  lsl();  cycles +=  7; break;
 	case 0x79: mode = extended;  rol();  cycles +=  3; break;
 	case 0x7a: mode = extended;  dec();  cycles +=  7; break;
 	case 0x7c: mode = extended;  inc();  cycles +=  7; break;
 	case 0x7d: mode = extended;  tst();  cycles +=  7; break;
 	case 0x7e: mode = extended;  jmp();  cycles +=  4; break;
 	case 0x7f: mode = extended;  clr();  cycles +=  7; break;

	case 0x80: mode = immediate; suba(); cycles +=  2; break;
	case 0x81: mode = immediate; cmpa(); cycles +=  2; break;
	case 0x82: mode = immediate; sbca(); cycles +=  2; break;
	case 0x83: mode = immediate; subd(); cycles +=  4; break;
	case 0x84: mode = immediate; anda(); cycles +=  2; break;
	case 0x85: mode = immediate; bita(); cycles +=  2; break;
	case 0x86: mode = immediate; lda();  cycles +=  2; break;
	case 0x88: mode = immediate; eora(); cycles +=  2; break;
	case 0x89: mode = immediate; adca(); cycles +=  2; break;
	case 0x8a: mode = immediate; ora();  cycles +=  2; break;
	case 0x8b: mode = immediate; adda(); cycles +=  2; break;
	case 0x8c: mode = immediate; cmpx(); cycles +=  4; break;
	case 0x8d: bsr();  cycles +=  7; break;
	case 0x8e: mode = immediate; ldx();  cycles +=  3; break;

	case 0x90: mode = direct;    suba(); cycles +=  4; break;
	case 0x91: mode = direct;    cmpa(); cycles +=  4; break;
	case 0x92: mode = direct;    sbca(); cycles +=  4; break;
	case 0x93: mode = direct;    subd(); cycles +=  6; break;
	case 0x94: mode = direct;    anda(); cycles +=  4; break;
	case 0x95: mode = direct;    bita(); cycles +=  4; break;
	case 0x96: mode = direct;    lda();  cycles +=  4; break;
	case 0x97: mode = direct;    sta();  cycles +=  4; break;
	case 0x98: mode = direct;    eora(); cycles +=  4; break;
	case 0x99: mode = direct;    adca(); cycles +=  4; break;
	case 0x9a: mode = direct;    ora();  cycles +=  4; break;
	case 0x9b: mode = direct;    adda(); cycles +=  4; break;
	case 0x9c: mode = direct;    cmpx(); cycles +=  6; break;
	case 0x9d: mode = direct;    jsr();  cycles +=  7; break;
	case 0x9e: mode = direct;    ldx();  cycles +=  5; break;
	case 0x9f: mode = direct;    stx();  cycles +=  5; break;

	case 0xa0: cycles +=  4 + suba_i(); break;
	case 0xa1: cycles +=  4 + cmpa_i(); break;
	case 0xa2: cycles +=  4 + sbca_i(); break;
	case 0xa3: cycles +=  6 + subd_i(); break;
	case 0xa4: cycles +=  4 + anda_i(); break;
	case 0xa5: cycles +=  4 + bita_i(); break;
	case 0xa6: cycles +=  4 + lda_i(); break;
	case 0xa7: cycles +=  4 + sta_i(); break;
	case 0xa8: cycles +=  4 + eora_i(); break;
	case 0xa9: cycles +=  4 + adca_i(); break;
	case 0xaa: cycles +=  4 + ora_i(); break;
	case 0xab: cycles +=  4 + adda_i(); break;
	case 0xac: cycles +=  6 + cmpx_i(); break;
	case 0xad: cycles +=  7 + jsr_i(); break;
	case 0xae: cycles +=  5 + ldx_i(); break;
	case 0xaf: cycles +=  5 + stx_i(); break;

	case 0xb0: mode = extended;  suba(); cycles +=  5; break;
	case 0xb1: mode = extended;  cmpa(); cycles +=  5; break;
	case 0xb2: mode = extended;  sbca(); cycles +=  5; break;
	case 0xb3: mode = extended;  subd(); cycles +=  7; break;
	case 0xb4: mode = extended;  anda(); cycles +=  5; break;
	case 0xb5: mode = extended;  bita(); cycles +=  5; break;
	case 0xb6: mode = extended;  lda();  cycles +=  5; break;
 	case 0xb7: mode = extended;  sta();  cycles +=  5; break;
	case 0xb8: mode = extended;  eora(); cycles +=  5; break;
	case 0xb9: mode = extended;  adca(); cycles +=  5; break;
	case 0xba: mode = extended;  ora();  cycles +=  5; break;
	case 0xbb: mode = extended;  adda(); cycles +=  5; break;
	case 0xbc: mode = extended;  cmpx(); cycles +=  7; break;
 	case 0xbd: mode = extended;  jsr();  cycles +=  8; break;
	case 0xbe: mode = extended;  ldx();  cycles +=  6; break;
 	case 0xbf: mode = extended;  stx();  cycles +=  6; break;

	case 0xc0: mode = immediate; subb(); cycles +=  2; break;
	case 0xc1: mode = immediate; cmpb(); cycles +=  2; break;
	case 0xc2: mode = immediate; sbcb(); cycles +=  2; break;
	case 0xc3: mode = immediate; addd(); cycles +=  4; break;
	case 0xc4: mode = immediate; andb(); cycles +=  2; break;
	case 0xc5: mode = immediate; bitb(); cycles +=  2; break;
	case 0xc6: mode = immediate; ldb();  cycles +=  2; break;
	case 0xc8: mode = immediate; eorb(); cycles +=  2; break;
	case 0xc9: mode = immediate; adcb(); cycles +=  2; break;
	case 0xca: mode = immediate; orb();  cycles +=  2; break;
	case 0xcb: mode = immediate; addb(); cycles +=  2; break;
	case 0xcc: mode = immediate; ldd();  cycles +=  3; break;
	case 0xce: mode = immediate; ldu();  cycles +=  3; break;

	case 0xd0: mode = direct;    subb(); cycles +=  4; break;
	case 0xd1: mode = direct;    cmpb(); cycles +=  4; break;
	case 0xd2: mode = direct;    sbcb(); cycles +=  4; break;
	case 0xd3: mode = direct;    addd(); cycles +=  6; break;
	case 0xd4: mode = direct;    andb(); cycles +=  4; break;
	case 0xd5: mode = direct;    bitb(); cycles +=  4; break;
	case 0xd6: mode = direct;    ldb();  cycles +=  4; break;
	case 0xd7: mode = direct;    stb();  cycles +=  4; break;
	case 0xd8: mode = direct;    eorb(); cycles +=  4; break;
	case 0xd9: mode = direct;    adcb(); cycles +=  4; break;
	case 0xda: mode = direct;    orb();  cycles +=  4; break;
	case 0xdb: mode = direct;    addb(); cycles +=  4; break;
	case 0xdc: mode = direct;    ldd();  cycles +=  5; break;
	case 0xdd: mode = direct;    std();  cycles +=  5; break;
	case 0xde: mode = direct;    ldu();  cycles +=  5; break;
	case 0xdf: mode = direct;    stu();  cycles +=  5; break;

	case 0xe0: cycles +=  4 + subb_i(); break;
	case 0xe1: cycles +=  4 + cmpb_i(); break;
	case 0xe2: cycles +=  4 + sbcb_i(); break;
	case 0xe3: cycles +=  6 + addd_i(); break;
	case 0xe4: cycles +=  4 + andb_i(); break;
	case 0xe5: cycles +=  4 + bitb_i(); break;
	case 0xe6: cycles +=  4 + ldb_i(); break;
	case 0xe7: cycles +=  4 + stb_i(); break;
	case 0xe8: cycles +=  4 + eorb_i(); break;
	case 0xe9: cycles +=  4 + adcb_i(); break;
	case 0xea: cycles +=  4 + orb_i(); break;
	case 0xeb: cycles +=  4 + addb_i(); break;
	case 0xec: cycles +=  5 + ldd_i(); break;
	case 0xed: cycles +=  5 + std_i(); break;
	case 0xee: cycles +=  5 + ldu_i(); break;
	case 0xef: cycles +=  5 + stu_i(); break;

	case 0xf0: mode = extended;  subb(); cycles +=  5; break;
	case 0xf1: mode = extended;  cmpb(); cycles +=  5; break;
	case 0xf2: mode = extended;  sbcb(); cycles +=  5; break;
	case 0xf3: mode = extended;  addd(); cycles +=  7; break;
	case 0xf4: mode = extended;  andb(); cycles +=  5; break;
	case 0xf5: mode = extended;  bitb(); cycles +=  5; break;
	case 0xf6: mode = extended;  ldb();  cycles +=  5; break;
 	case 0xf7: mode = extended;  stb();  cycles +=  5; break;
	case 0xf8: mode = extended;  eorb(); cycles +=  5; break;
	case 0xf9: mode = extended;  adcb(); cycles +=  5; break;
	case 0xfa: mode = extended;  orb();  cycles +=  5; break;
	case 0xfb: mode = extended;  addb(); cycles +=  5; break;
	case 0xfc: mode = extended;  ldd();  cycles +=  6; break;
 	case 0xfd: mode = extended;  std();  cycles +=  6; break;
	case 0xfe: mode = extended;  ldu();  cycles +=  6; break;
 	case 0xff: mode = extended;  stu();  cycles +=  6; break;

	default:   invalid("instruction");
}

