/*
    inout.h


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef __inout_h__
#define __inout_h__

#include <misc1.h>
#include <stdio.h>
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif
#include "classes.h"
#include "e2floppy.h"
#include "mc6821.h"
#include "mc146818.h"
#include "absgui.h"

#define KEY_BUFFER_SIZE (8)
#define BELL		(0x07)
#define BACK_SPACE	(0x08)


#define GUI_X11		(1)
#define GUI_XTOOLKIT	(2)
#define GUI_WINDOWS	(3)

#define L_MB		(4)
#define M_MB		(2)
#define R_MB		(1)
#define SHIFT_KEY	(8)
#define CONTROL_KEY	(16)

class Inout {

// Internal registers

private:
	Byte	  	key_buffer[KEY_BUFFER_SIZE];
	Word	  	in, out;
	Byte	  	key_buffer_ser[KEY_BUFFER_SIZE];
	Word	  	in_ser, out_ser;
	Mc6809	       *cpu;
	struct sGuiOptions *options;
#ifdef HAVE_TERMIOS_H
	struct termios	save_termios;
#endif
public:
	E2floppy *fdc;
	Mc146818 *rtc;
	Mc6821   *pia1, *pia2;
	E2video  *video;
	AbstractGui    *gui;
	
// pointer interface
public:
	int	deltaX, deltaY;
	unsigned int buttonMask;

// public interface

public:
	void	set_gui(AbstractGui *x_gui);
	void	set_fdc(E2floppy  *x_device);
	void	set_rtc(Mc146818  *x_device);
	void	set_pia1(Mc6821 *x_device);
	void	set_pia2(Mc6821 *x_device);
	void	set_video(E2video *x_video);
	AbstractGui *create_gui(int type);

	void	reset(void);
	void	init(Word reset_key);
	Byte	poll(void);
	Byte	read_ch(void);
	Byte	read_queued_ch(void);
	void	put_ch(Byte key);
	Byte	key_buffer_full(void);

	void	update_1_second(Byte);
	void	reset_serial(void);
	Byte	poll_serial(void);
	Byte	read_ch_serial(void);
	Byte	read_queued_ch_serial(void);
	void	write_ch_serial(Byte val);
	void	put_ch_serial(Byte key);
	Byte	key_buffer_full_serial(void);
	void	set_bell(Word x_percent);
	Word	is_terminal_supported(void);
	Word	output_to_terminal(void);
	Word	output_to_graphic(void);
	void	signal_reset(int sig_no);

// Public constructor and destructor
public:
		Inout(Mc6809 *x_cpu, struct sGuiOptions *poptions);
		~Inout();

};

#endif // __inout_h__

