/*
    fsetup.cpp


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer
	 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <misc1.h>
#include "fsetpdlg.h"


#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#endif

#ifdef __WXMSW__
#include <ole2.h>
#endif

#include <wx/utils.h>
#include <wx/app.h>
#include <wx/resource.h>

#include "fsetup.h"

#if defined(__WXMSW__)
static char *fsetupResource = NULL;
#else
#include "fsetup.wxr"
#endif


IMPLEMENT_APP(FlexemuSetup)

/*------------------------------------------------------
 flexemuSetup implementation (The Application class)
--------------------------------------------------------*/
bool FlexemuSetup::OnInit(void)
{
	// parse resource data
#if defined(__WXMSW__)
	fsetupResource = wxLoadUserResource("fsetupResource", "WXRDATA");
	wxResourceParseString(fsetupResource);
#else
	wxResourceParseData(flexemuOptionsDialog);
#endif

#ifdef __WXDEBUG__
	wxDebugContext::SetCheckpoint();
#endif

	optionMan.InitOptions(&guiOptions, &options, argc, argv);
	optionMan.GetOptions(&guiOptions, &options);
	optionMan.GetEnvironmentOptions(&guiOptions, &options);
	SetAppName("FlexemuSetup");
#ifdef __WXMSW__
	::OleInitialize(NULL);
	//if ( FAILED(::OleInitialize(NULL)) )
	//	;//wxLogError(_("Cannot initialize OLE"));
#endif
	dialog = new FlexemuOptionsDialog(&guiOptions, &options);
	dialog->SetModal(false);
	if (dialog->LoadFromResource((wxWindow *)NULL, "flexemuOptionsDialog")) {
		dialog->Show(true);
		SetTopWindow(dialog);
		return TRUE;
	}
	return FALSE;
}

int FlexemuSetup::OnExit(void)
{
	if (GetReturnCode() == wxID_OK)
		optionMan.WriteOptions(&guiOptions, &options);

#ifdef __WXMSW__
        ::OleUninitialize();
#endif

#ifdef __WXDEBUG__
	//wxDebugContext::PrintClasses();
	wxDebugContext::Dump();
	wxDebugContext::PrintStatistics();
#endif
	return 1;
}

