/*
    fsetpdlg.cpp


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <misc1.h>
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
//#include <wx/wxapp.h>
#endif

#ifdef __WXMSW__
#include <direct.h>
#endif

#include "fsetpdlg.h"
#include "fsetup.h"


const char *color_table[14] = {
	"white", "red", "green", "blue", "yellow", "magenta", "cyan",\
	"orange", "pink", "purple", "violet", "orange", "brown", NULL };

BEGIN_EVENT_TABLE(FlexemuOptionsDialog, wxDialog)
	EVT_BUTTON(IDC_Drive0Button,  FlexemuOptionsDialog::OnSelectDrive0)
	EVT_BUTTON(IDC_Drive1Button,  FlexemuOptionsDialog::OnSelectDrive1)
	EVT_BUTTON(IDC_Drive2Button,  FlexemuOptionsDialog::OnSelectDrive2)
	EVT_BUTTON(IDC_Drive3Button,  FlexemuOptionsDialog::OnSelectDrive3)
	EVT_BUTTON(IDC_DiskDirButton, FlexemuOptionsDialog::OnSelectDiskDir)
	EVT_BUTTON(IDC_MonitorButton, FlexemuOptionsDialog::OnSelectMonitor)
	EVT_BUTTON(wxID_OK,           FlexemuOptionsDialog::OnOK)
	EVT_BUTTON(wxID_CANCEL,       FlexemuOptionsDialog::OnCancel)
	EVT_BUTTON(wxID_APPLY,        FlexemuOptionsDialog::OnApply)
	EVT_INIT_DIALOG(FlexemuOptionsDialog::OnInitDialog)
	EVT_CLOSE(FlexemuOptionsDialog::OnCloseWindow)
END_EVENT_TABLE()

FlexemuOptionsDialog::FlexemuOptionsDialog(
                 struct sGuiOptions *pGuiOptions,
                 struct sOptions *pOptions)
{
	m_guiOptions	= pGuiOptions;
	m_options	= pOptions;
}

FlexemuOptionsDialog::~FlexemuOptionsDialog()
{
}

bool FlexemuOptionsDialog::TransferDataToWindow(void)
{
	BString geometry;
	int x, y;
	int n = 0;

	if (c_geometry) {
#ifdef __WXMSW__
	   c_geometry->SetSize(-1, -1, -1, 120, wxSIZE_USE_EXISTING);
#endif
	   for (x = 1; x <= MAX_GUIXSIZE; x++)
		for (y = 1; y <= MAX_GUIYSIZE; y++) {
			geometry.printf("%ix%i",
			   WINDOWWIDTH * x, WINDOWHEIGHT * y);
			if (c_geometry) c_geometry->Append(
			   (const char *)geometry);
			if (m_guiOptions->guiXSize == x &&
			   m_guiOptions->guiYSize == y)
					c_geometry->SetSelection(n);
			n++;
		}
	}
		
	n = 0;
	if (c_color) {
		const char **p = color_table;
#ifdef __WXMSW__
	        c_color->SetSize(-1, -1, -1, 200, wxSIZE_USE_EXISTING);
#endif
		while (*p) {
			c_color->Append(*p);
			if (!m_guiOptions->color.comparenocase(*(p++)))
				c_color->SetSelection(n);
			n++;
		}
	}
	if (c_finverse)  c_finverse->SetValue(m_guiOptions->inverse != 0);
	if (c_monitor)  c_monitor->SetValue((const char *)m_options->hex_file);
#ifdef __WXMSW__
	if (c_wwwBrowser) {
		static const wxColour light_grey("LIGHT GREY");
		c_wwwBrowser->Enable(false);
		c_wwwBrowser->SetBackgroundColour(light_grey);
	}
#endif
#ifdef __WXGTK__
	if (c_wwwBrowser)  c_wwwBrowser->SetValue(
		(const char *)m_guiOptions->www_browser);
#endif
	if (c_diskDir)  c_diskDir->SetValue((const char *)m_options->disk_dir);
	for (x=0; x<=3; x++)
		if (c_drive[x]) c_drive[x]->SetValue(
			(const char *)m_options->drive[x]);
	return true;
}
void FlexemuOptionsDialog::OnInitDialog(wxInitDialogEvent &event)
{
	c_color    = (wxComboBox *)wxFindWindowByName("IDC_Color",    this);
	c_finverse = (wxCheckBox *)wxFindWindowByName("IDC_Inverse",  this);
	c_geometry = (wxComboBox *)wxFindWindowByName("IDC_Geometry", this);
	c_monitor  = (wxTextCtrl *)wxFindWindowByName("IDC_Monitor",  this);
	c_wwwBrowser= (wxTextCtrl *)wxFindWindowByName("IDC_WwwBrowser",this);
	c_diskDir  = (wxTextCtrl *)wxFindWindowByName("IDC_DiskDir",  this);
	c_drive[0] = (wxTextCtrl *)wxFindWindowByName("IDC_Drive0",   this);
	c_drive[1] = (wxTextCtrl *)wxFindWindowByName("IDC_Drive1",   this);
	c_drive[2] = (wxTextCtrl *)wxFindWindowByName("IDC_Drive2",   this);
	c_drive[3] = (wxTextCtrl *)wxFindWindowByName("IDC_Drive3",   this);
	wxDialog::OnInitDialog(event); // must be last command
}

void FlexemuOptionsDialog::OnCloseWindow(wxCloseEvent &event)
{
	if (!event.CanVeto())
		Destroy();
	else
		wxDialog::OnCloseWindow(event);
}

void FlexemuOptionsDialog::OnCancel(wxCommandEvent& event )
{	
	wxDialog::OnCancel(event);
	wxGetApp().SetReturnCode(GetReturnCode());
	if (!IsModal())
		Close(true);
}

void FlexemuOptionsDialog::OnOK(wxCommandEvent& event )
{
	RestoreValues();
	// doing some verification of the values
	if (m_options->hex_file.empty()) {
		wxMessageBox("Monitor program must not be empty",
		   "FSetup Error", wxOK | wxCENTRE | wxICON_EXCLAMATION);
	} else {
		wxDialog::OnOK(event);
		wxGetApp().SetReturnCode(GetReturnCode());
		if (!IsModal())
			Close(true);
	}
}

void FlexemuOptionsDialog::RestoreValues(void)
{

	if (c_geometry) {
		wxString geometry;
		int x, y;

		geometry = c_geometry->GetValue();
		if (sscanf(geometry, "%dx%d", &x, &y) == 2) {
		   m_guiOptions->guiXSize = x / WINDOWWIDTH;
		   m_guiOptions->guiYSize = y / WINDOWHEIGHT;
		}
	}
	if (c_color) { m_guiOptions->color = c_color->GetValue(); };
	if (c_finverse) { m_guiOptions->inverse = c_finverse->GetValue(); };
	if (c_monitor) { m_options->hex_file = c_monitor->GetValue(); };
#ifdef __WXGTK__
	if (c_wwwBrowser) { m_guiOptions->www_browser =
		c_wwwBrowser->GetValue(); };
#endif
	if (c_diskDir) { m_options->disk_dir = c_diskDir->GetValue(); };
	for (int i=0; i<=3; i++)
		if (c_drive[i])
			m_options->drive[i] = c_drive[i]->GetValue();
}

BString FlexemuOptionsDialog::OpenFilePrompter(
	const char *defautPath,
	const char *caption,
	const char *filter)
{
	wxString drive;
	BString bdrive;

#ifdef __WXMSW__
	char                    wd[PATH_MAX];

	getcwd((char *)wd, PATH_MAX);
#endif
	drive = wxFileSelector(
		"Select a disk",
		defautPath,
		NULL,
		"*.DSK",
		"*.*",
		wxSAVE,
		this);
#ifdef __WXMSW__
	chdir((char *)wd);
#endif
	if (!drive.IsEmpty())
		bdrive = (const char *)drive;
	return bdrive;
}

void FlexemuOptionsDialog::OnSelectDriveN(int n)
{
	BString path;
	BString diskDir;

	if (n > 3)
		return;
	if (c_diskDir) { diskDir = c_diskDir->GetValue(); };
	path = OpenFilePrompter(diskDir, "Select a Disk file", "*.DSK");
	if (diskDir.length() > 0 &&
			(path.index(diskDir) == 0) &&
			(path.index(PATHSEPARATOR) >= 0)) {
		path.at(diskDir.length(), path.length()-diskDir.length(), path);
		if (path.index(PATHSEPARATOR) == 0)
			path.at(1, path.length()-1, path);
	}
	if (!path.empty())
		if (c_drive[n]) c_drive[n]->SetValue((const char *)path);
}

void FlexemuOptionsDialog::OnSelectDrive0(wxCommandEvent& WXUNUSED(event) )
{
	OnSelectDriveN(0);
}

void FlexemuOptionsDialog::OnSelectDrive1(wxCommandEvent& WXUNUSED(event) )
{
	OnSelectDriveN(1);
}

void FlexemuOptionsDialog::OnSelectDrive2(wxCommandEvent& WXUNUSED(event) )
{
	OnSelectDriveN(2);
}

void FlexemuOptionsDialog::OnSelectDrive3(wxCommandEvent& WXUNUSED(event) )
{
	OnSelectDriveN(3);
}

void FlexemuOptionsDialog::OnSelectDiskDir(wxCommandEvent& WXUNUSED(event) )
{
        wxDirDialog     *dialog;

	if (c_diskDir) { m_options->disk_dir = c_diskDir->GetValue(); };
        dialog = new wxDirDialog(this, "Select folder with DSK files",
		(const char *)m_options->disk_dir);
	if (dialog->ShowModal() == wxID_OK) {
		m_options->disk_dir = dialog->GetPath();
		if (c_diskDir)
			c_diskDir->SetValue((const char *)m_options->disk_dir);
	}
}

void FlexemuOptionsDialog::OnSelectMonitor(wxCommandEvent& WXUNUSED(event))
{
	BString path;
	BString diskDir;

	if (c_diskDir) { diskDir = c_diskDir->GetValue(); };
	path = OpenFilePrompter(diskDir, "Select a monitor program", "*.HEX");
	if (diskDir.length() > 0 &&
			(path.index(diskDir) == 0) &&
			(path.index(PATHSEPARATOR) >= 0)) {
		path.at(diskDir.length(), path.length()-diskDir.length(), path);
		if (path.index(PATHSEPARATOR) == 0)
			path.at(1, path.length()-1, path);
	}
	if (!path.empty())
		if (c_monitor) c_monitor->SetValue((const char *)path);
}

