/*
    flexdisk.cpp


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <misc1.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#endif

#ifdef __WXMSW__
#include <ole2.h>
#endif

#include <wx/utils.h>
#include <wx/app.h>
#include <wx/menu.h>
#include <wx/menuitem.h>
#include <wx/resource.h>

#include "flexdisk.h"
#include "fdpframe.h"
#include "fdcframe.h"
#include "ffilecnt.h"
#include "fdirent.h"
#include "fclipbrd.h"
#include "fcopyman.h"
#include "fdlist.h"
#include "bregistr.h"
#include "brcfile.h"
#include "benv.h"

#if defined(__WXMSW__)
static char *flexdiskResource = NULL;
#else
#include "flexdisk.wxr"
#endif


IMPLEMENT_APP(FLEXplorer)

/*------------------------------------------------------
 FLEXplorer implementation (The Application class)
--------------------------------------------------------*/
bool FLEXplorer::OnInit(void)
{
	FlexParentFrame *frame;

	// parse resource data
#if defined(__WXMSW__)
	flexdiskResource = wxLoadUserResource("flexdiskResource", "WXRDATA");
	wxResourceParseString(flexdiskResource);
#else
	containerMenuBarMsw = containerMenuBarMsw; // satisfy compiler
	wxResourceParseData(mainMenuBar);
	wxResourceParseData(containerMenuBarGtk);
	wxResourceParseData(containerMenuBarMsw);
	wxResourceParseData(containerPropertiesDialog);
	wxResourceParseData(globalOptionsDialog);
#endif

#ifdef __WXDEBUG__
	wxDebugContext::SetCheckpoint();
#endif

	ReadDefaultOptions();
	SetAppName("FLEXplorer");
#ifdef __WXMSW__
	::OleInitialize(NULL);
	//if ( FAILED(::OleInitialize(NULL)) )
	//	;//wxLogError(_("Cannot initialize OLE"));
#endif
	int width = 820;

	// Create the main frame window
	frame = new FlexParentFrame((wxFrame *) NULL, -1,
		GetAppName(), wxPoint(-1, -1), wxSize(width, 700),
		wxDEFAULT_FRAME_STYLE | wxHSCROLL | wxVSCROLL);
	frame->Show(TRUE);
	SetTopWindow(frame);
	return TRUE;
}

int FLEXplorer::OnExit(void)
{
	WriteDefaultOptions();
#ifdef __WXMSW__
    ::OleUninitialize();
#endif
	delete theFlexFileClipboard;

#ifdef __WXDEBUG__
	//wxDebugContext::PrintClasses();
	wxDebugContext::Dump();
	wxDebugContext::PrintStatistics();
#endif
	return 1;
}

void FLEXplorer::WriteDefaultOptions(void)
{
#ifdef WIN32
	BRegistry *reg;

	reg = new BRegistry(BRegistry::localMachine, FLEXPLOREREG);
	reg->SetValue("FileViewer", FlexDiskListCtrl::fileViewer);
	reg->SetValue("AutoTextConversion", FlexCopyManager::autoTextConversion ? 1 : 0);
	delete reg;
#else
        BRcFile *rcFile;
        BString rcFileName;
        BEnvironment env;

        if (!env.GetValue("HOME", rcFileName))
                rcFileName = ".";
        rcFileName += PATHSEPARATORSTRING FLEXPLORERRC;
	rcFile = new BRcFile(rcFileName);
	rcFile->Initialize(); // truncate file
	rcFile->SetValue(FLEXPLORERFILEVIEWER, FlexDiskListCtrl::fileViewer);
	rcFile->SetValue(FLEXPLORERTEXTFLAG,
		FlexCopyManager::autoTextConversion ? 1 : 0);
	delete rcFile;
#endif
}

void FLEXplorer::ReadDefaultOptions(void)
{
	int	autoTextFlag;
	BString str;
#ifdef WIN32
	BRegistry *reg;

	reg = new BRegistry(BRegistry::localMachine, FLEXPLOREREG);
	reg->GetValue(FLEXPLORERFILEVIEWER, str);
	reg->GetValue(FLEXPLORERTEXTFLAG, &autoTextFlag);
	if (str.length() == 0)
		str = "Notepad.exe";
	FlexDiskListCtrl::fileViewer = (const char *)str;
	FlexCopyManager::autoTextConversion = (autoTextFlag != 0);
	delete reg;
#else
        BRcFile *rcFile;
        BString rcFileName;
        BEnvironment env;

        if (!env.GetValue("HOME", rcFileName))
                rcFileName = ".";
        rcFileName += PATHSEPARATORSTRING FLEXPLORERRC;
        rcFile = new BRcFile(rcFileName);
        if (!rcFile->GetValue(FLEXPLORERFILEVIEWER, str) && str.length() > 0)
		FlexDiskListCtrl::fileViewer = (const char *)str;
        if (!rcFile->GetValue(FLEXPLORERTEXTFLAG, &autoTextFlag))
		FlexCopyManager::autoTextConversion = (autoTextFlag != 0);
	delete rcFile;					 
#endif
}
