/*
    ffilecnt.h


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ffilecnt_h__
#define __ffilecnt_h__

#include "misc1.h"
#include <stdio.h>
#include "filecont.h"
#include "flexerr.h"
#include "bstring.h"

class FlexContainerInfo;
class FlexDirEntry;
class FlexOpenFileInfo;
class BDate;
class FlexCopyManager;


const int MAX_OPEN_FILES = 1;


#define CHECK_NO_CONTAINER_OPEN								\
	if (fp == NULL) {										\
		ex.setString(FERR_NO_CONTAINER_OPEN);				\
		throw ex;											\
	}

#define CHECK_DIRECTORY_ALREADY_OPENED						\
	if (dirIndex >= 0) {									\
		ex.setString(FERR_DIRECTORY_ALREADY_OPENED);		\
		throw ex;											\
	}

#define CHECK_DIRECTORY_NOT_OPENED							\
	if (dirIndex < 0) {										\
		ex.setString(FERR_DIRECTORY_NOT_OPENED);			\
		throw ex;											\
	}

class FlexFileContainer : public FileContainerIf
{

protected:
	FILE		*fp;
	s_floppy	param;
	BString	*path;
	FlexException	ex;

private:

	int		attributes;
	int		dirIndex;
	int		dirSectorTrk, dirSectorSec;
	s_dir_sector	dirSector;
	BString	filePattern;

public:
	FlexFileContainer();	// public constructor
	virtual ~FlexFileContainer();		// public destructor

// basic interface (to be used within flexemu)
public:
	virtual int Open(const char *path);
	virtual int Create(const char *dir, const char *name, int t, int s, int fmt = TYPE_DSK_CONTAINER);
	virtual int Close(void);
	virtual int IsContainerOpened(void);
	virtual int	ReadSector(Byte *buffer, int trk, int sec);
	virtual int	WriteSector(const Byte *buffer, int trk, int sec);
	virtual int IsWriteProtected(void);
	virtual int IsTrackValid(int track);
	virtual int IsSectorValid(int track, int sector);
	virtual int GetBytesPerSector(void);
	virtual int	GetInfo(FlexContainerInfo& info);
	virtual int GetContainerType(void);

// enhanced interface (to be used within flexdisk)
public:
	int	OpenDirectory(const char *pattern);
	int	NextDirEntry(FlexDirEntry& entry);	
	int	CloseDirectory(void);
	int	FindFile(const char *fileName, FlexDirEntry& entry);	
	int	DeleteFile(const char *fileName);
	int	RenameFile(const char *oldName, const char *newName);
	virtual int	SetAttributes(const char *fileName, int setMask, int clearMask);
	virtual void ReadToBuffer(const char *fileName, FlexFileBuffer &buffer);
	virtual int WriteFromBuffer(const char *fileName, const FlexFileBuffer &buffer);
	virtual int	FileCopy(const char *sourceName, const char *destName,
			FileContainerIf& destination);

// internal interface
protected:
	virtual int OpenForFile(const char *path);
	virtual int ByteOffset(const int trk, const int sec);
	virtual int CreateDirEntry(FlexDirEntry& entry);
	virtual int RenameDirEntry(const char *newName);
	virtual int DeleteDirEntry(void);
	virtual int SetDateDirEntry(const BDate& date);
	virtual int SetAttributesDirEntry(int attributes);

	virtual void Initialize_for_flx_format(
					s_floppy		*pfloppy,
					s_flex_header	*pheader,
					Byte		wp);
	virtual void Initialize_for_dsk_format(
					s_floppy		*pfloppy,
					s_formats		*pformat,
					Byte		wp);
	void		Create_boot_sector(Byte sec_buf[]);
	void		Create_sector2(
					Byte	sec_buf[],
					struct	s_formats *fmt);
	void		Create_sys_info_sector(
					Byte	sec_buf[],
					char	*name,
					struct	s_formats *fmt);
	int			Write_dir_sectors(
					FILE *fp,
					struct	s_formats *fmt);
	int			Write_sectors(
					FILE *fp,
					struct	s_formats *fmt);
	void		Create_format_table(
					SWord trk,
					SWord sec,
					struct s_formats *pformat);
	void		Format_disk(
					SWord trk,
					SWord sec,
					char *disk_dir,
					char *name,
					int type);

};  // class FlexFileContainer

#endif // __ffilecnt_h__
