/*
    fdpframe.cpp


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <misc1.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#endif

// define global variable with version string because
// wx-headers delete predefined VERSION

char *_progVersion = VERSION;

#include <wx/defs.h>
#include <wx/window.h>
#include <wx/bitmap.h>
#include <wx/resource.h>
#include <wx/msgdlg.h>
#include <wx/button.h>
#include <wx/dirdlg.h>
#include <wx/filedlg.h>
#include <wx/statusbr.h>

#ifdef WIN32
#ifdef _MSC_VER
#include <direct.h>
#endif
#endif

#include "fdpframe.h"
#include "fdcframe.h"
#include "flexdisk.h"
#include "ffilecnt.h"
#include "dircont.h"
#include "fdirent.h"
#include "fcinfo.h"
#include "contpdlg.h"
#include "fclipbrd.h"
#include "fcopyman.h"
#include "optdlg.h"

#if defined(__WXGTK__) || defined(__WXMOTIF__)
//#include "bitmaps/mondrian.xpm"
#include "bitmaps/new.xpm"
#include "bitmaps/open.xpm"
#include "bitmaps/save.xpm"
#include "bitmaps/copy.xpm"
#include "bitmaps/cut.xpm"
#include "bitmaps/paste.xpm"
#include "bitmaps/print.xpm"
#include "bitmaps/help.xpm"
//#include "bitmaps/container.xpm"
#include "bitmaps/flexdisk.xpm"
#include "bitmaps/new_con.xpm"
#include "bitmaps/open_con.xpm"
#include "bitmaps/open_dir.xpm"
#endif

#define MAX_NR_OF_BITMAPS (11)

/*------------------------------------------------------
 FlexParentFrame implementation
--------------------------------------------------------*/

BEGIN_EVENT_TABLE(FlexParentFrame, wxMDIParentFrame)
    EVT_MENU(MDI_ABOUT, FlexParentFrame::OnAbout)
    EVT_MENU(MDI_NEW_CONTAINER, FlexParentFrame::OnNewContainer)
    EVT_MENU(MDI_OPEN_CONTAINER, FlexParentFrame::OnOpenContainer)
    EVT_MENU(MDI_NEW_DIRECTORY, FlexParentFrame::OnNewDirectory)
    EVT_MENU(MDI_OPEN_DIRECTORY, FlexParentFrame::OnOpenDirectory)
    EVT_MENU(MDI_OPTIONS, FlexParentFrame::OnOptions)
    EVT_MENU(MDI_QUIT, FlexParentFrame::OnQuit)
    EVT_SIZE(FlexParentFrame::OnSize)
END_EVENT_TABLE()

FlexParentFrame::FlexParentFrame(wxWindow *parent, const wxWindowID id,
	const wxString& title, const wxPoint& pos, const wxSize& size,
	const long style) : wxMDIParentFrame(parent, id, title, pos, size, style)
{
// give it an icon
#ifdef __WXMSW__
	SetIcon(wxIcon("AFLEXDISK_ICON"));
#else
	SetIcon(wxIcon( flexdisk_xpm ));
#endif

	wxMenuBar *menuBar = wxResourceCreateMenuBar("mainMenuBar");
	SetMenuBar(menuBar);

    // Accelerators
    wxAcceleratorEntry entries[4];
    entries[0].Set(wxACCEL_CTRL, (int) 'N', MDI_NEW_CONTAINER);
    entries[1].Set(wxACCEL_CTRL, (int) 'O', MDI_OPEN_CONTAINER);
    entries[2].Set(wxACCEL_CTRL, (int) 'E', MDI_QUIT);
    entries[3].Set(wxACCEL_CTRL, (int) 'A', MDI_ABOUT);
    wxAcceleratorTable accel(4, entries);
    SetAcceleratorTable(accel);

	// create a status bar
#ifdef __WXGTK__
	wxStatusBar *statusBar = CreateStatusBar();
	const int fieldWidth[2] = { 120, -1 };
	statusBar->SetFieldsCount(2, fieldWidth);
#endif
	// create a tool bar
	CreateToolBar(wxNO_BORDER|wxTB_FLAT|wxTB_HORIZONTAL);
	InitToolBar(GetToolBar());
}

FlexParentFrame::~FlexParentFrame(void)
{
}

void FlexParentFrame::OnQuit(wxCommandEvent& WXUNUSED(event) )
{
	Close(TRUE);
}

void FlexParentFrame::InitToolBar(wxToolBar* toolBar)
{
    wxBitmap* bitmaps[MAX_NR_OF_BITMAPS];

#ifdef __WXMSW__
	bitmaps[0] = new wxBitmap("icon1", wxBITMAP_TYPE_RESOURCE);
	bitmaps[1] = new wxBitmap("icon2", wxBITMAP_TYPE_RESOURCE);
	bitmaps[2] = new wxBitmap("icon3", wxBITMAP_TYPE_RESOURCE);
	bitmaps[3] = new wxBitmap("icon4", wxBITMAP_TYPE_RESOURCE);
	bitmaps[4] = new wxBitmap("icon5", wxBITMAP_TYPE_RESOURCE);
	bitmaps[5] = new wxBitmap("icon6", wxBITMAP_TYPE_RESOURCE);
	bitmaps[6] = new wxBitmap("icon7", wxBITMAP_TYPE_RESOURCE);
	bitmaps[7] = new wxBitmap("icon8", wxBITMAP_TYPE_RESOURCE);
	bitmaps[8] = new wxBitmap("new_con", wxBITMAP_TYPE_RESOURCE);
	bitmaps[9] = new wxBitmap("open_con", wxBITMAP_TYPE_RESOURCE);
	bitmaps[10] = new wxBitmap("open_dir", wxBITMAP_TYPE_RESOURCE);
#else
	bitmaps[0] = new wxBitmap( new_xpm );
	bitmaps[1] = new wxBitmap( open_xpm );
	bitmaps[2] = new wxBitmap( save_xpm );
	bitmaps[3] = new wxBitmap( copy_xpm );
	bitmaps[4] = new wxBitmap( cut_xpm );
	bitmaps[5] = new wxBitmap( paste_xpm );
	bitmaps[6] = new wxBitmap( print_xpm );
	bitmaps[7] = new wxBitmap( help_xpm );
	bitmaps[8] = new wxBitmap( new_con_xpm );
	bitmaps[9] = new wxBitmap( open_con_xpm );
	bitmaps[10] = new wxBitmap( open_dir_xpm );
#endif

#ifdef __WXMSW__
	int width = 24;
#else
	int width = 16;
#endif
	int currentX = 5;

	toolBar->AddTool( MDI_NEW_CONTAINER, *bitmaps[8], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "New File Container");
	currentX += width + 5;
	toolBar->AddTool(MDI_OPEN_CONTAINER, *bitmaps[9], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Open File Container");
	currentX += width + 5;
	toolBar->AddTool(MDI_OPEN_DIRECTORY, *bitmaps[10], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Open Directory");
	currentX += width + 5;
/*  toolBar->AddTool(2, *bitmaps[2], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Save file");
  currentX += width + 5;
  toolBar->AddSeparator();
  toolBar->AddTool(3, *bitmaps[3], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Copy");
  currentX += width + 5;
  toolBar->AddTool(4, *bitmaps[4], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Cut");
  currentX += width + 5;
  toolBar->AddTool(5, *bitmaps[5], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Paste");
  currentX += width + 5;
  toolBar->AddSeparator();
  toolBar->AddTool(6, *bitmaps[6], wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Print");
  currentX += width + 5;
  toolBar->AddSeparator();
  toolBar->AddTool(7, *bitmaps[7], wxNullBitmap, TRUE, currentX, -1, (wxObject *) NULL, "Help");
*/
	toolBar->Realize();

	for (int i = 0; i < MAX_NR_OF_BITMAPS; i++)
		delete bitmaps[i];
}

void FlexParentFrame::OnAbout(wxCommandEvent& WXUNUSED(event) )
{
	char *msgString;
	char *msgFormat =
"FLEXplorer V%s\n\
Copyright (C) W. Schwotzer  1998-2000\n\
FLEXplorer comes with ABSOLUTELY NO WARRANTY.\n\
This is free software, and you are welcome\n\
to redistribute it under certain\n\
conditions. For more information\n\
look at file COPYING.\n\n\
Wolfgang.Schwotzer@gmx.net";

	msgString = (char *)malloc(strlen(msgFormat)+strlen(_progVersion)+1);
	if (msgString) {
		sprintf(msgString, msgFormat, _progVersion);
      		(void)wxMessageBox(msgString, "About FLEXplorer");
		free(msgString);
	}
}

void FlexParentFrame::OnOpenContainer(wxCommandEvent& WXUNUSED(event) )
{
	FileContainerIf	*container;
	static wxString	containerPath;
	static wxString defaultDir;
	wxString title;
	
	containerPath = wxFileSelector(
		"Select a FLEX file container",
		defaultDir,
		"*.*",
		"DSK Container (*.dsk)|*.dsk|FLX Container (*.flx)|*.flx",
		"*.dsk",
		wxOPEN,
		this);
	if (!containerPath)
		return;
	defaultDir = containerPath.BeforeLast(PATHSEPARATOR);
	
	try {
		container = new FlexFileContainer();
		container->Open(containerPath);
	} catch (FlexException &e) {
		wxMessageBox(e.what(), "FLEXplorer Error", wxOK | wxCENTRE | wxICON_EXCLAMATION);
		return;
	}
#ifdef __WXMSW__
	title = containerPath;
#endif
#ifdef __WXGTK__
	title = containerPath.AfterLast(PATHSEPARATOR);
#endif
	if (container->IsWriteProtected())
		title += " [read-only]";
	OpenChild(title, container);
}

void FlexParentFrame::OnNewContainer(wxCommandEvent& WXUNUSED(event) )
{
	FileContainerIf	*container;
	wxString	containerPath, directory, containerName;
	int		tracks, sectors, format;
	wxString title;

	containerPath = "";
	if (GetContainerProperties(&tracks, &sectors, &format, containerPath)) {
		directory = containerPath.BeforeLast(PATHSEPARATOR);
		containerName = containerPath.AfterLast(PATHSEPARATOR);
		try {
			container = new FlexFileContainer();
			container->Create(directory, containerName, tracks, sectors, format);
		} catch (FlexException &e) {
			wxMessageBox(e.what(), "FLEXplorer Error", wxOK | wxCENTRE | wxICON_EXCLAMATION);
			return;
		}
#ifdef __WXMSW__
		title = containerPath;
#endif
#ifdef __WXGTK__
		title = containerPath.AfterLast(PATHSEPARATOR);
#endif
		OpenChild(title, container);
	}
}

void FlexParentFrame::OnOpenDirectory(wxCommandEvent& WXUNUSED(event) )
{
	FileContainerIf	*container;
	static wxString	containerPath;
	wxString	title;
	wxDirDialog	*dialog;

	dialog = new wxDirDialog(this, "Open a FLEX directory container",
			containerPath);
	if (dialog->ShowModal() == wxID_OK) {
		containerPath = dialog->GetPath();
#ifdef __WXMSW__
		title = containerPath;
#endif
#ifdef __WXGTK__
		title = containerPath.AfterLast(PATHSEPARATOR);
#endif
		container = new DirectoryContainer();
		container->Open(containerPath);
		if (container->IsWriteProtected())
			title += " [read-only]";
		OpenChild(title, container);
	}
	delete dialog;
}

bool FlexParentFrame::GetContainerProperties(int *tracks, int *sectors, int *format, wxString &path)
{
	ContainerPropertiesDialog *dialog;
	
	dialog = new ContainerPropertiesDialog(80, 40, path);
	if (dialog->LoadFromResource(this, "containerPropertiesDialog")) {
		if (dialog->ShowModal() == wxID_OK) {
			*tracks = dialog->GetTracks();
			*sectors = dialog->GetSectors();
			path = dialog->GetPath();
			switch(dialog->GetFormat()) {
				case 0:  *format = TYPE_DSK_CONTAINER; break;
				case 1:  *format = TYPE_FLX_CONTAINER; break;
				default: *format = TYPE_DSK_CONTAINER; break;
			}
			delete dialog;
			return true;
		}
	}
	delete dialog;
	return false;
}

void FlexParentFrame::OnNewDirectory(wxCommandEvent& WXUNUSED(event) )
{
	FileContainerIf	*container;
	wxString		containerPath, directory, containerName;
	wxDirDialog		*dialog;

	dialog = new wxDirDialog(this,
		"Create a new FLEX directory container",
		"");
	if (dialog->ShowModal() == wxID_OK) {
		containerPath = dialog->GetPath();
		directory = containerPath.BeforeLast(PATHSEPARATOR);
		containerName = containerPath.AfterLast(PATHSEPARATOR);
		container = new DirectoryContainer();
		container->Create(directory, containerName, 80, 40);
		OpenChild(containerPath, container);
	}
	delete dialog;
}

void FlexParentFrame::OpenChild(const char *title, FileContainerIf *container)
{
	// create a child frame: the container view
	FlexChildFrame *childFrame = new FlexChildFrame(
							this, title,
							wxPoint(-1, -1),
							wxSize(520, 500),
							wxDEFAULT_FRAME_STYLE,
							container);
	childFrame->Attach(theFlexFileClipboard);
#ifdef __WXGTK__
	// statusbar support with GTK
	childFrame->GetListControl()->Attach(this);
#endif
	childFrame->Show(TRUE);
}

void FlexParentFrame::OnSize(wxSizeEvent& WXUNUSED(event) )
{
    int w, h;
    GetClientSize(&w, &h);
    GetClientWindow()->SetSize(0, 0, w, h);
}

void FlexParentFrame::Update(const void *pId)
{
	int id = *(int *)pId;
	const FlexDiskListCtrl	*listCtrl;
	wxStatusBar				*sBar;
	if (!GetActiveChild())
		return;
	listCtrl = ((FlexChildFrame *)GetActiveChild())->GetListControl();
	if (listCtrl && id == OBSERVE_STATUS_BAR && (sBar = GetStatusBar())) {
		char buf[50];

		sprintf(buf, "%d File(s) selected", listCtrl->GetFileCount());
		sBar->SetStatusText(buf, 0);
		sprintf(buf, "%d Byte", listCtrl->GetTotalSize());
		sBar->SetStatusText(buf, 1);
	}
}

void FlexParentFrame::OnOptions(wxCommandEvent& WXUNUSED(event) )
{
	wxString viewer;
	bool autoTextFlag;

	viewer = FlexDiskListCtrl::fileViewer;
	autoTextFlag = FlexCopyManager::autoTextConversion;
	if (GetGlobalOptions(&autoTextFlag, viewer)) {
		FlexCopyManager::autoTextConversion = autoTextFlag;
		FlexDiskListCtrl::fileViewer = viewer;
	}
}

bool FlexParentFrame::GetGlobalOptions(bool *autoTextFlag, wxString &viewer)
{
	GlobalOptionsDialog *dialog;
	
	dialog = new GlobalOptionsDialog(*autoTextFlag, viewer);
	if (dialog->LoadFromResource(this, "globalOptionsDialog")) {
		if (dialog->ShowModal() == wxID_OK) {
			*autoTextFlag = dialog->GetAutoTextFlag();
			viewer = dialog->GetViewer();
			delete dialog;
			return true;
		}
	}
	delete dialog;
	return false;
}
