/*
    fdlist.h


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998, 1999  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __fdlist_h__
#define __fdlist_h__

#include <wx/textctrl.h>
#include <wx/listctrl.h>

#include "misc1.h"
#include "flexdisk.h"
#include "fddnd.h"
#include "flexerr.h"

#define LIST_CTRL	1000
#define OBSERVE_STATUS_BAR		(545)

class BObserver;
class FileContainerIf;
class FlexDirEntry;

/*------------------------------------------------------
 FlexDiskListCtrl
 A specialized ListCtrl used to display a FLEX Container
--------------------------------------------------------*/
class FlexFileList;

class FlexDiskListCtrl : public wxListCtrl
{
public:
	FlexDiskListCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos,
		const wxSize& size, long style,
		FileContainerIf *container,
		const wxValidator& validator = wxDefaultValidator,
		const wxString& name = "flexDiskListCtrl");
    virtual ~FlexDiskListCtrl(void);

	const wxMenu *GetMenu(void);
	inline void  Attach(BObserver *anObserver) const { m_statusbarObserver = anObserver; };
	inline void  Detach(BObserver *anObserver) const { if (m_statusbarObserver == anObserver) m_statusbarObserver = NULL; };
	inline int GetTotalSize(void) const { return m_totalSize; };
	inline int GetFileCount(void) const { return GetSelectedItemCount(); };
	inline FileContainerIf *GetContainer(void) const { return m_container; };
	int UpdateItems(void);
	void UpdateItem(int item, FlexDirEntry &de);
	DECLARE_MENUCOMMAND(OnCopy)
	DECLARE_MENUCOMMAND(OnPaste)
	DECLARE_MENUCOMMAND(OnDelete)
	DECLARE_MENUCOMMAND(OnRename)
	DECLARE_MENUCOMMAND(OnView)
	DECLARE_MENUCOMMAND(OnSetWriteProtect)
	DECLARE_MENUCOMMAND(OnClearWriteProtect)
	DECLARE_MENUCOMMAND(OnSetReadProtect)
	DECLARE_MENUCOMMAND(OnClearReadProtect)
	DECLARE_MENUCOMMAND(OnSetDeleteProtect)
	DECLARE_MENUCOMMAND(OnClearDeleteProtect)
	DECLARE_MENUCOMMAND(OnSetCatalogProtect)
	DECLARE_MENUCOMMAND(OnClearCatalogProtect)
	DECLARE_MENUCOMMAND(OnViewProperties)
#ifdef __WXGTK__
	DECLARE_MENUCOMMAND(OnSortFilename)
	DECLARE_MENUCOMMAND(OnSortRandom)
	DECLARE_MENUCOMMAND(OnSortFilesize)
	DECLARE_MENUCOMMAND(OnSortFiledate)
	DECLARE_MENUCOMMAND(OnSortFileattr)
	DECLARE_MENUCOMMAND(OnSortFiledesc)
#endif
	static wxString fileViewer;

private:
	FlexException ex;

	void Notify();
	int GetSelections(int **pItems) const;
	void DeleteSelectedItems(bool askUser = TRUE);
	void RenameSelectedItems(void);
	void ViewSelectedItems(void);
	void SetPropertyOnSelectedItems(int protection, bool isToBeSet);
	void GetFileList(FlexFileList &fileList);
	void CopyToClipboard(void);
	bool PasteFromClipboard(void);
/*
	void OnGetInfo(wxListEvent& event);
	void OnSetInfo(wxListEvent& event);
*/
	void OnBeginDrag(wxListEvent& event);
	void OnRightMouseDown(wxMouseEvent& event);
	void OnLeftMouseDClick(wxMouseEvent& event);
	void OnListKeyDown(wxListEvent& event);
	void OnColClick(wxListEvent& event);
	void OnSelected(wxListEvent& event);
	void OnDeselected(wxListEvent& event);
	void OnActivated(wxListEvent& event);
	void OnInsertItem(wxListEvent& event);
	void OnDeleteItem(wxListEvent& event);
	void OnDeleteAllItems(wxListEvent& event);

	FileContainerIf	*m_container;
	wxMenu		*m_popupMenu;
	int		m_totalSize;
	mutable BObserver *m_statusbarObserver;

	DECLARE_EVENT_TABLE()
};

#define IMPLEMENT_MODIFY_PROPERTY(methodName, property, boolValue)	\
void FlexDiskListCtrl::methodName(wxCommandEvent& WXUNUSED(event))	\
{									\
	SetPropertyOnSelectedItems(property, boolValue);		\
}

#define IMPLEMENT_SIMPLE_MENUCOMMAND(eventMethod, implMethod)		\
void FlexDiskListCtrl::eventMethod(wxCommandEvent& WXUNUSED(event))	\
{									\
	implMethod();							\
}

#define IMPLEMENT_SORT_MENUCOMMAND(eventMethod, id)			\
void FlexDiskListCtrl::eventMethod(wxCommandEvent& WXUNUSED(event))	\
{									\
	SortItems(compareFlexListItems, id);				\
}
#endif

