/*
    fddnd.h


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __fddnd_h__
#define __fddnd_h__

#include <wx/defs.h>
#include <wx/dataobj.h>
#include <wx/dnd.h>

class FileContainerIf;
class FlexDiskListCtrl;

#if !wxUSE_DRAG_AND_DROP
    #error This application requires drag and drop support in the wx library
#endif

/*------------------------------------------------------
 FlexDnDFile
 a class containing raw data used to
 Drag & Drop FLEX files.
 It can instanciate any of it's subclasses
--------------------------------------------------------*/
enum
{
    FLEX_DND_FILENAME_LENGTH = 13
};

typedef char FlexFileName[FLEX_DND_FILENAME_LENGTH];

class FlexDnDFiles {
public:
	FlexDnDFiles(FileContainerIf *aSourceContainer, int fileCount);
	virtual ~FlexDnDFiles(void) { delete [] fileNames; };
    virtual size_t GetDataSize() const {
		return sizeof(FlexDnDFiles) + (count * FLEX_DND_FILENAME_LENGTH); };
	static FlexDnDFiles *New(const void *buf);	// restore from buffer
    virtual void GetDataHere(void *buf) const;
	int GetFileNameCount(void) const { return count; };
	const FlexFileName *GetFileName(int index) const;
	void SetFileName(int index, const FlexFileName *fileName);
	FileContainerIf *GetSrcContainer(void) const { return pSourceContainer; };
private:
	void CopyFileNamesFrom(const FlexDnDFiles& dndFiles);
	FileContainerIf	*pSourceContainer;	// pointer to Source Container
	int		count;						// number of filenames
	FlexFileName	*fileNames;			// pointer to the filenames
};

/*------------------------------------------------------
 FlexFileDataObject
 a data class used to drag and drop FLEX files
--------------------------------------------------------*/
extern const char *FlexFileFormatId;

class FlexFileDataObject : public wxDataObject
{
private:
	FlexDnDFiles *m_pData;
	wxDataFormat aFormat;
public:

  // ctor
	FlexFileDataObject(FlexDnDFiles *pData = NULL);
	virtual ~FlexFileDataObject() { delete m_pData; };

	virtual wxDataFormat GetPreferredFormat(Direction WXUNUSED(dir)) const
		{ return (wxDataFormat) aFormat; };
	virtual size_t GetFormatCount(Direction dir) const
		{ return 1; };
	virtual wxDataFormat GetFormat(void) const
		{ return (wxDataFormat) aFormat; };
    virtual void GetAllFormats(wxDataFormat *formats, Direction dir) const;
	virtual size_t GetDataSize(const wxDataFormat& format) const;
	virtual bool GetDataHere(const wxDataFormat& format, void *pBuf) const;
    virtual bool SetData(const wxDataFormat& format,
                         size_t len, const void *buf);
    const FlexDnDFiles *GetFlexDnDFiles(void);
};



/*------------------------------------------------------
 FlexFileDropTarget
 a class needed for Drag & Drop function
 used to drop FLEX files
--------------------------------------------------------*/
class FlexFileDropTarget : public wxDropTarget
{
private:
	FlexDiskListCtrl *m_ctrl;
//#ifdef __WXGTK__
	wxDataFormat aFormat;
//#endif

public:
	FlexFileDropTarget(FlexDiskListCtrl *aCtrl = NULL) :
		wxDropTarget(new FlexFileDataObject), m_ctrl(aCtrl) { };
	//void SetControl(FlexDiskListCtrl *aCtrl) { m_ctrl = aCtrl; };
	//wxDataFormat GetSupportedFormat(IDataObject *pIDataSource) const;

	//virtual void OnEnter();
	//virtual void OnLeave();
	virtual wxDragResult OnData(wxCoord x, wxCoord y, wxDragResult def);

protected:
	virtual size_t GetFormatCount() const { return 1; };
};

#endif

