/*
    fddnd.cpp


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//#include "wx/wxprec.h"
#include <misc1.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#endif

#include <wx/defs.h>
#include <wx/window.h>
#include <wx/dnd.h>
#include <wx/msgdlg.h>

#include "fddnd.h"
#include "ffilecnt.h"
#include "fdirent.h"
#include "fcinfo.h"
#include "fdlist.h"

const char *FlexFileFormatId = "FlexFileDataFormat";

FlexDnDFiles::FlexDnDFiles(FileContainerIf *aSourceContainer, int fileCount) :
	pSourceContainer(aSourceContainer), count(fileCount)
{
	fileNames = new FlexFileName[count];
};

void FlexDnDFiles::CopyFileNamesFrom(const FlexDnDFiles& dndFiles)
{
	for (int i = 0; i < dndFiles.GetFileNameCount(); i++)
		SetFileName(i, dndFiles.GetFileName(i));
}
FlexDnDFiles *FlexDnDFiles::New(const void *buf)
{
	FlexDnDFiles *pNew;

    const FlexDnDFiles& dndFiles = *(const FlexDnDFiles *)buf;
	// here different data types could be instanciated
	// with a switch/case depending on a data type tag
    pNew = new FlexDnDFiles(dndFiles.pSourceContainer, dndFiles.GetFileNameCount());
	// copy all filenames
	pNew->CopyFileNamesFrom(dndFiles);
	return pNew;
}

// the buffer must be allocated to contain an instance of FlexDnDFiles
// and additionally an array of FlexFileName types
void FlexDnDFiles::GetDataHere(void *buf) const
{
    FlexDnDFiles& dndFiles = *(FlexDnDFiles *)buf;
	dndFiles.fileNames = (FlexFileName *)((char *)buf + sizeof(FlexDnDFiles));
	dndFiles.count = count;
	dndFiles.pSourceContainer = pSourceContainer;
	dndFiles.CopyFileNamesFrom(*this);
}

const FlexFileName *FlexDnDFiles::GetFileName(int index) const
{
	if (index >= count)
		return (const FlexFileName *)"";
	return &fileNames[index];
}

void FlexDnDFiles::SetFileName(int index, const FlexFileName *fileName)
{
	if (index >= count)
		return;
	strcpy((char *)fileNames[index], (char *)fileName);
}

const FlexDnDFiles *FlexFileDataObject::GetFlexDnDFiles() {
	return m_pData;
}


FlexFileDataObject::FlexFileDataObject(FlexDnDFiles *pData)
{
	if (pData) {
		// we need to copy the FlexDnDFile object because the one
		// we're handled may be deleted while it's still on the
		// clipboard
		void *buf = malloc(pData->FlexDnDFiles::GetDataSize());
		pData->GetDataHere(buf);
		m_pData = FlexDnDFiles::New(buf);
		free(buf);
	} else
		m_pData = NULL;
	aFormat.SetId(FlexFileFormatId);
}


void FlexFileDataObject::GetAllFormats(
			wxDataFormat *formats, Direction dir) const
{
        formats[0] = aFormat;
}

bool FlexFileDataObject::SetData(const wxDataFormat& format,
                         size_t len, const void *buf)
{
        wxCHECK_MSG( format == aFormat, FALSE, "unsupported format" );
		if (format != aFormat) return false;
		if (m_pData)
			delete m_pData;
		m_pData = FlexDnDFiles::New(buf);
        return true;
}

bool FlexFileDataObject::GetDataHere(const wxDataFormat& format, void *pBuf) const
{
	if (format == aFormat) {
		memcpy(pBuf, m_pData, GetDataSize(aFormat));
		return true;
	} else
		return false;
}

size_t FlexFileDataObject::GetDataSize(const wxDataFormat& format) const
{
	if (m_pData)
		return m_pData->GetDataSize();
	else
		return 0;
}


/*
void FlexFileDropTarget::OnEnter()
{
}

void FlexFileDropTarget::OnLeave()
{
}
*/
wxDragResult FlexFileDropTarget::OnData(wxCoord x, wxCoord y, wxDragResult def)
{
	FlexDnDFiles const * flexFiles;

	if ( !GetData() ) {
		wxLogError("Failed to get drop data");
		return wxDragNone;
	}
	const char	*p;
	int		index;
	FlexDirEntry *pDe;

	if (!m_ctrl)
		return wxDragNone;
	flexFiles = ((FlexFileDataObject *)m_dataObject)->GetFlexDnDFiles();
	for (int i = 0; i < flexFiles->GetFileNameCount(); i++) {
		try {
			p = (char *)flexFiles->GetFileName(i);
			flexFiles->GetSrcContainer()->FileCopy(p, p, *m_ctrl->GetContainer());
			pDe = new FlexDirEntry;
			if (m_ctrl->GetContainer()->FindFile(p, *pDe)) {
				wxListItem anItem;

				anItem.m_text   = pDe->GetTotalFileName().chars();
				anItem.m_itemId = 0;
				anItem.m_col    = 0;
				anItem.m_data	= (long)pDe;
				anItem.m_mask   = wxLIST_MASK_TEXT | wxLIST_MASK_DATA;
				index = m_ctrl->InsertItem(anItem);
				m_ctrl->UpdateItem(index, *pDe);
			}
		} catch (FlexException &e) {
			if (e.GetErrorCode() == FERR_DISK_FULL_WRITING) {
				wxMessageBox(e.what(), "FLEXplorer Error", wxOK | wxCENTRE, m_ctrl);
				return wxDragNone;
			} else {
				if (wxMessageBox(e.what(), "FLEXplorer Error",
					wxOK | wxCANCEL | wxCENTRE, m_ctrl) != wxOK)
				return wxDragNone;
			}
		}
	}
	return def;
}
