/*
    fdcframe.cpp


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#endif

#include <misc1.h>
#include <wx/defs.h>
#include <wx/window.h>
#include <wx/bitmap.h>
#include <wx/resource.h>
#include <wx/mdi.h>
#include <wx/statusbr.h>
#include <wx/layout.h>
#include <wx/menu.h>

#include "fdcframe.h"
#include "fcopyman.h"

#ifdef __WXGTK__
#include "bitmaps/container.xpm"
#endif

// Event table
BEGIN_EVENT_TABLE(FlexChildFrame, wxMDIChildFrame)
	EVT_MENU(MDI_COPY, FlexChildFrame::OnCopy)
	EVT_MENU(MDI_PASTE, FlexChildFrame::OnPaste)
	EVT_MENU(MDI_DELETE, FlexChildFrame::OnDelete)
	EVT_MENU(MDI_RENAME, FlexChildFrame::OnRename)
	EVT_MENU(MDI_VIEW, FlexChildFrame::OnView)
	EVT_MENU(MDI_SET_WRITEPROTECT, FlexChildFrame::OnSetWriteProtect)
	EVT_MENU(MDI_CLEAR_WRITEPROTECT, FlexChildFrame::OnClearWriteProtect)
	EVT_MENU(MDI_SET_READPROTECT, FlexChildFrame::OnSetReadProtect)
	EVT_MENU(MDI_CLEAR_READPROTECT, FlexChildFrame::OnClearReadProtect)
	EVT_MENU(MDI_SET_DELETEPROTECT, FlexChildFrame::OnSetDeleteProtect)
	EVT_MENU(MDI_CLEAR_DELETEPROTECT, FlexChildFrame::OnClearDeleteProtect)
	EVT_MENU(MDI_SET_CATALOGPROTECT, FlexChildFrame::OnSetCatalogProtect)
	EVT_MENU(MDI_CLEAR_CATALOGPROTECT, FlexChildFrame::OnClearCatalogProtect)
	EVT_MENU(MDI_CONTAINER_CLOSE, FlexChildFrame::OnCloseChild)
	EVT_MENU(MDI_CONTAINER_PROPERTIES, FlexChildFrame::OnViewProperties)
END_EVENT_TABLE()

FlexChildFrame::FlexChildFrame(
				wxMDIParentFrame *parent,
				const wxString& title,
				const wxPoint& pos,
				const wxSize& size,
				const long style,
				FileContainerIf *container) :
	wxMDIChildFrame(parent, -1, title, pos, size, style)
{
	// Give it an icon
#ifdef __WXMSW__
	SetIcon(wxIcon("CONTAINER_ICON"));
#else
	SetIcon(wxIcon( container_xpm ));
#endif


	// create a list control
	int width, height;
	GetClientSize(&width, &height);
	m_listCtrl = new FlexDiskListCtrl(
		this, LIST_CTRL, wxPoint(0, 0), wxSize(width, height),
		wxLC_REPORT | /*wxLC_EDIT_LABELS |*/ wxSUNKEN_BORDER |
		wxVSCROLL | wxHSCROLL, container);

	wxLayoutConstraints *c = new wxLayoutConstraints;
		c->top.SameAs		(this, wxTop);
		c->left.SameAs		(this, wxLeft);
		c->width.SameAs		(this, wxWidth);
		c->height.SameAs	(this, wxHeight);
		m_listCtrl->SetConstraints(c);

#ifdef __WXMSW__
	wxMenuBar *menuBar = wxResourceCreateMenuBar("containerMenuBarMsw");
#endif
#ifdef __WXGTK__
	// Unfinished: Sort not available on GTK
	//wxMenuBar *menuBar = wxResourceCreateMenuBar("containerMenuBarGtk");
	wxMenuBar *menuBar = wxResourceCreateMenuBar("containerMenuBarMsw");
#endif
	SetMenuBar(menuBar);

#ifdef __WXMSW__
	// create a status bar
	wxStatusBar *sBar = CreateStatusBar();
	const int fieldWidth[2] = { 120, -1 };
	sBar->SetFieldsCount(2, fieldWidth);
#endif

#ifdef __WXMSW__
	// Attach itself for statusbar update
	int id = OBSERVE_STATUS_BAR;
	m_listCtrl->Attach(this);
	Update(&id);
#endif
}

FlexChildFrame::~FlexChildFrame(void)
{
	if (m_clipboardObserver && m_listCtrl)
		m_clipboardObserver->Update(m_listCtrl->GetContainer());
	delete m_listCtrl;
}

void FlexChildFrame::Attach(BObserver *clipboardObserver)
{
	m_clipboardObserver = clipboardObserver;
}

void FlexChildFrame::Detach(BObserver *clipboardObserver)
{
	if (m_clipboardObserver == clipboardObserver)
	m_clipboardObserver = NULL;
}

void FlexChildFrame::OnActivate(wxActivateEvent& event)
{
	if (event.GetActive() && m_listCtrl)
		m_listCtrl->SetFocus();
}

void FlexChildFrame::OnCloseChild(wxCommandEvent& WXUNUSED(event))
{
	Close(TRUE);
}

void FlexChildFrame::Update(const void *pId)
{
	int id = *(int *)pId;
	wxStatusBar *sBar;
	if (m_listCtrl && id == OBSERVE_STATUS_BAR && (sBar = GetStatusBar())) {
		char buf[50];

		sprintf(buf, "%d File(s) selected", m_listCtrl->GetFileCount());
		sBar->SetStatusText(buf, 0);
		sprintf(buf, "%d Byte", m_listCtrl->GetTotalSize());
		sBar->SetStatusText(buf, 1);
	}
}


FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnCopy)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnPaste)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnDelete)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnRename)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnView)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSetWriteProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnClearWriteProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSetReadProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnClearReadProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSetDeleteProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnClearDeleteProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSetCatalogProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnClearCatalogProtect)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnViewProperties)
#ifdef __MSGTK__
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSortFilename)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSortRandom)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSortFilesize)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSortFiledate)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSortFileattr)
FORWARD_MENUCOMMAND_TO(FlexChildFrame, m_listCtrl, OnSortFiledesc)
#endif

