/*
    dircont.h


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __dircont_h__
#define __dircont_h__

#include <misc1.h>
#include <stdio.h>

#include "filecont.h"
#include "flexerr.h"
#include "bstring.h"

class FlexContainerInfo;
class FlexDirEntry;
class BDate;


#define CHECK_NO_DCONTAINER_OPEN			\
	if (!IsContainerOpened()) {			\
		ex.setString(FERR_NO_CONTAINER_OPEN);	\
		throw ex;				\
	}

#define CHECK_DDIRECTORY_ALREADY_OPENED			\
	if (!filePattern.empty()) {			\
		ex.setString(FERR_DIRECTORY_ALREADY_OPENED);\
		throw ex;				\
	}

#define CHECK_DDIRECTORY_NOT_OPENED			\
	if (filePattern.empty()) {			\
		ex.setString(FERR_DIRECTORY_NOT_OPENED);\
		throw ex;				\
	}

class DirectoryContainer : public FileContainerIf
{

private:
	BString	*path;
	int		attributes;
	int		isOpened;
	s_floppy	param;
	BString	filePattern;
	FlexException	ex;

	// needed for Open/CloseDirectory
#ifdef WIN32
	HANDLE		dirHdl;
#else
	DIR		*dirHdl;
#endif

public:
	DirectoryContainer();	// public constructor
	virtual ~DirectoryContainer();		// public destructor

// basic interface (to be used within flexemu)
public:
	virtual int Open(const char *path);
	virtual int Create(const char *dir, const char *name, int t, int s, int fmt = TYPE_DSK_CONTAINER);
	virtual int Close(void);
	virtual int IsContainerOpened(void);
//	virtual int	ReadSector(Byte *buffer, int trk, int sec);
//	virtual int	WriteSector(const Byte *buffer, int trk, int sec);
	virtual int IsWriteProtected(void);
	virtual int IsTrackValid(int track);
	virtual int IsSectorValid(int track, int sector);
	virtual int GetBytesPerSector(void);
	virtual int	GetContainerType(void);

// enhanced interface (to be used within flexdisk)
public:
	virtual int	OpenDirectory(const char *pattern);
	virtual int	NextDirEntry(FlexDirEntry& entry);	
	virtual int	CloseDirectory(void);
	virtual int	FindFile(const char *fileName, FlexDirEntry& entry);	
	virtual int	DeleteFile(const char *fileName);
	virtual int	RenameFile(const char *oldName, const char *newName);
	virtual int	GetInfo(FlexContainerInfo& info);
	virtual int	SetAttributes(const char *fileName, int setMask, int clearMask = ~0);
	virtual void ReadToBuffer(const char *fileName, FlexFileBuffer &buffer);
	virtual int WriteFromBuffer(const char *fileName, const FlexFileBuffer &buffer);
	virtual int	FileCopy(const char *sourceName, const char *destName,
		FileContainerIf& destination);

// private interface
private:
	virtual int OpenForDirectory(const char *path);
	virtual int	ReadSector(Byte *buffer, int trk, int sec);
	virtual int	WriteSector(const Byte *buffer, int trk, int sec);
	int	SetDate(const char *fileName, const BDate& date);
	int	SetRandom(const char *fileName);
	Word IsInFileRandom(const char *ppath, const char *pfilename);
	bool IsFlexFilename(const char *pfilename,
				char *pname = NULL,
				char *pext = NULL);
	virtual void Initialize_header(Byte wp);

};  // class DirectoryContainer

#endif // __dircont_h__
