//
//	da6809.h
//

#ifndef __da6809_h__
#define __da6809_h__

#include <misc1.h>
#include <stdlib.h>
#include "classes.h"


class Da6809 {


protected:

	Mc6809		*cpu;
	char    	code_buf[28];		// buffer for machinecode
	char    	mnem_buf[28];		// buffer for mnemonic

public:
			Da6809(Mc6809 *);	// public constructor
			~Da6809();		// public destructor

	int		disassemble(Word address, Byte *pstep,
				char **pb1, char **pb2);

private:

	Byte 		D_Page10   (Byte *, Word);
	Byte 		D_Page11   (Byte *, Word);
	Byte 		D_Illegal  (char *, Byte, Word);
	Byte 		D_Direct   (char *, Byte, Word);
	Byte 		D_Immediat (char *, Byte, Word);
	Byte 		D_ImmediatL(char *, Byte, Word);
	Byte 		D_Inherent (char *, Byte, Word);
	Byte 		D_Indexed  (char *, Byte, Word);
	Byte 		D_Extended (char *, Byte, Word);
	Byte 		D_Relative (char *, Byte, Word);
	Byte 		D_RelativeL(char *, Byte, Word);
	Byte 		D_Register0(char *, Byte, Word);
	Byte 		D_Register1(char *, Byte, Word);
	Byte 		D_Register2(char *, Byte, Word);

	char  		*IndexedRegister(Byte which);
	char  		*InterRegister(Byte which);
	char  		*StackRegister(Byte which, char *not_stack);
	char		*FlexLabel(Word);
};  // class Da6809

#endif // __da6809_h__

