/*
    contpdlg.cpp


    FLEXplorer, An explorer for any FLEX file or disk container
    Copyright (C) 1998-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <misc1.h>
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

//#define wxUSE_GUI 1
//#define wxUSE_VALIDATORS 1
/*
#include <wx/setup.h>
#include <wx/utils.h>
#include <wx/window.h>
#include <wx/menu.h>
#include <wx/validate.h>
#include <wx/dialog.h>
#include <wx/resource.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>
#include <wx/textctrl.h>
#include <wx/radiobox.h>
*/
//#include <wx/validate.h>
//#include <wx/wx.h>
#ifdef __WXMSW__
#include <direct.h>
#endif

#include "contpdlg.h"

BEGIN_EVENT_TABLE(ContainerPropertiesDialog, wxDialog)
	EVT_BUTTON(IDC_PathButton,  ContainerPropertiesDialog::OnSelectPath)
	EVT_BUTTON(wxID_OK,  ContainerPropertiesDialog::OnOk)
	EVT_BUTTON(wxID_CANCEL, ContainerPropertiesDialog::OnCancel)
	EVT_INIT_DIALOG(ContainerPropertiesDialog::OnInitDialog)
END_EVENT_TABLE()

ContainerPropertiesDialog::ContainerPropertiesDialog(int tracks /* = 80 */,
			int sectors /* = 40 */,
			const char *path /* = "" */) :
	 m_format(0), c_tracks(NULL), c_sectors(NULL), c_path(NULL), c_format(NULL)
{
	m_tracks.Printf("%d", tracks);
	m_sectors.Printf("%d", sectors);
	m_path = path;
}

ContainerPropertiesDialog::~ContainerPropertiesDialog()
{
}

void ContainerPropertiesDialog::OnInitDialog(wxInitDialogEvent &event) {

	c_tracks  = (wxTextCtrl *)wxFindWindowByName("IDC_Tracks",  this);
	c_sectors = (wxTextCtrl *)wxFindWindowByName("IDC_Sectors", this);
	c_path    = (wxTextCtrl *)wxFindWindowByName("IDC_Path",    this);
	c_format  = (wxRadioBox *)wxFindWindowByName("IDC_Format",  this);
	if (c_tracks)  c_tracks->SetValue(m_tracks);
	if (c_sectors) c_sectors->SetValue(m_sectors);
	if (c_path)    c_path->SetValue(m_path);
	if (c_format)  c_format->SetSelection(m_format);
	wxDialog::OnInitDialog(event);
}

void ContainerPropertiesDialog::OnCancel(wxCommandEvent& WXUNUSED(event) )
{
	EndModal(wxID_CANCEL);
}

void ContainerPropertiesDialog::OnOk(wxCommandEvent& WXUNUSED(event) )
{
	if (c_tracks) { m_tracks = c_tracks->GetValue(); };
	if (c_sectors) { m_sectors = c_sectors->GetValue(); };
	if (c_path) { m_path = c_path->GetValue(); };
	if (c_format) { m_format = c_format->GetSelection(); };
	if (atoi(m_tracks.c_str()) < 2 || atoi(m_tracks.c_str()) > 255 ||
		atoi(m_sectors.c_str()) < 6 || atoi(m_sectors.c_str()) > 255 ||
		m_path.IsEmpty()) {
		wxMessageBox("Wrong parameter", "FLEXplorer Error", wxOK | wxCENTRE | wxICON_EXCLAMATION);
	} else
		EndModal(wxID_OK);
}

void ContainerPropertiesDialog::OnSelectPath(wxCommandEvent& WXUNUSED(event) )
{
	wxString containerPath;
#ifdef __WXMSW__
	char                    wd[PATH_MAX];

	getcwd((char *)wd, PATH_MAX);
#endif
	containerPath = wxFileSelector(
		"Input a FLEX file container",
		"",
		NULL,
		"*.DSK",
		"*.*",
		wxSAVE,
		this);
#ifdef __WXMSW__
	chdir((char *)wd);
#endif
	if (!containerPath.IsEmpty()) {
		m_path = containerPath;
		if (c_path)
			c_path->SetValue(m_path);
	}
}

