/*
    brcfile.cpp


    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <errno.h>
#include "brcfile.h"
#include "misc1.h"

BRcFile::BRcFile()
{
}

BRcFile::BRcFile(const char *aFileName) : fileName(aFileName)
{
}

BRcFile::~BRcFile()
{
}

void BRcFile::SetFileName(const char *aFileName)
{
	fileName = aFileName;
}

int BRcFile::SetValue(const char *key, const char *value)
{
	FILE *fp;
	size_t res;
	
	if ((fp = fopen(fileName, "a")) == NULL)
		return errno;
	res = fprintf(fp, "%s\t\t\"%s\"\n", (char *)key, (char *)value);
	fclose(fp);
	if (res != 2)
		return errno;
	return BRC_NO_ERROR;
}

int BRcFile::SetValue(const char *key, int value)
{
	FILE *fp;
	size_t res;
	BString str;
	
	if ((fp = fopen(fileName, "a")) == NULL)
		return errno;
	res = fprintf(fp, "%s\t\t%i\n", (char *)key, value);
	fclose(fp);
	if (res != 2)
		return errno;
	return BRC_NO_ERROR;
}

int BRcFile::GetValue(const char *key, BString &value, int *isInteger)
{
	FILE *fp;
	char def[32];
	char strparm[PATH_MAX];

	if (isInteger)
		*isInteger = 1;
	fp = fopen (fileName, "r");
	if (!fp)
 		return errno;
	while (!feof(fp)) {
		if (fscanf(fp, "%79s %[^\n]\n", def, strparm) == 2 &&
			stricmp(def, key) == 0) {
			value = strparm;
			if (value.firstchar() == '"') {
				if (isInteger)
					*isInteger = 0;
				value.at(1, value.length()-2, value);
			}
			fclose(fp);
			return BRC_NO_ERROR;
		}
	}
	fclose(fp);
	return BRC_NOT_FOUND;
}

int BRcFile::GetValue(const char *key, int *pValue)
{
	BString str;
	int isInt;

	if (int res = GetValue(key, str, &isInt))
		return res;
	if (!isInt)
		return BRC_NO_INTEGER;
	if (sscanf(str, "%i", pValue) != 1)
		return BRC_NO_INTEGER; // returned value is no integer
	return BRC_NO_ERROR;
}

int BRcFile::Initialize(void)
{
	FILE *fp;

	if ((fp = fopen(fileName, "w")) == NULL)
		return errno;
	fclose(fp);
	return BRC_NO_ERROR;
}

