/*
    absgui.h: abstract gui interface.

    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef __absgui_h__
#define __absgui_h__

#include <misc1.h>
#include <stdio.h>
#include <string.h>

#include "e2.h"
#include "e2video.h"
#include "inout.h"
#include "mc6809.h"
#include "bstring.h"

#define MAX_GUIXSIZE	(2)
#define MAX_GUIYSIZE	(3)

#ifdef WIN32
#define COPYTEXT "press Licence button"
#else
#define COPYTEXT "look at file COPYING"
#endif

#define HEADER1 "                 " PROGRAMNAME "\n\
     an MC6809 emulator running FLEX\n                 "
#define HEADER2 "\n\n\
  Copyright (C) 1997-2000 W. Schwotzer\n\n\
" PROGRAMNAME " comes with ABSOLUTELY NO WARRANTY.\n\
This is free software, and you are welcome\n\
    to redistribute it under certain\n\
    conditions. For more information\n\
        " COPYTEXT ".\n\n\
        Wolfgang.Schwotzer@gmx.net\n"

#define CPU_LINES	(15)
#define CPU_LINE_SIZE	(39)

struct sGuiOptions {
	int		argc;
	char		**argv;
	BString		color;
	BString		www_browser;
	BString		doc_dir;
	int	  	inverse;
	int	  	synchronized;
	int	 	switch_sp;
	int	  	guiXSize;
	int	  	guiYSize;
#ifdef WIN32
	HINSTANCE	hInstance;	// handle to current instance
	int	  	nCmdShow;	// show state of window
#endif
};

class AbstractGui {

// private instance variables:

protected:
	Mc6809*		cpu;	// pointer to cpu to send interrupts
	Inout*		io;	// pointer to io-class handling in/output
	E2video*	e2video;// pointer to video control registers
	char 		*program_name;
	unsigned char 	 unused_block[YBLOCK_SIZE];
	char		 exit_flag;	// exit application:
	int		 switch_sp;
	struct sGuiOptions *pOptions;
	char		cpustring[CPU_LINES * CPU_LINE_SIZE];
	Byte		bp_input[2];
	int		guiXSize;
	int		guiYSize;
	Word		word_conv_tab[256];

// Initialisation functions

protected:

	virtual void	update_block(int block_number);	// update one video blk
	virtual void	initialize(struct sGuiOptions *pOptions);
	virtual void	initialize_word_conv_table(int lsb_first);
	virtual void	event_queue(void);		// process event queue
	virtual void	clear_cpuview();
	virtual void	redraw_cpuview(Byte state);
	virtual void	redraw_cpuview_contents(Byte state);
	virtual void	redraw_cpuview_impl(struct s_cpu_status *pstat,
				int state);
	virtual void	text(int x, int y, const char *str, int rev = 0);

// public interface

public:
	virtual void	update_cpuview(Byte state);	// update cpu view
	virtual void	update_1_second(Byte state);	// update each second
	virtual void	set_exit(void);			// set exit flag
	virtual void	update(void);			// update video and
							// event loop
	virtual void 	set_new_state(Byte user_input);	// set cpu to new state
	virtual void	set_bell(int x_percent);	// give a short
							// acoustic signal
	virtual void    output_to_terminal(void);	// set output to terminal
	virtual void    output_to_graphic(void);	// set output to gui
	virtual void	popup_message(char *message);	// popup a message box
	virtual int	gui_type(void);			// return type of gui

// constructor and destructor

public:
	AbstractGui(
	 	Mc6809*			x_cpu,
	 	Inout*			x_io,
	 	E2video*		x_video,
	 	struct sGuiOptions	*options);
	virtual ~AbstractGui();

};

#endif // __absgui_h__

