/*
    flexemu, an MC6809 emulator running FLEX
    Copyright (C) 1997-2000  W. Schwotzer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __acconfig_h__
#define __acconfig_h__

/* Uncomment the following if You want native file system support */

#define NAFS

/* uncomment the following if the Disassembler should display FLEX entry
   addresses by symbolic names */

#define FLEX_LABEL

/* uncomment the following line if You want to compile flexemu with
   an alternative MC6809 processor implementation. It's about 10% faster
   but only aproximates processor cycles. Good for checking processor
   implementations against each other */

/*#define FASTFLEX*/


/********************************************************************/
/* autoheader includes entries between TOP and BOTTOM.              */
/* autoconf adapts these lines according to configure.in            */
/********************************************************************/

@TOP@
@BOTTOM@

/* DO NOT EDIT BEYOND THIS LINE */

#undef HAVE_LIBXTK
#define PROGRAMNAME PACKAGE

#ifdef HAVE_JOYSTICK_H
#define JOYSTICK_IS_PRESENT
#endif

#ifdef HAVE_LINUX_JOYSTICK_H
#define LINUX_JOYSTICK_IS_PRESENT
#endif

#ifdef HAVE_LIBXPM
#define XPM
#endif

#ifdef HAVE_LIBXTK
#define XTK
#endif

#ifndef X_DISPLAY_MISSING
#define X11
#endif

#ifdef HAVE_WINDOWS_H
#define WIN32
#define __WXMSW__
#else
#define __WXGTK__
#endif

#undef HAVE_BOOL

#endif /* ifdef __acconfig_h__ */

