 /* 
  * UAE - The Un*x Amiga Emulator
  * 
  * Interface to the graphics system (X, SVGAlib)
  * 
  * (c) 1995 Bernd Schmidt
  */

typedef long int xcolnr;

extern xcolnr xcolors[4096];

extern int buttonstate[3];
extern int newmousecounters;
extern int lastmx, lastmy;

extern int graphics_init(void);
extern void graphics_leave(void);
extern void handle_events(void);

extern void flush_line(int);
extern void flush_block(int, int);
extern void flush_screen(int, int);

extern int debuggable(void);
extern int needmousehack(void);
extern void togglemouse(void);
extern void LED(int);

extern unsigned long doMask(int p, int bits, int shift);
extern void alloc_colors256(int (*)(int, int, int, xcolnr *));
extern void alloc_colors64k(int, int, int, int, int, int);

struct vidbuf_description
{
    char *bufmem;
    int rowbytes;
    int pixbytes;
    int maxblocklines;
};

extern struct vidbuf_description gfxvidinfo;
